/*
 * Decompiled with CFR 0.152.
 */
package org.labellum.mc.waterflasks.setup;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;
import org.labellum.mc.waterflasks.setup.Registration;

public class AddItemChanceModifier
extends LootModifier {
    private final ItemStack item;
    private final double chance;
    public static final Codec<AddItemChanceModifier> CODEC = RecordCodecBuilder.create(instance -> AddItemChanceModifier.codecStart((RecordCodecBuilder.Instance)instance).and((App)ItemStack.f_41582_.fieldOf("item").forGetter(c -> c.item)).and((App)Codec.DOUBLE.optionalFieldOf("chance", (Object)1.0).forGetter(c -> c.chance)).apply((Applicative)instance, AddItemChanceModifier::new));

    protected AddItemChanceModifier(LootItemCondition[] conditions, ItemStack item, double chance) {
        super(conditions);
        this.item = item;
        this.chance = chance;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> loot, LootContext context) {
        Player player = (Player)context.m_78953_(LootContextParams.f_81456_);
        double bonus = 0.0;
        if (player != null) {
            bonus = player.m_21133_(Attributes.f_22281_) / 30.0;
        }
        if (context.m_230907_().m_188500_() < this.chance + bonus) {
            loot.add((Object)this.item.m_41777_());
        }
        return loot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return (Codec)Registration.ADD_ITEM.get();
    }
}

