/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.profile;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import de.maxhenkel.voicechat.Voicechat;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

public class UsernameCache {
    private final File file;
    private final Gson gson;
    private Map<UUID, String> names;

    public UsernameCache(File file) {
        this.file = file;
        this.gson = new GsonBuilder().create();
        this.names = new ConcurrentHashMap<UUID, String>();
        this.load();
    }

    public void load() {
        if (!this.file.exists()) {
            return;
        }
        try (FileReader reader = new FileReader(this.file);){
            Type usernamesType = new TypeToken<ConcurrentHashMap<UUID, String>>(){}.getType();
            this.names = (Map)this.gson.fromJson((Reader)reader, usernamesType);
        }
        catch (Exception e) {
            Voicechat.LOGGER.error("Failed to load username cache", e);
        }
        if (this.names == null) {
            this.names = new ConcurrentHashMap<UUID, String>();
        }
    }

    public void save() {
        this.file.getParentFile().mkdirs();
        try (FileWriter writer = new FileWriter(this.file);){
            this.gson.toJson(this.names, (Appendable)writer);
        }
        catch (Exception e) {
            Voicechat.LOGGER.error("Failed to save username cache", e);
        }
    }

    @Nullable
    public String getUsername(UUID uuid) {
        return this.names.get(uuid);
    }

    public boolean has(UUID uuid) {
        return this.names.containsKey(uuid);
    }

    public void updateUsername(UUID uuid, String name) {
        this.names.put(uuid, name);
    }

    public void updateUsernameAndSave(UUID uuid, String name) {
        String oldName = this.names.get(uuid);
        if (!name.equals(oldName)) {
            this.names.put(uuid, name);
            this.save();
        }
    }
}

