/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.server;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.intercompatibility.CommonCompatibilityManager;
import de.maxhenkel.voicechat.net.NetManager;
import de.maxhenkel.voicechat.net.SecretPacket;
import de.maxhenkel.voicechat.plugins.PluginManager;
import de.maxhenkel.voicechat.voice.server.Server;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ServerPlayer;

public class ServerVoiceEvents {
    private final Map<UUID, Integer> clientCompatibilities = new ConcurrentHashMap<UUID, Integer>();
    private Server server;

    public ServerVoiceEvents() {
        CommonCompatibilityManager.INSTANCE.onServerStarting(this::serverStarting);
        CommonCompatibilityManager.INSTANCE.onPlayerLoggedIn(this::playerLoggedIn);
        CommonCompatibilityManager.INSTANCE.onPlayerLoggedOut(this::playerLoggedOut);
        CommonCompatibilityManager.INSTANCE.onServerStopping(this::serverStopping);
        CommonCompatibilityManager.INSTANCE.onServerVoiceChatConnected(this::serverVoiceChatConnected);
        CommonCompatibilityManager.INSTANCE.onServerVoiceChatDisconnected(this::serverVoiceChatDisconnected);
        CommonCompatibilityManager.INSTANCE.onPlayerCompatibilityCheckSucceeded(this::playerCompatibilityCheckSucceeded);
        CommonCompatibilityManager.INSTANCE.getNetManager().requestSecretChannel.setServerListener((server, player, handler, packet) -> {
            Voicechat.LOGGER.info("Received secret request of {} ({})", player.m_7755_().getString(), packet.getCompatibilityVersion());
            this.clientCompatibilities.put(player.m_20148_(), packet.getCompatibilityVersion());
            if (packet.getCompatibilityVersion() != Voicechat.COMPATIBILITY_VERSION) {
                Voicechat.LOGGER.warn("Connected client {} has incompatible voice chat version (server={}, client={})", player.m_7755_().getString(), Voicechat.COMPATIBILITY_VERSION, packet.getCompatibilityVersion());
                player.m_213846_(this.getIncompatibleMessage(packet.getCompatibilityVersion()));
            } else {
                this.initializePlayerConnection(player);
            }
        });
    }

    public Component getIncompatibleMessage(int clientCompatibilityVersion) {
        if (clientCompatibilityVersion <= 6) {
            return Component.m_237113_((String)Voicechat.TRANSLATIONS.voicechatNotCompatibleMessage.get().formatted(CommonCompatibilityManager.INSTANCE.getModVersion(), CommonCompatibilityManager.INSTANCE.getModName()));
        }
        return Component.m_264642_((String)"message.voicechat.incompatible_version", (String)"Your voice chat version is not compatible with the servers version.\nPlease install version %s of %s.", (Object[])new Object[]{Component.m_237113_((String)CommonCompatibilityManager.INSTANCE.getModVersion()).m_130940_(ChatFormatting.BOLD), Component.m_237113_((String)CommonCompatibilityManager.INSTANCE.getModName()).m_130940_(ChatFormatting.BOLD)});
    }

    public boolean isCompatible(ServerPlayer player) {
        return this.isCompatible(player.m_20148_());
    }

    public boolean isCompatible(UUID playerUuid) {
        return this.clientCompatibilities.getOrDefault(playerUuid, -1) == Voicechat.COMPATIBILITY_VERSION;
    }

    public void serverStarting(MinecraftServer mcServer) {
        if (this.server != null) {
            this.server.close();
            this.server = null;
        }
        if (!(mcServer instanceof DedicatedServer) && VoicechatClient.CLIENT_CONFIG != null && !VoicechatClient.CLIENT_CONFIG.runLocalServer.get().booleanValue()) {
            Voicechat.LOGGER.info("Disabling voice chat in singleplayer", new Object[0]);
            return;
        }
        if (mcServer instanceof DedicatedServer && !mcServer.m_129797_()) {
            Voicechat.LOGGER.warn("Running in offline mode - Voice chat encryption is not secure!", new Object[0]);
        }
        try {
            this.server = new Server(mcServer);
            this.server.start();
            PluginManager.instance().onServerStarted();
        }
        catch (Exception e) {
            Voicechat.LOGGER.error("Failed to start voice chat server", e);
        }
    }

    public void initializePlayerConnection(ServerPlayer player) {
        if (this.server == null) {
            return;
        }
        CommonCompatibilityManager.INSTANCE.emitPlayerCompatibilityCheckSucceeded(player);
        UUID secret = this.server.generateNewSecret(player.m_20148_());
        if (secret == null) {
            Voicechat.LOGGER.warn("Player already requested secret - ignoring", new Object[0]);
            return;
        }
        NetManager.sendToClient(player, new SecretPacket(player, secret, this.server.getPort(), Voicechat.SERVER_CONFIG));
        Voicechat.LOGGER.info("Sent secret to {}", player.m_7755_().getString());
    }

    public void playerLoggedIn(final ServerPlayer serverPlayer) {
        if (this.server != null) {
            this.server.onPlayerLoggedIn(serverPlayer);
        }
        if (!Voicechat.SERVER_CONFIG.forceVoiceChat.get().booleanValue()) {
            return;
        }
        final Timer timer = new Timer("%s-login-timer".formatted(serverPlayer.m_36316_().getName()), true);
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                timer.cancel();
                timer.purge();
                if (!serverPlayer.f_8924_.m_130010_()) {
                    return;
                }
                if (!serverPlayer.f_8906_.m_6198_()) {
                    return;
                }
                if (!ServerVoiceEvents.this.isCompatible(serverPlayer)) {
                    serverPlayer.f_8924_.execute(() -> serverPlayer2.f_8906_.m_9942_((Component)Component.m_237113_((String)Voicechat.TRANSLATIONS.forceVoicechatKickMessage.get().formatted(CommonCompatibilityManager.INSTANCE.getModName(), CommonCompatibilityManager.INSTANCE.getModVersion()))));
                }
            }
        }, Voicechat.SERVER_CONFIG.loginTimeout.get().intValue());
    }

    public void playerLoggedOut(ServerPlayer player) {
        this.clientCompatibilities.remove(player.m_20148_());
        if (this.server == null) {
            return;
        }
        this.server.onPlayerLoggedOut(player);
        Voicechat.LOGGER.info("Disconnecting client {}", player.m_7755_().getString());
    }

    public void serverVoiceChatConnected(ServerPlayer serverPlayer) {
        if (this.server == null) {
            return;
        }
        this.server.onPlayerVoicechatConnect(serverPlayer);
    }

    public void serverVoiceChatDisconnected(UUID uuid) {
        if (this.server == null) {
            return;
        }
        this.server.onPlayerVoicechatDisconnect(uuid);
    }

    public void playerCompatibilityCheckSucceeded(ServerPlayer player) {
        if (this.server == null) {
            return;
        }
        this.server.onPlayerCompatibilityCheckSucceeded(player);
    }

    @Nullable
    public Server getServer() {
        return this.server;
    }

    public void serverStopping(MinecraftServer mcServer) {
        if (this.server != null) {
            this.server.close();
            this.server = null;
        }
    }
}

