/*
 * Decompiled with CFR 0.152.
 */
package com.ljuangbminecraft.tfcchannelcasting.common.recipes.outputs;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ljuangbminecraft.tfcchannelcasting.common.recipes.outputs.ModifyCondition;
import com.ljuangbminecraft.tfcchannelcasting.common.recipes.outputs.ModifyConditions;
import net.dries007.tfc.common.recipes.outputs.ItemStackModifier;
import net.dries007.tfc.common.recipes.outputs.ItemStackModifiers;
import net.dries007.tfc.util.JsonHelpers;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;

public record ConditionalItemStackModifier(ModifyCondition condition, ItemStackModifier[] nestedModifiers, ItemStackModifier[] elseNestedModifiers) implements ItemStackModifier
{
    public ItemStack apply(ItemStack stack, ItemStack input) {
        if (this.condition.shouldApply(stack, input)) {
            for (ItemStackModifier mod : this.nestedModifiers) {
                stack = mod.apply(stack, input);
            }
        } else {
            for (ItemStackModifier mod : this.elseNestedModifiers) {
                stack = mod.apply(stack, input);
            }
        }
        return stack;
    }

    public Serializer serializer() {
        return Serializer.INSTANCE;
    }

    public static enum Serializer implements ItemStackModifier.Serializer<ConditionalItemStackModifier>
    {
        INSTANCE;


        public ConditionalItemStackModifier fromJson(JsonObject json) {
            ModifyCondition condition = ModifyConditions.fromJson((JsonElement)JsonHelpers.m_13930_((JsonObject)json, (String)"condition"));
            ItemStackModifier[] modifiers = Serializer.getModifers(JsonHelpers.m_13933_((JsonObject)json, (String)"modifiers"));
            ItemStackModifier[] elseModifiers = Serializer.getModifers(JsonHelpers.m_13832_((JsonObject)json, (String)"else_modifiers", (JsonArray)new JsonArray()));
            return new ConditionalItemStackModifier(condition, modifiers, elseModifiers);
        }

        private static ItemStackModifier[] getModifers(JsonArray modifiersJson) {
            ItemStackModifier[] modifiers = new ItemStackModifier[modifiersJson.size()];
            for (int i = 0; i < modifiers.length; ++i) {
                modifiers[i] = ItemStackModifiers.fromJson((JsonElement)modifiersJson.get(i));
            }
            return modifiers;
        }

        public ConditionalItemStackModifier fromNetwork(FriendlyByteBuf buffer) {
            ModifyCondition condition = ModifyConditions.fromNetwork(buffer);
            ItemStackModifier[] modifiers = Serializer.getModifersFromNetwork(buffer);
            ItemStackModifier[] elseModifiers = Serializer.getModifersFromNetwork(buffer);
            return new ConditionalItemStackModifier(condition, modifiers, elseModifiers);
        }

        private static ItemStackModifier[] getModifersFromNetwork(FriendlyByteBuf buffer) {
            int count = buffer.m_130242_();
            ItemStackModifier[] modifiers = new ItemStackModifier[count];
            for (int i = 0; i < count; ++i) {
                modifiers[i] = ItemStackModifiers.fromNetwork((FriendlyByteBuf)buffer);
            }
            return modifiers;
        }

        public void toNetwork(ConditionalItemStackModifier modifier, FriendlyByteBuf buffer) {
            modifier.condition.toNetwork(buffer);
            Serializer.modifiersToNetwork(modifier.nestedModifiers, buffer);
            Serializer.modifiersToNetwork(modifier.elseNestedModifiers, buffer);
        }

        private static void modifiersToNetwork(ItemStackModifier[] modifiers, FriendlyByteBuf buffer) {
            buffer.m_130130_(modifiers.length);
            for (ItemStackModifier mod : modifiers) {
                mod.toNetwork(buffer);
            }
        }
    }
}

