/*
 * Decompiled with CFR 0.152.
 */
package com.ljuangbminecraft.tfcchannelcasting.common.blocks;

import com.ljuangbminecraft.tfcchannelcasting.common.ChannelFlow;
import com.ljuangbminecraft.tfcchannelcasting.common.blockentities.TFCCCBlockEntities;
import com.ljuangbminecraft.tfcchannelcasting.common.blocks.MoldBlock;
import java.util.Map;
import java.util.Optional;
import net.dries007.tfc.common.blockentities.CrucibleBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.DirectionPropertyBlock;
import net.dries007.tfc.common.blocks.EntityBlockExtension;
import net.dries007.tfc.common.blocks.ExtendedBlock;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.devices.CrucibleBlock;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ChannelBlock
extends ExtendedBlock
implements EntityBlockExtension {
    public static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = (Map)PipeBlock.f_55154_.entrySet().stream().filter(facing -> facing.getKey() != Direction.UP).collect(Util.m_137448_());
    public static final BooleanProperty NORTH = PipeBlock.f_55148_;
    public static final BooleanProperty EAST = PipeBlock.f_55149_;
    public static final BooleanProperty SOUTH = PipeBlock.f_55150_;
    public static final BooleanProperty WEST = PipeBlock.f_55151_;
    public static final BooleanProperty DOWN = PipeBlock.f_55153_;
    public static final BooleanProperty TRIGGERED = BlockStateProperties.f_61360_;
    public static final BooleanProperty WITH_METAL = BooleanProperty.m_61465_((String)"with_metal");
    private static final VoxelShape[] SHAPES = new VoxelShape[16];

    private static BlockState updateConnectedSides(LevelAccessor level, BlockPos pos, BlockState state) {
        for (Direction dir : Direction.values()) {
            if (dir == Direction.UP) continue;
            int maxDistance = dir == Direction.DOWN ? 127 : 1;
            boolean isAdjacentConnectable = false;
            for (int i = 1; i < maxDistance + 1; i = (int)((byte)(i + 1))) {
                BlockPos relative = pos.m_5484_(dir, i);
                BlockState blockState = level.m_8055_(relative);
                Block block = blockState.m_60734_();
                if (block instanceof ChannelBlock || block instanceof CrucibleBlock || block instanceof MoldBlock) {
                    isAdjacentConnectable = true;
                    break;
                }
                if (!blockState.m_60795_()) break;
            }
            state = (BlockState)state.m_61124_((Property)DirectionPropertyBlock.getProperty((Direction)dir), (Comparable)Boolean.valueOf(isAdjacentConnectable));
        }
        return state;
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (!level.m_5776_()) {
            level.m_141902_(pos, (BlockEntityType)TFCCCBlockEntities.CHANNEL.get()).ifPresent(channel -> channel.notifyBrokenLink(channel.getNumberOfFlows()));
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public void onBlockExploded(BlockState state, Level level, BlockPos pos, Explosion explosion) {
        if (!level.m_5776_()) {
            level.m_141902_(pos, (BlockEntityType)TFCCCBlockEntities.CHANNEL.get()).ifPresent(channel -> channel.notifyBrokenLink(channel.getNumberOfFlows()));
        }
        super.onBlockExploded(state, level, pos, explosion);
    }

    public ChannelBlock(ExtendedProperties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)TRIGGERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WITH_METAL, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES[((Boolean)state.m_61143_((Property)NORTH) != false ? 1 << Direction.NORTH.m_122416_() : 0) | ((Boolean)state.m_61143_((Property)EAST) != false ? 1 << Direction.EAST.m_122416_() : 0) | ((Boolean)state.m_61143_((Property)SOUTH) != false ? 1 << Direction.SOUTH.m_122416_() : 0) | ((Boolean)state.m_61143_((Property)WEST) != false ? 1 << Direction.WEST.m_122416_() : 0)];
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState adjacentState, LevelAccessor level, BlockPos pos, BlockPos adjacentPos) {
        return ChannelBlock.updateConnectedSides(level, pos, state);
    }

    public void m_6861_(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        boolean flag = pLevel.m_276867_(pPos) || pLevel.m_276867_(pPos.m_7494_());
        boolean flag1 = (Boolean)pState.m_61143_((Property)TRIGGERED);
        if (flag && !flag1) {
            this.activate((LevelAccessor)pLevel, pPos);
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)TRIGGERED, (Comparable)Boolean.valueOf(true)), 4);
        } else if (!flag && flag1) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)), 4);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{EAST, SOUTH, WEST, NORTH, DOWN, TRIGGERED, WITH_METAL});
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.activate((LevelAccessor)level, pos);
        }
        return InteractionResult.FAIL;
    }

    public boolean activate(LevelAccessor level, BlockPos pos) {
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            Optional crucible = level.m_141902_(pos.m_121945_(dir), (BlockEntityType)TFCBlockEntities.CRUCIBLE.get());
            if (!crucible.isPresent()) continue;
            ChannelFlow.fromCrucible(level, (CrucibleBlockEntity)crucible.get(), pos);
            return true;
        }
        return false;
    }

    static {
        VoxelShape base = ChannelBlock.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)5.0, (double)11.0);
        VoxelShape east = ChannelBlock.m_49796_((double)11.0, (double)0.0, (double)5.0, (double)16.0, (double)5.0, (double)11.0);
        VoxelShape south = ChannelBlock.m_49796_((double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)5.0, (double)16.0);
        VoxelShape west = ChannelBlock.m_49796_((double)0.0, (double)0.0, (double)5.0, (double)5.0, (double)5.0, (double)11.0);
        VoxelShape north = ChannelBlock.m_49796_((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)5.0, (double)10.0);
        VoxelShape[] directions = new VoxelShape[]{south, west, north, east};
        for (int i = 0; i < SHAPES.length; ++i) {
            VoxelShape shape = base;
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if ((i >> direction.m_122416_() & 1) != 1) continue;
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)directions[direction.m_122416_()]);
            }
            ChannelBlock.SHAPES[i] = shape;
        }
    }
}

