/*
 * Decompiled with CFR 0.152.
 */
package com.ljuangbminecraft.tfcchannelcasting.common;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.ljuangbminecraft.tfcchannelcasting.common.blockentities.ChannelBlockEntity;
import com.ljuangbminecraft.tfcchannelcasting.common.blockentities.MoldBlockEntity;
import com.ljuangbminecraft.tfcchannelcasting.common.blockentities.TFCCCBlockEntities;
import com.ljuangbminecraft.tfcchannelcasting.common.blocks.ChannelBlock;
import com.ljuangbminecraft.tfcchannelcasting.common.blocks.MoldBlock;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.dries007.tfc.common.blockentities.CrucibleBlockEntity;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class ChannelFlow {
    public static void fromCrucible(LevelAccessor level, CrucibleBlockEntity source, BlockPos originChannel) {
        Optional<IFluidHandler> iFldHandler = MoldBlockEntity.getFluidHandlerIfAppropriate(source, Optional.empty());
        if (iFldHandler.isEmpty()) {
            return;
        }
        FluidStack fluidStack = iFldHandler.get().drain(1, IFluidHandler.FluidAction.SIMULATE);
        Fluid fluid = fluidStack.getFluid();
        int counter = 0;
        HashBiMap channelsAndMolds = HashBiMap.create();
        HashMap<Object, List<BlockPos>> neighbors = new HashMap<Object, List<BlockPos>>();
        ArrayDeque<BlockPos> pendingVisit = new ArrayDeque<BlockPos>();
        HashSet<BlockPos> molds = new HashSet<BlockPos>();
        pendingVisit.add(originChannel);
        while (pendingVisit.size() > 0) {
            BlockPos current = (BlockPos)pendingVisit.pop();
            if (channelsAndMolds.containsValue((Object)current)) continue;
            channelsAndMolds.put((Object)counter, (Object)current);
            ++counter;
            List<BlockPos> adjacentChannels = ChannelFlow.findAdjacent(level, current, false);
            List<BlockPos> adjacentMolds = ChannelFlow.findAdjacent(level, current, true);
            adjacentChannels.stream().forEach(adj -> pendingVisit.add((BlockPos)adj));
            molds.addAll(adjacentMolds);
            neighbors.put(current, adjacentChannels);
            ((List)neighbors.get(current)).addAll(adjacentMolds);
        }
        molds.removeIf(pos -> {
            Optional moldEnt = level.m_141902_(pos, (BlockEntityType)TFCCCBlockEntities.MOLD_TABLE.get());
            if (moldEnt.isEmpty()) {
                return true;
            }
            if (!((MoldBlockEntity)((Object)((Object)moldEnt.get()))).getOutputStack().m_41619_()) {
                return true;
            }
            FluidStack outputDrop = ((IFluidHandler)iFldHandler.get()).drain(1, IFluidHandler.FluidAction.SIMULATE);
            return !ChannelFlow.couldBeFilled((IItemHandlerModifiable)((MoldBlockEntity)((Object)((Object)moldEnt.get()))).getInventory(), outputDrop, 0);
        });
        if (molds.size() == 0) {
            return;
        }
        for (BlockPos mold2 : molds) {
            channelsAndMolds.put((Object)counter, (Object)mold2);
            ++counter;
        }
        int[][] graph = new int[channelsAndMolds.size()][channelsAndMolds.size()];
        double[][] heuristic = new double[channelsAndMolds.size()][channelsAndMolds.size()];
        for (BlockPos channel2 : channelsAndMolds.values()) {
            if (!neighbors.containsKey(channel2)) continue;
            for (BlockPos neighborChannelOrMold : (List)neighbors.get(channel2)) {
                int x = (Integer)channelsAndMolds.inverse().get((Object)channel2);
                if (!channelsAndMolds.containsValue((Object)neighborChannelOrMold)) continue;
                int y = (Integer)channelsAndMolds.inverse().get((Object)neighborChannelOrMold);
                graph[x][y] = 1;
                if (heuristic[x][y] != 0.0) continue;
                double d = Math.sqrt(channel2.m_123331_((Vec3i)neighborChannelOrMold));
                heuristic[y][x] = d;
                heuristic[x][y] = d;
            }
        }
        HashMap<BlockPos, Pair> flowSource = new HashMap<BlockPos, Pair>();
        HashMap<BlockPos, Integer> nFlows = new HashMap<BlockPos, Integer>();
        for (BlockPos mold3 : molds) {
            List<BlockPos> path = ChannelFlow.aStar(graph, heuristic, 0, (Integer)channelsAndMolds.inverse().get((Object)mold3)).stream().map(arg_0 -> ((BiMap)channelsAndMolds).get(arg_0)).toList();
            for (int i = 0; i < path.size() - 1; ++i) {
                BlockPos currentChannel = path.get(i);
                BlockPos channelSource = path.get(i + 1);
                BlockPos relative = channelSource.m_121955_((Vec3i)currentChannel.m_142393_(-1));
                int distance = Math.abs(relative.m_123341_() + relative.m_123342_() + relative.m_123343_());
                BlockPos normal = new BlockPos(relative.m_123341_() / distance, relative.m_123342_() / distance, relative.m_123343_() / distance);
                flowSource.put(currentChannel, Pair.of((Object)Direction.m_122378_((int)normal.m_123341_(), (int)normal.m_123342_(), (int)normal.m_123343_()), (Object)((byte)distance)));
                nFlows.put(channelSource, nFlows.getOrDefault(channelSource, 0) + 1);
            }
        }
        for (BlockPos channelOrMold : flowSource.keySet()) {
            level.m_141902_(channelOrMold, (BlockEntityType)TFCCCBlockEntities.CHANNEL.get()).ifPresent(channel -> channel.setLinkProperties((Pair<Direction, Byte>)((Pair)flowSource.get(channelOrMold)), true, (Integer)nFlows.get(channelOrMold), ForgeRegistries.FLUIDS.getKey((Object)fluid)));
            level.m_141902_(channelOrMold, (BlockEntityType)TFCCCBlockEntities.MOLD_TABLE.get()).ifPresent(mold -> mold.setSource(source.m_58899_(), fluid, (Pair<Direction, Byte>)((Pair)flowSource.get(channelOrMold))));
        }
        BlockPos pos2 = source.m_58899_().m_121955_((Vec3i)originChannel.m_142393_(-1));
        ((ChannelBlockEntity)((Object)level.m_141902_(originChannel, (BlockEntityType)TFCCCBlockEntities.CHANNEL.get()).get())).setLinkProperties((Pair<Direction, Byte>)Pair.of((Object)Direction.m_122378_((int)pos2.m_123341_(), (int)pos2.m_123342_(), (int)pos2.m_123343_()), (Object)1), false, (Integer)nFlows.get(originChannel), ForgeRegistries.FLUIDS.getKey((Object)fluid));
    }

    private static List<BlockPos> findAdjacent(LevelAccessor level, BlockPos current, boolean findMolds) {
        ArrayList<BlockPos> adjacent = new ArrayList<BlockPos>();
        block0: for (Direction dir : Direction.values()) {
            if (dir == Direction.UP) continue;
            int maxDistance = dir == Direction.DOWN ? 127 : 1;
            for (int i = 1; i < maxDistance + 1; i = (int)((byte)(i + 1))) {
                BlockPos relative = current.m_5484_(dir, i);
                BlockState blockState = level.m_8055_(relative);
                if (findMolds && blockState.m_60734_() instanceof MoldBlock) {
                    adjacent.add(relative);
                    continue block0;
                }
                if (!findMolds && blockState.m_60734_() instanceof ChannelBlock) {
                    adjacent.add(relative);
                    continue block0;
                }
                if (!blockState.m_60795_()) continue block0;
            }
        }
        return adjacent;
    }

    private static List<Integer> aStar(int[][] graph, double[][] heuristic, int start, int goal) {
        int[] distances = new int[graph.length];
        Arrays.fill(distances, Integer.MAX_VALUE);
        distances[start] = 0;
        int[] parent = new int[graph.length];
        double[] priorities = new double[graph.length];
        Arrays.fill(priorities, 2.147483647E9);
        priorities[start] = heuristic[start][goal];
        boolean[] visited = new boolean[graph.length];
        while (true) {
            int i;
            double lowestPriority = 2.147483647E9;
            int lowestPriorityIndex = -1;
            for (i = 0; i < priorities.length; ++i) {
                if (!(priorities[i] < lowestPriority) || visited[i]) continue;
                lowestPriority = priorities[i];
                lowestPriorityIndex = i;
            }
            if (lowestPriorityIndex == -1) {
                throw new IllegalArgumentException("Illegal graph! No connection between start and end.");
            }
            if (lowestPriorityIndex == goal) {
                ArrayList<Integer> finalPath = new ArrayList<Integer>();
                int currentIndex = lowestPriorityIndex;
                while (currentIndex != start) {
                    finalPath.add(currentIndex);
                    currentIndex = parent[currentIndex];
                }
                finalPath.add(start);
                return finalPath;
            }
            for (i = 0; i < graph[lowestPriorityIndex].length; ++i) {
                if (graph[lowestPriorityIndex][i] == 0 || visited[i] || distances[lowestPriorityIndex] + graph[lowestPriorityIndex][i] >= distances[i]) continue;
                distances[i] = distances[lowestPriorityIndex] + graph[lowestPriorityIndex][i];
                parent[i] = lowestPriorityIndex;
                priorities[i] = (double)distances[i] + heuristic[i][goal];
            }
            visited[lowestPriorityIndex] = true;
        }
    }

    public static boolean couldBeFilled(IItemHandlerModifiable inventory, FluidStack fluidStack, int slot) {
        if (!fluidStack.isEmpty()) {
            ItemStack mergeStack = inventory.getStackInSlot(slot);
            return mergeStack.getCapability(Capabilities.FLUID).map(fluidCap -> {
                int filled = fluidCap.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE);
                return filled > 0;
            }).orElse(false);
        }
        return false;
    }
}

