/*
 * Decompiled with CFR 0.152.
 */
package com.ljuangbminecraft.tfcchannelcasting.client;

import com.ljuangbminecraft.tfcchannelcasting.client.FluidRenderHelpers;
import com.ljuangbminecraft.tfcchannelcasting.common.blockentities.MoldBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Optional;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.common.capabilities.MoldLike;
import net.dries007.tfc.common.recipes.HeatingRecipe;
import net.dries007.tfc.util.Metal;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.registries.ForgeRegistries;

public class MoldBlockEntityRenderer
implements BlockEntityRenderer<MoldBlockEntity> {
    public void render(MoldBlockEntity mold, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        ItemStack moldStack;
        MoldLike moldItem;
        VertexConsumer builder = buffer.m_6299_(RenderType.m_110463_());
        if (mold.hasSource()) {
            ResourceLocation texture = IClientFluidTypeExtensions.of((FluidType)mold.getSourceFluid().getFluidType()).getFlowingTexture();
            int color = RenderHelpers.getFluidColor((Fluid)mold.getSourceFluid());
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(RenderHelpers.BLOCKS_ATLAS).apply(texture);
            FluidRenderHelpers.renderFlow(poseStack, builder, sprite, color, combinedLight, combinedOverlay, mold.getFlowSource(), true);
            if (mold.getFlowSource().getLeft() == Direction.UP) {
                FluidRenderHelpers.renderFlowCenter(poseStack, builder, sprite, color, combinedLight, combinedOverlay);
            }
        }
        if ((moldItem = MoldLike.get((ItemStack)(moldStack = mold.getMoldStack()))) != null) {
            FluidStack fluidInTank = moldItem.getFluidInTank(0);
            float fillPercent = mold.getOutputStack().m_41619_() ? (float)fluidInTank.getAmount() / (float)moldItem.getTankCapacity(0) : 1.0f;
            if (fillPercent > 0.0f) {
                HeatingRecipe recipe;
                Optional<Object> optMetal = mold.getOutputStack().m_41619_() ? Optional.of(Metal.get((Fluid)fluidInTank.getFluid())) : Optional.ofNullable((recipe = HeatingRecipe.getRecipe((ItemStack)mold.getOutputStack())) == null ? null : Metal.get((Fluid)recipe.getDisplayOutputFluid().getFluid()));
                optMetal.ifPresent(metal -> {
                    if (moldItem.getTemperature() < metal.getMeltTemperature()) {
                        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(RenderHelpers.BLOCKS_ATLAS).apply(metal.getSoftTextureId());
                        RenderHelpers.renderTexturedQuads((PoseStack)poseStack, (VertexConsumer)builder, (TextureAtlasSprite)sprite, (int)combinedLight, (int)combinedOverlay, (float[][])RenderHelpers.getYVertices((float)0.125f, (float)0.0625f, (float)0.125f, (float)0.875f, (float)((1.0f + fillPercent * 0.95f) / 16.0f), (float)0.875f), (float)12.0f, (float)12.0f, (float)0.0f, (float)0.0f, (float)1.0f, (boolean)true);
                    } else {
                        RenderHelpers.renderFluidFace((PoseStack)poseStack, (FluidStack)fluidInTank, (MultiBufferSource)buffer, (float)0.125f, (float)0.125f, (float)0.875f, (float)0.875f, (float)((1.0f + fillPercent * 0.95f) / 16.0f), (int)combinedOverlay, (int)combinedLight);
                    }
                });
            }
            poseStack.m_85836_();
            ResourceLocation moldLocation = ForgeRegistries.ITEMS.getKey((Object)moldStack.m_41720_());
            ResourceLocation modelLocation = new ResourceLocation("tfcchannelcasting", "mold/" + moldLocation.m_135827_() + "/" + moldLocation.m_135815_());
            BakedModel model = Minecraft.m_91087_().m_91304_().getModel(modelLocation);
            if (model != null) {
                Minecraft.m_91087_().m_91291_().m_115189_(model, ItemStack.f_41583_, combinedLight, combinedOverlay, poseStack, builder);
            }
            poseStack.m_85849_();
        }
    }
}

