/*
 * Decompiled with CFR 0.152.
 */
package com.ljuangbminecraft.tfcchannelcasting.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.dries007.tfc.client.RenderHelpers;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.tuple.Pair;

public class FluidRenderHelpers {
    public static void renderTexturedCuboid(PoseStack poseStack, VertexConsumer buffer, TextureAtlasSprite sprite, int color, int packedLight, int packedOverlay, AABB bounds) {
        FluidRenderHelpers.renderTexturedCuboid(poseStack, buffer, sprite, color, packedLight, packedOverlay, (float)bounds.f_82288_, (float)bounds.f_82289_, (float)bounds.f_82290_, (float)bounds.f_82291_, (float)bounds.f_82292_, (float)bounds.f_82293_);
    }

    public static void renderTexturedCuboid(PoseStack poseStack, VertexConsumer buffer, TextureAtlasSprite sprite, int color, int packedLight, int packedOverlay, float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        FluidRenderHelpers.renderTexturedCuboid(poseStack, buffer, sprite, color, packedLight, packedOverlay, minX, minY, minZ, maxX, maxY, maxZ, 16.0f * (maxX - minX), 16.0f * (maxY - minY), 16.0f * (maxZ - minZ));
    }

    public static void renderTexturedCuboid(PoseStack poseStack, VertexConsumer buffer, TextureAtlasSprite sprite, int color, int packedLight, int packedOverlay, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, float xPixels, float yPixels, float zPixels) {
        FluidRenderHelpers.renderTexturedQuads(poseStack, buffer, sprite, color, packedLight, packedOverlay, RenderHelpers.getXVertices((float)minX, (float)minY, (float)minZ, (float)maxX, (float)maxY, (float)maxZ), zPixels, yPixels, 1.0f, 0.0f, 0.0f);
        FluidRenderHelpers.renderTexturedQuads(poseStack, buffer, sprite, color, packedLight, packedOverlay, RenderHelpers.getYVertices((float)minX, (float)minY, (float)minZ, (float)maxX, (float)maxY, (float)maxZ), zPixels, xPixels, 0.0f, 1.0f, 0.0f);
        FluidRenderHelpers.renderTexturedQuads(poseStack, buffer, sprite, color, packedLight, packedOverlay, RenderHelpers.getZVertices((float)minX, (float)minY, (float)minZ, (float)maxX, (float)maxY, (float)maxZ), xPixels, yPixels, 0.0f, 0.0f, 1.0f);
    }

    public static void renderTexturedQuads(PoseStack poseStack, VertexConsumer buffer, TextureAtlasSprite sprite, int color, int packedLight, int packedOverlay, float[][] vertices, float uSize, float vSize, float normalX, float normalY, float normalZ) {
        for (float[] v : vertices) {
            FluidRenderHelpers.renderTexturedVertex(poseStack, buffer, color, packedLight, packedOverlay, v[0], v[1], v[2], sprite.m_118367_((double)(v[3] * uSize)), sprite.m_118393_((double)(v[4] * vSize)), v[5] * normalX, v[5] * normalY, v[5] * normalZ);
        }
    }

    public static void renderTexturedVertex(PoseStack poseStack, VertexConsumer buffer, int color, int packedLight, int packedOverlay, float x, float y, float z, float u, float v, float normalX, float normalY, float normalZ) {
        buffer.m_252986_(poseStack.m_85850_().m_252922_(), x, y, z).m_193479_(color).m_7421_(u, v).m_85969_(packedLight).m_86008_(packedOverlay).m_252939_(poseStack.m_85850_().m_252943_(), normalX, normalY, normalZ).m_5752_();
    }

    public static void renderFlow(PoseStack poseStack, VertexConsumer buffer, TextureAtlasSprite sprite, int color, int packedLight, int packedOverlay, Pair<Direction, Byte> source, boolean renderFlowSource) {
        VoxelShape renderBox;
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.0, 0.5);
        Direction dir = (Direction)source.getLeft();
        switch (dir) {
            case UP: {
                renderBox = Block.m_49796_((double)6.0, (double)4.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
                break;
            }
            case SOUTH: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
            }
            case WEST: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
            }
            case NORTH: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
            }
            case EAST: {
                renderBox = Block.m_49796_((double)10.0, (double)1.0, (double)6.0, (double)(renderFlowSource ? 22.0 : 17.0), (double)4.0, (double)10.0);
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot render source from direction DOWN");
            }
        }
        poseStack.m_85837_(-0.5, 0.0, -0.5);
        FluidRenderHelpers.renderTexturedCuboid(poseStack, buffer, sprite, color, packedLight, packedOverlay, renderBox.m_83215_());
        poseStack.m_85849_();
        poseStack.m_85836_();
        block10: for (int offset = 1; offset < (Byte)source.getRight(); ++offset) {
            poseStack.m_252880_(0.0f, 1.0f, 0.0f);
            switch (dir) {
                case UP: {
                    FluidRenderHelpers.renderTexturedCuboid(poseStack, buffer, sprite, color, packedLight, packedOverlay, Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0).m_83215_());
                    continue block10;
                }
                default: {
                    throw new IllegalArgumentException("Cannot render source from direction other than UP with source > 1 distance");
                }
            }
        }
        poseStack.m_85849_();
    }

    public static void renderFlowCenter(PoseStack poseStack, VertexConsumer buffer, TextureAtlasSprite sprite, int color, int packedLight, int packedOverlay) {
        VoxelShape renderBox = Block.m_49796_((double)6.0, (double)1.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0);
        FluidRenderHelpers.renderTexturedCuboid(poseStack, buffer, sprite, color, packedLight, packedOverlay, renderBox.m_83215_());
    }
}

