/*
 * Decompiled with CFR 0.152.
 */
package com.koenigstag.tfc_curios_weight;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.ISlotType;

@Mod.EventBusSubscriber(modid="tfc_curios_weight", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.BooleanValue ENABLE_MOD = BUILDER.comment("Whether to enable the mod").define("enable_mod", true);
    private static final ForgeConfigSpec.BooleanValue ENABLE_CURIOS_SLOTS_CHECK = BUILDER.comment("Whether to calculate overweight effects checking Curios slots. Disables the main purpose of this addon").define("enable_curios_slots_weight_check", true);
    public static final ForgeConfigSpec.IntValue CALCULATE_WEIGHT_EACH_N_TICKS = BUILDER.comment("Calculate weight every N ticks. Default: 20 ticks = 1 sec").defineInRange("calculate_weight_each_n_ticks", 20, 1, Integer.MAX_VALUE);
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> SLOT_NAME_STRINGS = BUILDER.comment("WIP. A list of slots to check in weight calculation.").defineListAllowEmpty("curios_slots", List.of(), Config::validateSlotName);
    static final ForgeConfigSpec SPEC = BUILDER.build();
    public static boolean enabled;
    public static boolean enableCuriosWeightCalculations;
    public static List<ISlotType> curios_slots;
    public static int calculateWeightEachNTicks;

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        enabled = (Boolean)ENABLE_MOD.get();
        enableCuriosWeightCalculations = (Boolean)ENABLE_CURIOS_SLOTS_CHECK.get();
        curios_slots = ((List)SLOT_NAME_STRINGS.get()).stream().map(slotId -> (ISlotType)CuriosApi.getSlot((String)slotId, (boolean)Config.getIsClient()).get()).collect(Collectors.toList());
        calculateWeightEachNTicks = (Integer)CALCULATE_WEIGHT_EACH_N_TICKS.get();
    }

    private static boolean getIsClient() {
        return false;
    }

    private static boolean validateSlotName(Object obj) {
        String slotId;
        return obj instanceof String && CuriosApi.getSlot((String)(slotId = (String)obj), (boolean)Config.getIsClient()).isPresent();
    }
}

