/*
 * Decompiled with CFR 0.152.
 */
package com.therighthon.rnr.common.fluid;

import com.therighthon.rnr.common.block.RNRBlocks;
import com.therighthon.rnr.common.fluid.SimpleRNRFluid;
import com.therighthon.rnr.common.item.RNRItems;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.dries007.tfc.common.fluids.ExtendedFluidType;
import net.dries007.tfc.common.fluids.FluidRegistryObject;
import net.dries007.tfc.common.fluids.FluidTypeClientProperties;
import net.dries007.tfc.common.fluids.MixingFluid;
import net.dries007.tfc.common.fluids.TFCFluids;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.registry.RegistrationHelpers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class RNRFluids {
    public static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FLUIDS, (String)"rnr");
    public static final ResourceLocation WATER_STILL = new ResourceLocation("block/water_still");
    public static final ResourceLocation WATER_FLOW = new ResourceLocation("block/water_flow");
    public static final ResourceLocation WATER_OVERLAY = new ResourceLocation("block/water_overlay");
    public static final int ALPHA_MASK = -16777216;
    public static final Map<SimpleRNRFluid, FluidRegistryObject<ForgeFlowingFluid>> SIMPLE_RNR_FLUIDS = Helpers.mapOfKeys(SimpleRNRFluid.class, fluid -> RNRFluids.register(fluid.getId(), properties -> properties.block((Supplier)RNRBlocks.SIMPLE_RNR_FLUIDS.get(fluid)).bucket((Supplier)RNRItems.SIMPLE_RNR_FLUID_BUCKETS.get(fluid)), RNRFluids.waterLike().descriptionId("fluid.rnr." + fluid.getId()).canConvertToSource(false), new FluidTypeClientProperties(fluid.isTransparent() ? 0xFF000000 | fluid.getColor() : fluid.getColor(), WATER_STILL, WATER_FLOW, WATER_OVERLAY, null), MixingFluid.Source::new, MixingFluid.Flowing::new));

    private static FluidType.Properties waterLike() {
        return FluidType.Properties.create().adjacentPathType(BlockPathTypes.WATER).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11778_).canConvertToSource(true).canDrown(true).canExtinguish(true).canHydrate(false).canPushEntity(true).canSwim(true).supportsBoating(true);
    }

    private static <F extends FlowingFluid> FluidRegistryObject<F> register(String name, Consumer<ForgeFlowingFluid.Properties> builder, FluidType.Properties typeProperties, FluidTypeClientProperties clientProperties, Function<ForgeFlowingFluid.Properties, F> sourceFactory, Function<ForgeFlowingFluid.Properties, F> flowingFactory) {
        int index = name.lastIndexOf(47);
        String flowingName = index == -1 ? "flowing_" + name : name.substring(0, index) + "/flowing_" + name.substring(index + 1);
        return RegistrationHelpers.registerFluid((DeferredRegister)TFCFluids.FLUID_TYPES, FLUIDS, (String)name, (String)name, (String)flowingName, builder, () -> new ExtendedFluidType(typeProperties, clientProperties), sourceFactory, flowingFactory);
    }
}

