/*
 * Decompiled with CFR 0.152.
 */
package com.notenoughmail.precisionprospecting.items;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.items.PropickItem;
import net.dries007.tfc.common.items.ProspectResult;
import net.dries007.tfc.common.items.ToolItem;
import net.dries007.tfc.network.PacketHandler;
import net.dries007.tfc.network.ProspectedPacket;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.events.ProspectedEvent;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.PacketDistributor;

public class ProspectorItem
extends ToolItem {
    public int COOLDOWN;
    public Supplier<Integer> PRIMARY_RADIUS;
    public Supplier<Integer> SECONDARY_RADIUS;
    public Supplier<Integer> DISPLACEMENT;
    public TagKey<Block> PROSPECT_TAG;
    private static final Random RANDOM = new Random();
    private final float falseNegativeChance;

    public static Object2IntMap<Block> scanAreaFor(Level level, TagKey<Block> tag, int pX1, int pY1, int pZ1, int pX2, int pY2, int pZ2) {
        Object2IntOpenHashMap results = new Object2IntOpenHashMap();
        for (BlockPos cursor : BlockPos.m_121976_((int)pX1, (int)pY1, (int)pZ1, (int)pX2, (int)pY2, (int)pZ2)) {
            Block block = PropickItem.getRepresentative((Block)level.m_8055_(cursor).m_60734_());
            if (!Helpers.isBlock((Block)block, tag)) continue;
            results.mergeInt((Object)block, 1, Integer::sum);
        }
        return results;
    }

    public ProspectorItem(Tier tier, float attackDamage, float attackSpeed, Item.Properties properties, int cooldown, Supplier<Integer> primaryRadius, Supplier<Integer> secondaryRadius, Supplier<Integer> displacement, TagKey<Block> prospectTag) {
        super(tier, attackDamage, attackSpeed, TFCTags.Blocks.MINEABLE_WITH_PROPICK, properties);
        this.COOLDOWN = cooldown;
        this.PRIMARY_RADIUS = primaryRadius;
        this.SECONDARY_RADIUS = secondaryRadius;
        this.DISPLACEMENT = displacement;
        this.PROSPECT_TAG = prospectTag;
        this.falseNegativeChance = 0.3f - (float)Mth.m_14045_((int)tier.m_6604_(), (int)0, (int)5) * 0.060000002f;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        BlockPos pos = context.m_8083_();
        BlockState state = level.m_8055_(pos);
        Direction direction = context.m_43719_().m_122424_();
        int pR = this.PRIMARY_RADIUS.get();
        int sR = this.SECONDARY_RADIUS.get();
        int di = this.DISPLACEMENT.get();
        int pX1 = pos.m_123341_() - pR;
        int pX2 = pos.m_123341_() + pR;
        int pY1 = pos.m_123342_() - pR;
        int pY2 = pos.m_123342_() + pR;
        int pZ1 = pos.m_123343_() - pR;
        int pZ2 = pos.m_123343_() + pR;
        switch (direction) {
            case UP: {
                pY1 = pos.m_123342_() + di - sR;
                pY2 = pos.m_123342_() + di + sR;
                break;
            }
            case DOWN: {
                pY1 = pos.m_123342_() - di - sR;
                pY2 = pos.m_123342_() - di + sR;
                break;
            }
            case NORTH: {
                pZ1 = pos.m_123343_() - di - sR;
                pZ2 = pos.m_123343_() - di + sR;
                break;
            }
            case SOUTH: {
                pZ1 = pos.m_123343_() + di - sR;
                pZ2 = pos.m_123343_() + di + sR;
                break;
            }
            case EAST: {
                pX1 = pos.m_123341_() + di - sR;
                pX2 = pos.m_123341_() + di + sR;
                break;
            }
            case WEST: {
                pX1 = pos.m_123341_() - di - sR;
                pX2 = pos.m_123341_() - di + sR;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + direction);
            }
        }
        if (player instanceof ServerPlayer) {
            ArrayList stateKeys;
            int amount;
            Object2IntMap<Block> states;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            SoundType sound = state.getSoundType((LevelReader)level, pos, (Entity)player);
            level.m_5594_(player, pos, sound.m_56778_(), SoundSource.PLAYERS, sound.m_56773_(), sound.m_56774_());
            context.m_43722_().m_41622_(1, (LivingEntity)player, p -> p.m_21190_(context.m_43724_()));
            player.m_36335_().m_41524_((Item)this, this.COOLDOWN);
            Block found = state.m_60734_();
            RANDOM.setSeed(Helpers.hash((long)1564454769121215456L, (BlockPos)pos));
            ProspectResult result = Helpers.isBlock((BlockState)state, this.PROSPECT_TAG) ? ProspectResult.FOUND : (RANDOM.nextFloat() < this.falseNegativeChance ? ProspectResult.NOTHING : ((states = ProspectorItem.scanAreaFor(level, this.PROSPECT_TAG, pX1, pY1, pZ1, pX2, pY2, pZ2)).isEmpty() ? ProspectResult.NOTHING : ((amount = states.getOrDefault((Object)(found = (Block)(stateKeys = new ArrayList(states.keySet())).get(RANDOM.nextInt(stateKeys.size()))), 1)) < 10 ? ProspectResult.TRACES : (amount < 20 ? ProspectResult.SMALL : (amount < 40 ? ProspectResult.MEDIUM : (amount < 80 ? ProspectResult.LARGE : ProspectResult.VERY_LARGE))))));
            MinecraftForge.EVENT_BUS.post((Event)new ProspectedEvent(player, result, found));
            PacketHandler.send((PacketDistributor.PacketTarget)PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new ProspectedPacket(found, result));
        }
        return InteractionResult.SUCCESS;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> text, TooltipFlag flag) {
        if (flag.m_7050_()) {
            text.add((Component)Component.m_237110_((String)"tfc.tooltip.propick.accuracy", (Object[])new Object[]{(int)(100.0f * (1.0f - this.falseNegativeChance))}).m_130940_(ChatFormatting.GRAY));
        }
    }
}

