/*
 * Decompiled with CFR 0.152.
 */
package com.notenoughmail.precisionprospecting;

import com.mojang.logging.LogUtils;
import com.notenoughmail.precisionprospecting.ClientEvents;
import com.notenoughmail.precisionprospecting.config.PrecProsConfig;
import com.notenoughmail.precisionprospecting.integration.vexxedvisuals.ModFilePackResources;
import com.notenoughmail.precisionprospecting.items.Registration;
import net.dries007.tfc.common.TFCCreativeTabs;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.locating.IModFile;
import org.slf4j.Logger;

@Mod(value="precisionprospecting")
public class PrecisionProspecting {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final String MODID = "precisionprospecting";
    public static final String MOD_NAME = "Precision Prospecting";

    public PrecisionProspecting() {
        Registration.init();
        PrecProsConfig.register();
        IEventBus modbus = FMLJavaModLoadingContext.get().getModEventBus();
        modbus.addListener(this::addPackFinders);
        modbus.addListener(EventPriority.LOW, this::addItemsToCreativeTabs);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            ClientEvents.init();
        }
    }

    private void addPackFinders(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            IModFileInfo modFileInfo = ModList.get().getModFileById(MODID);
            if (modFileInfo == null) {
                LOGGER.error("Could not find Precision Prospecting mod file info; built-in resource packs will be missing");
                return;
            }
            IModFile modFile = modFileInfo.getFile();
            event.addRepositorySource(consumer -> {
                Pack pack = Pack.m_245429_((String)new ResourceLocation(MODID, "vexxed_items").toString(), (Component)Component.m_237113_((String)"Vexxed Visuals: Precision Prospecting"), (boolean)false, id -> new ModFilePackResources(id, modFile, "resourcepacks/vexxed_compat"), (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_);
                if (pack != null) {
                    consumer.accept(pack);
                }
            });
        }
    }

    private void addItemsToCreativeTabs(BuildCreativeModeTabContentsEvent event) {
        if (event.getTab() == TFCCreativeTabs.METAL.tab().get()) {
            Registration.PROSHAMMERS.values().forEach(arg_0 -> ((BuildCreativeModeTabContentsEvent)event).accept(arg_0));
            Registration.PROSHAMMER_HEADS.values().forEach(arg_0 -> ((BuildCreativeModeTabContentsEvent)event).accept(arg_0));
            Registration.PROSDRILLS.values().forEach(arg_0 -> ((BuildCreativeModeTabContentsEvent)event).accept(arg_0));
            Registration.PROSDRILL_HEADS.values().forEach(arg_0 -> ((BuildCreativeModeTabContentsEvent)event).accept(arg_0));
            Registration.MINERAL_PROSPECTORS.values().forEach(arg_0 -> ((BuildCreativeModeTabContentsEvent)event).accept(arg_0));
            Registration.MINERAL_PROSPECTOR_HEADS.values().forEach(arg_0 -> ((BuildCreativeModeTabContentsEvent)event).accept(arg_0));
        } else if (event.getTab() == TFCCreativeTabs.MISC.tab().get()) {
            event.accept(Registration.FIRED_PROSHAMMER_MOLD);
            event.accept(Registration.UNFIRED_PROSHAMMER_MOLD);
            event.accept(Registration.FIRED_PROSDRILL_MOLD);
            event.accept(Registration.UNFIRED_PROSDRILL_MOLD);
            event.accept(Registration.FIRED_MINERAL_PROSPECTOR_MOLD);
            event.accept(Registration.UNFIRED_MINERAL_PROSPECTOR_MOLD);
        }
    }
}

