/*
 * Decompiled with CFR 0.152.
 */
package com.talons.playershops.block.entity.custom;

import com.talons.playershops.PlayerShopsMain;
import com.talons.playershops.block.ModBlocks;
import com.talons.playershops.block.custom.PlayerShopBlock;
import com.talons.playershops.config.PlayerShopsCommonConfigs;
import com.talons.playershops.screen.PlayerShopMenu;
import com.talons.utils.stacks.UtilItemStack;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerShopBlockEntity
extends BlockEntity
implements MenuProvider {
    private UUID owner = new UUID(0L, 0L);
    private ItemStack selling_item_stack = ItemStack.f_41583_;
    private ItemStack buying_item_stack = ItemStack.f_41583_;
    private boolean teamShop = false;
    public int onTicks = 0;
    public int statingOnTicks = 30;
    public int currentPowerLevel = 0;
    public final ItemStackHandler stockItemHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            PlayerShopBlockEntity.this.sendUpdate();
            if (!((PlayerShopBlockEntity)PlayerShopBlockEntity.this).f_58857_.f_46443_) {
                PlayerShopBlockEntity.this.m_183515_(new CompoundTag());
            }
        }

        public boolean isItemValid(int slot, @NonNull ItemStack stack) {
            return stack.m_41720_() == PlayerShopBlockEntity.this.selling_item_stack.m_41720_();
        }
    };
    private LazyOptional<IItemHandler> lazyStockItemHandler = LazyOptional.of(() -> this.stockItemHandler);
    public final ItemStackHandler coinItemHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            PlayerShopBlockEntity.this.sendUpdate();
            if (!((PlayerShopBlockEntity)PlayerShopBlockEntity.this).f_58857_.f_46443_) {
                PlayerShopBlockEntity.this.m_183515_(new CompoundTag());
            }
        }

        public boolean isItemValid(int slot, @NonNull ItemStack stack) {
            return false;
        }
    };
    private LazyOptional<IItemHandler> lazyCoinItemHandler = LazyOptional.of(() -> this.coinItemHandler);
    private static final String NBT_OWNER_MSB = "owner_msb";
    private static final String NBT_OWNER_LSB = "owner_lsb";
    private static final String SELLING_ITEM_STACK = "selling";
    private static final String BUYING_ITEM_STACK = "buying";
    private static final String STOCK_ITEM_COUNT = "stock_count";
    private static final String COIN_ITEM_COUNT = "coin_count";

    public void setOwner(LivingEntity entity) {
        this.owner = entity.m_20148_();
        this.sendUpdate();
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        final CompoundTag nbtTag = new CompoundTag();
        CompoundTag sellingItemTag = new CompoundTag();
        CompoundTag buyingItemTag = new CompoundTag();
        nbtTag.m_128365_("stock", (Tag)this.stockItemHandler.serializeNBT());
        nbtTag.m_128365_("coin", (Tag)this.coinItemHandler.serializeNBT());
        nbtTag.m_128379_("teamShop", this.teamShop);
        this.selling_item_stack.m_41739_(sellingItemTag);
        nbtTag.m_128365_(SELLING_ITEM_STACK, (Tag)sellingItemTag);
        this.buying_item_stack.m_41739_(buyingItemTag);
        nbtTag.m_128365_(BUYING_ITEM_STACK, (Tag)buyingItemTag);
        int saveStockItemCount = !this.stockItemHandler.getStackInSlot(0).m_41619_() ? this.stockItemHandler.getStackInSlot(0).m_41613_() : 0;
        int saveCoinItemCount = !this.coinItemHandler.getStackInSlot(0).m_41619_() ? this.coinItemHandler.getStackInSlot(0).m_41613_() : 0;
        nbtTag.m_128405_(STOCK_ITEM_COUNT, saveStockItemCount);
        nbtTag.m_128405_(COIN_ITEM_COUNT, saveCoinItemCount);
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, (Function)new Function<BlockEntity, CompoundTag>(){

            @Override
            public CompoundTag apply(BlockEntity blockEntity) {
                return nbtTag;
            }
        });
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag tag = pkt.m_131708_();
        int stock_item_count = tag.m_128451_(STOCK_ITEM_COUNT);
        int coin_item_count = tag.m_128451_(COIN_ITEM_COUNT);
        this.stockItemHandler.deserializeNBT(tag.m_128469_("stock"));
        this.coinItemHandler.deserializeNBT(tag.m_128469_("coin"));
        this.selling_item_stack = ItemStack.m_41712_((CompoundTag)tag.m_128469_(SELLING_ITEM_STACK));
        this.buying_item_stack = ItemStack.m_41712_((CompoundTag)tag.m_128469_(BUYING_ITEM_STACK));
        this.stockItemHandler.getStackInSlot(0).m_41764_(stock_item_count);
        this.coinItemHandler.getStackInSlot(0).m_41764_(coin_item_count);
        this.teamShop = tag.m_128471_("teamShop");
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void onChunkUnloaded() {
        this.m_187482_();
        super.onChunkUnloaded();
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public void sendUpdate() {
        this.m_6596_();
        BlockState defaultBlockState = ((Block)ModBlocks.OAK_PLAYER_SHOP_BLOCK.get()).m_49966_();
        this.f_58857_.m_7260_(this.f_58858_, defaultBlockState, defaultBlockState, 3);
    }

    public boolean isOwner(Block _block, LivingEntity entity) {
        if (!(_block instanceof PlayerShopBlock)) {
            return false;
        }
        if (this.teamShop && PlayerShopsMain.ftbTeamsCompat) {
            return FTBTeamsAPI.api().getManager().arePlayersInSameTeam(this.owner, entity.m_20148_());
        }
        return this.owner.equals(entity.m_20148_());
    }

    public LazyOptional<IItemHandler> getStockOptional() {
        return this.lazyStockItemHandler;
    }

    public LazyOptional<IItemHandler> getCoinOptional() {
        return this.lazyCoinItemHandler;
    }

    public PlayerShopBlockEntity(BlockEntityType<?> entityType, BlockPos p_155229_, BlockState p_155230_) {
        super(entityType, p_155229_, p_155230_);
    }

    public void dropShop(Player player, BlockPos pos) {
        this.dropInv(player.m_20182_());
        this.spawn(this.f_58857_, player.m_20182_(), new ItemStack((ItemLike)player.m_9236_().m_8055_(pos).m_60734_().m_5456_()));
        player.m_9236_().m_7471_(pos, true);
    }

    private void dropInv(Vec3 pos) {
        int drop;
        ItemStack stockStack = this.stockItemHandler.getStackInSlot(0);
        ItemStack profitStack = this.coinItemHandler.getStackInSlot(0);
        int profitStackRemaining = profitStack.m_41613_();
        for (int stockStackRemaining = stockStack.m_41613_(); stockStackRemaining > 0; stockStackRemaining -= drop) {
            drop = Math.min(stockStack.m_41741_(), stockStack.m_41613_());
            this.spawn(this.f_58857_, pos, stockStack, drop);
        }
        while (profitStackRemaining > 0) {
            drop = Math.min(profitStack.m_41741_(), profitStack.m_41613_());
            this.spawn(this.f_58857_, pos, profitStack, drop);
            profitStackRemaining -= drop;
        }
    }

    public void spawn(Level world, Vec3 pos, ItemStack stack, int amount) {
        this.spawn(world, pos, UtilItemStack.setCount(stack, amount));
    }

    public void spawn(Level world, Vec3 pos, ItemStack stack) {
        world.m_7967_((Entity)new ItemEntity(world, pos.f_82479_, pos.f_82480_, pos.f_82481_, stack.m_41777_()));
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"title.playershops.shop");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int p_39954_, Inventory p_39955_, Player p_39956_) {
        return new PlayerShopMenu(p_39954_, p_39955_, this);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == Direction.DOWN) {
                if (((Boolean)PlayerShopsCommonConfigs.HoppersExtract.get()).booleanValue()) {
                    return this.lazyCoinItemHandler.cast();
                }
            } else {
                return this.lazyStockItemHandler.cast();
            }
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyStockItemHandler.invalidate();
        this.lazyCoinItemHandler.invalidate();
    }

    public void setSellingItemStack(ItemStack itemStack) {
        this.selling_item_stack = itemStack;
        this.sendUpdate();
    }

    public void setBuyingItemStack(ItemStack itemStack) {
        this.buying_item_stack = itemStack;
        this.sendUpdate();
    }

    public ItemStack getSellingItemStack() {
        return this.selling_item_stack.m_41777_();
    }

    public ItemStack getBuyingItemStack() {
        return this.buying_item_stack.m_41777_();
    }

    public void swapTeamShop(Player pPlayer) {
        this.teamShop ^= true;
        this.sendUpdate();
        if (this.teamShop) {
            pPlayer.m_5661_((Component)Component.m_237115_((String)"message.playershops.team_shop"), true);
        } else {
            pPlayer.m_5661_((Component)Component.m_237115_((String)"message.playershops.not_team_shop"), true);
        }
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        CompoundTag sellingItemTag = new CompoundTag();
        CompoundTag buyingItemTag = new CompoundTag();
        tag.m_128365_("stock", (Tag)this.stockItemHandler.serializeNBT());
        tag.m_128365_("coin", (Tag)this.coinItemHandler.serializeNBT());
        tag.m_128379_("teamShop", this.teamShop);
        tag.m_128356_(NBT_OWNER_MSB, this.owner.getMostSignificantBits());
        tag.m_128356_(NBT_OWNER_LSB, this.owner.getLeastSignificantBits());
        this.selling_item_stack.m_41739_(sellingItemTag);
        tag.m_128365_(SELLING_ITEM_STACK, (Tag)sellingItemTag);
        this.buying_item_stack.m_41739_(buyingItemTag);
        tag.m_128365_(BUYING_ITEM_STACK, (Tag)buyingItemTag);
        int saveStockItemCount = !this.stockItemHandler.getStackInSlot(0).m_41619_() ? this.stockItemHandler.getStackInSlot(0).m_41613_() : 0;
        int saveCoinItemCount = !this.coinItemHandler.getStackInSlot(0).m_41619_() ? this.coinItemHandler.getStackInSlot(0).m_41613_() : 0;
        tag.m_128405_(STOCK_ITEM_COUNT, saveStockItemCount);
        tag.m_128405_(COIN_ITEM_COUNT, saveCoinItemCount);
        super.m_183515_(tag);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        int stock_item_count = nbt.m_128451_(STOCK_ITEM_COUNT);
        int coin_item_count = nbt.m_128451_(COIN_ITEM_COUNT);
        this.stockItemHandler.deserializeNBT(nbt.m_128469_("stock"));
        this.coinItemHandler.deserializeNBT(nbt.m_128469_("coin"));
        this.teamShop = nbt.m_128471_("teamShop");
        this.owner = new UUID(nbt.m_128454_(NBT_OWNER_MSB), nbt.m_128454_(NBT_OWNER_LSB));
        this.selling_item_stack = ItemStack.m_41712_((CompoundTag)nbt.m_128469_(SELLING_ITEM_STACK));
        this.buying_item_stack = ItemStack.m_41712_((CompoundTag)nbt.m_128469_(BUYING_ITEM_STACK));
        this.stockItemHandler.getStackInSlot(0).m_41764_(stock_item_count);
        this.coinItemHandler.getStackInSlot(0).m_41764_(coin_item_count);
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T be) {
        PlayerShopBlockEntity tile = (PlayerShopBlockEntity)be;
        if (tile.onTicks > 0) {
            --tile.onTicks;
        } else if (tile.currentPowerLevel != 0) {
            tile.currentPowerLevel = 0;
            tile.m_6596_();
        }
    }
}

