/*
 * Decompiled with CFR 0.152.
 */
package com.nebby1999.firmacivplus;

import com.alekiponi.alekiships.client.render.entity.vehicle.RowboatRenderer;
import com.alekiponi.alekiships.client.render.entity.vehicle.SloopConstructionRenderer;
import com.alekiponi.alekiships.client.render.entity.vehicle.SloopRenderer;
import com.alekiponi.alekiships.util.CommonHelper;
import com.alekiponi.firmaciv.client.render.entity.vehicle.CanoeRenderer;
import com.nebby1999.firmacivplus.FirmaCivPlusEntities;
import com.nebby1999.firmacivplus.WatercraftMaterial;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.DyeColor;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.IEventBus;

public final class RenderEventHandler {
    static void init(IEventBus evtBus) {
        evtBus.addListener(RenderEventHandler::registerRenderers);
    }

    private static void registerRenderers(EntityRenderersEvent.RegisterRenderers evt) {
        for (WatercraftMaterial woodEntry : WatercraftMaterial._ALL_WATERCRAFT_MATERIALS) {
            if (woodEntry.isSoftwood()) {
                evt.registerEntityRenderer((EntityType)FirmaCivPlusEntities.getCanoes().get(woodEntry).get(), context -> new CanoeRenderer(context, new ResourceLocation("firmacivplus", "textures/entity/watercraft/dugout_canoe/" + woodEntry.m_7912_() + ".png")));
                continue;
            }
            evt.registerEntityRenderer((EntityType)FirmaCivPlusEntities.getRowboats().get(woodEntry).get(), context -> new RowboatRenderer(context, new ResourceLocation("firmacivplus", "textures/entity/watercraft/rowboat/" + woodEntry.m_7912_()), CommonHelper.mapOfKeys(DyeColor.class, dyeColor -> new ResourceLocation("firmacivplus", "textures/entity/watercraft/rowboat/" + woodEntry.m_7912_() + "/" + dyeColor.m_7912_()))));
            evt.registerEntityRenderer((EntityType)FirmaCivPlusEntities.getSloops().get(woodEntry).get(), context -> new SloopRenderer(context, new ResourceLocation("firmacivplus", "textures/entity/watercraft/sloop/" + woodEntry.m_7912_()), CommonHelper.mapOfKeys(DyeColor.class, dyeColor -> new ResourceLocation("firmacivplus", "textures/entity/watercraft/sloop/" + woodEntry.m_7912_() + "/" + dyeColor.m_7912_()))));
            evt.registerEntityRenderer((EntityType)FirmaCivPlusEntities.getSloopsUnderConstruction().get(woodEntry).get(), context -> new SloopConstructionRenderer(context, new ResourceLocation("firmacivplus", "textures/entity/watercraft/sloop_construction/" + woodEntry.m_7912_() + ".png")));
        }
    }
}

