/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.placeholder.placeholders.world;

import com.google.common.collect.Ordering;
import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.platform.Services;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.SerializationUtils;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActiveEffectPlaceholder
extends Placeholder {
    public ActiveEffectPlaceholder() {
        super("active_effect");
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {
        ResourceLocation key;
        List effects;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        int index = SerializationUtils.deserializeNumber(Integer.class, 0, dps.values.get("effect_index"));
        if (player != null && level != null && (effects = Ordering.natural().reverse().sortedCopy((Iterable)player.m_21220_())).size() >= index + 1 && (key = Services.PLATFORM.getEffectKey(((MobEffectInstance)effects.get(index)).m_19544_())) != null) {
            return key.toString();
        }
        return "";
    }

    @Override
    @Nullable
    public List<String> getValueNames() {
        return List.of("effect_index");
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return I18n.m_118938_((String)"fancymenu.placeholders.world.active_effect", (Object[])new Object[0]);
    }

    @Override
    @Nullable
    public List<String> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.placeholders.world.active_effect.desc", new String[0]));
    }

    @Override
    public String getCategory() {
        return I18n.m_118938_((String)"fancymenu.placeholders.categories.world", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public DeserializedPlaceholderString getDefaultPlaceholderString() {
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        values.put("effect_index", "0");
        return new DeserializedPlaceholderString(this.getIdentifier(), values, "");
    }
}

