/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.placeholder.placeholders.scoreboard;

import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.Scoreboard;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScoreboardHasScorePlaceholder
extends Placeholder {
    public ScoreboardHasScorePlaceholder() {
        super("scoreboard_has_score");
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {
        Scoreboard scoreboard;
        Objective objective;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        String playerName = dps.values.get("player");
        String objectiveName = dps.values.get("objective");
        if (level != null && playerName != null && objectiveName != null && (objective = (scoreboard = level.m_6188_()).m_83477_(objectiveName)) != null) {
            return String.valueOf(scoreboard.m_83461_(playerName, objective));
        }
        return "false";
    }

    @Override
    @Nullable
    public List<String> getValueNames() {
        return List.of("player", "objective");
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return I18n.m_118938_((String)"fancymenu.placeholders.scoreboard.has_score", (Object[])new Object[0]);
    }

    @Override
    @Nullable
    public List<String> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.placeholders.scoreboard.has_score.desc", new String[0]));
    }

    @Override
    public String getCategory() {
        return I18n.m_118938_((String)"fancymenu.placeholders.categories.scoreboard", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public DeserializedPlaceholderString getDefaultPlaceholderString() {
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        values.put("player", "Player1");
        values.put("objective", "score");
        return new DeserializedPlaceholderString(this.getIdentifier(), values, "");
    }
}

