/*
 * Decompiled with CFR 0.152.
 */
package net.bojarsky.ecb.client;

import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ecb", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class CustomDebugHandler {
    private static final Minecraft mc = Minecraft.m_91087_();
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#.#");
    private static long lastMemoryUpdateTime = 0L;
    private static String cachedMemoryInfo = "\u00a78\u00a7l\u041f\u0430\u043c\u044f\u0442\u044c: \u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430...";
    private static String cachedBiomeInfo = "\u00a76\u00a7l\u0411\u0438\u043e\u043c: \u00a7e\u00a7l\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430...";
    private static String cachedEntitiesInfo = "\u00a72\u00a7l\u0421\u0443\u0449\u043d\u043e\u0441\u0442\u0438: \u00a7a\u00a7l\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430...";

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        long currentTime;
        if (event.phase == TickEvent.Phase.END && CustomDebugHandler.mc.f_91074_ != null && (currentTime = System.currentTimeMillis()) - lastMemoryUpdateTime > 3000L) {
            CustomDebugHandler.updateMemoryInfo();
            CustomDebugHandler.updateBiomeInfo();
            CustomDebugHandler.updateEntitiesInfo();
            lastMemoryUpdateTime = currentTime;
        }
    }

    private static void updateMemoryInfo() {
        Runtime runtime = Runtime.getRuntime();
        double usedMB = (double)(runtime.totalMemory() - runtime.freeMemory()) / 1048576.0;
        double maxMB = (double)runtime.maxMemory() / 1048576.0;
        double percentage = (double)(runtime.totalMemory() - runtime.freeMemory()) * 100.0 / (double)runtime.maxMemory();
        cachedMemoryInfo = String.format("\u00a78\u00a7l\u041f\u0430\u043c\u044f\u0442\u044c: %s%% %s/%s MB", DECIMAL_FORMAT.format(percentage), DECIMAL_FORMAT.format(usedMB), DECIMAL_FORMAT.format(maxMB));
    }

    private static void updateBiomeInfo() {
        if (CustomDebugHandler.mc.f_91074_ == null || CustomDebugHandler.mc.f_91074_.m_9236_() == null) {
            return;
        }
        Holder biomeHolder = CustomDebugHandler.mc.f_91074_.m_9236_().m_204166_(CustomDebugHandler.mc.f_91074_.m_20183_());
        String biomeName = biomeHolder.m_203543_().map(ResourceKey::m_135782_).map(ResourceLocation::m_135815_).orElse("unknown");
        biomeName = Arrays.stream(biomeName.split("_")).map(word -> word.substring(0, 1).toUpperCase() + word.substring(1)).collect(Collectors.joining(" "));
        cachedBiomeInfo = "\u00a76\u00a7l\u0411\u0438\u043e\u043c: \u00a7e\u00a7l" + biomeName;
    }

    private static void updateEntitiesInfo() {
        if (CustomDebugHandler.mc.f_91074_ == null || CustomDebugHandler.mc.f_91073_ == null) {
            return;
        }
        int radius = 16;
        int entityCount = CustomDebugHandler.mc.f_91073_.m_6249_((Entity)CustomDebugHandler.mc.f_91074_, CustomDebugHandler.mc.f_91074_.m_20191_().m_82400_((double)radius), e -> !(e instanceof Player)).size();
        cachedEntitiesInfo = "\u00a72\u00a7l\u0421\u0443\u0449\u043d\u043e\u0441\u0442\u0438: \u00a7a\u00a7l" + entityCount;
    }

    @SubscribeEvent
    public static void onDebugRender(RenderGuiOverlayEvent.Pre event) {
        if (event.getOverlay().id().m_135815_().equals("debug_text")) {
            event.setCanceled(true);
            CustomDebugHandler.renderCustomDebug(event.getGuiGraphics());
        }
    }

    private static void renderCustomDebug(GuiGraphics gui) {
        if (!CustomDebugHandler.mc.f_91066_.f_92063_) {
            return;
        }
        int screenWidth = mc.m_91268_().m_85445_();
        int y = 5;
        int lineHeight = 10;
        String title = "\u00a7c\u00a7l\u0414\u043e\u0431\u0440\u043e \u043f\u043e\u0436\u0430\u043b\u043e\u0432\u0430\u0442\u044c \u043d\u0430 \u043b\u0443\u0447\u0448\u0438\u0439 \u0445\u0430\u0440\u0434\u043a\u043e\u0440 \u0441\u0435\u0440\u0432\u0435\u0440 TFC Russia\u00a7r";
        int titleWidth = CustomDebugHandler.mc.f_91062_.m_92895_(title);
        int titleX = (screenWidth - titleWidth) / 2;
        gui.m_280488_(CustomDebugHandler.mc.f_91062_, title, titleX, y, 0xFFFFFF);
        int x = 5;
        int ping = CustomDebugHandler.getPing();
        gui.m_280488_(CustomDebugHandler.mc.f_91062_, String.format("\u00a73\u00a7lFPS: \u00a7b\u00a7l%d \u00a73\u00a7lPing: \u00a7b\u00a7l%d", mc.m_260875_(), ping), x, y += lineHeight * 2, 0xFFFFFF);
        gui.m_280488_(CustomDebugHandler.mc.f_91062_, cachedMemoryInfo, x, y += lineHeight, 0xFFFFFF);
        y += lineHeight;
        if (CustomDebugHandler.mc.f_91074_ != null) {
            gui.m_280488_(CustomDebugHandler.mc.f_91062_, String.format("\u00a77\u00a7l\u041f\u043e\u0437\u0438\u0446\u0438\u044f: \u00a7f\u00a7lX: %.1f Y: %.1f Z: %.1f", CustomDebugHandler.mc.f_91074_.m_20185_(), CustomDebugHandler.mc.f_91074_.m_20186_(), CustomDebugHandler.mc.f_91074_.m_20189_()), x, y, 0xFFFFFF);
            gui.m_280488_(CustomDebugHandler.mc.f_91062_, cachedEntitiesInfo, x, y += lineHeight, 0xFFFFFF);
            Direction direction = CustomDebugHandler.mc.f_91074_.m_6350_();
            gui.m_280488_(CustomDebugHandler.mc.f_91062_, "\u00a76\u00a7l\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435: \u00a7e\u00a7l" + CustomDebugHandler.getFacingName(direction), x, y += lineHeight * 2, 0xFFFFFF);
            gui.m_280488_(CustomDebugHandler.mc.f_91062_, cachedBiomeInfo, x, y += lineHeight, 0xFFFFFF);
        }
    }

    private static int getPing() {
        if (CustomDebugHandler.mc.f_91074_ == null || mc.m_91403_() == null || mc.m_91403_().m_104949_(CustomDebugHandler.mc.f_91074_.m_20148_()) == null) {
            return 0;
        }
        return mc.m_91403_().m_104949_(CustomDebugHandler.mc.f_91074_.m_20148_()).m_105330_();
    }

    private static String getFacingName(Direction direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH -> "\u0421\u0435\u0432\u0435\u0440";
            case Direction.SOUTH -> "\u042e\u0433";
            case Direction.EAST -> "\u0412\u043e\u0441\u0442\u043e\u043a";
            case Direction.WEST -> "\u0417\u0430\u043f\u0430\u0434";
            case Direction.UP -> "\u0412\u0432\u0435\u0440\u0445";
            case Direction.DOWN -> "\u0412\u043d\u0438\u0437";
        };
    }
}

