/*
 * Decompiled with CFR 0.152.
 */
package net.bojarsky.ecb.client;

import java.time.Instant;
import java.util.LinkedList;
import java.util.Queue;
import net.bojarsky.ecb.network.ClientToServerItemSharePacket;
import net.bojarsky.ecb.network.ModNetworking;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ecb", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ClientHandler {
    private static final int MAX_SHARES_PER_PERIOD = 3;
    private static final long PERIOD_MILLISECONDS = 120000L;
    private static final Queue<Long> requestTimestamps = new LinkedList<Long>();

    @SubscribeEvent
    public static void onMouseClickedEvent(ScreenEvent.MouseButtonPressed.Pre event) {
        if (event.getButton() == 2) {
            AbstractContainerScreen screen;
            Slot slot;
            Minecraft mc = Minecraft.m_91087_();
            Screen screen2 = mc.f_91080_;
            if (screen2 instanceof AbstractContainerScreen && (slot = (screen = (AbstractContainerScreen)screen2).getSlotUnderMouse()) != null && slot.m_6657_()) {
                ItemStack stack = slot.m_7993_();
                if (ClientHandler.canShareItem()) {
                    ClientHandler.sendItemToServer(stack);
                    event.setCanceled(true);
                } else {
                    mc.f_91074_.m_213846_(Component.m_130674_((String)"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u043f\u043e\u0434\u043e\u0436\u0434\u0438\u0442\u0435."));
                }
            }
        }
    }

    private static boolean canShareItem() {
        long now = Instant.now().toEpochMilli();
        while (!requestTimestamps.isEmpty() && requestTimestamps.peek() <= now - 120000L) {
            requestTimestamps.poll();
        }
        if (requestTimestamps.size() >= 3) {
            return false;
        }
        requestTimestamps.add(now);
        return true;
    }

    private static void sendItemToServer(ItemStack stack) {
        ModNetworking.getInstance().sendToServer((Object)new ClientToServerItemSharePacket(stack));
    }
}

