/*
 * Decompiled with CFR 0.152.
 */
package com.ankmaniac.decofirmacraft.common.items;

import com.ankmaniac.decofirmacraft.common.blocks.DFCBlocks;
import com.ankmaniac.decofirmacraft.common.blocks.metal.DFCMetal;
import com.ankmaniac.decofirmacraft.common.blocks.rock.CustomDFCRockBlocks;
import com.ankmaniac.decofirmacraft.common.blocks.rock.CustomRockBlocks;
import com.ankmaniac.decofirmacraft.common.blocks.rock.DFCOre;
import com.ankmaniac.decofirmacraft.common.blocks.rock.DFCRock;
import com.ankmaniac.decofirmacraft.common.items.DFCItems;
import java.util.Map;
import java.util.function.Supplier;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.common.blocks.DecorationBlockRegistryObject;
import net.dries007.tfc.common.blocks.OreDeposit;
import net.dries007.tfc.common.blocks.rock.Ore;
import net.dries007.tfc.common.blocks.rock.Rock;
import net.dries007.tfc.common.blocks.rock.RockCategory;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.dries007.tfc.util.Metal;
import net.dries007.tfc.util.SelfTests;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class DFCTabs {
    public static final DeferredRegister<CreativeModeTab> CREATIVE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"dfc");
    public static final CreativeTabHolder ROCKS = DFCTabs.register("rock_tab", () -> new ItemStack((ItemLike)DFCBlocks.CUSTOM_ROCK_BLOCKS.get(Rock.ANDESITE).get((Object)CustomRockBlocks.PILLAR).get()), DFCTabs::fillRock);
    public static final CreativeTabHolder ORES = DFCTabs.register("ore_tab", () -> new ItemStack((ItemLike)DFCBlocks.DFC_ROCK_ORES.get((Object)DFCRock.ARKOSE).get(Ore.DIAMOND).get()), DFCTabs::fillOre);
    public static final CreativeTabHolder METAL = DFCTabs.register("metal_tab", () -> new ItemStack((ItemLike)DFCBlocks.METAL_GATES.get(Metal.Default.WROUGHT_IRON).get()), DFCTabs::fillMetal);
    public static final CreativeTabHolder CERAMICS = DFCTabs.register("ceramics_tab", () -> new ItemStack((ItemLike)DFCBlocks.PAINTED_SHINGLES.get(DyeColor.RED).get()), DFCTabs::fillCeramics);
    public static final CreativeTabHolder MISC = DFCTabs.register("misc_tab", () -> new ItemStack((ItemLike)DFCBlocks.PLAIN_PLASTER.get()), DFCTabs::fillMisc);

    private static void fillRock(CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output out) {
        for (Rock rock : Rock.VALUES) {
            for (CustomRockBlocks customRockBlocks : CustomRockBlocks.VALUES) {
                DFCTabs.accept(out, DFCBlocks.CUSTOM_ROCK_BLOCKS, rock, customRockBlocks);
                if (!customRockBlocks.hasVariants()) continue;
                DFCTabs.accept(out, DFCBlocks.ROCK_DECORATIONS.get(rock).get((Object)customRockBlocks));
            }
        }
        for (DFCRock dFCRock : DFCRock.VALUES) {
            for (Enum enum_ : CustomDFCRockBlocks.VALUES) {
                DFCTabs.accept(out, DFCBlocks.CUSTOM_DFC_ROCK_BLOCKS, dFCRock, enum_);
                if (((CustomDFCRockBlocks)enum_).hasVariants()) {
                    DFCTabs.accept(out, DFCBlocks.DFC_ROCK_DECORATIONS.get((Object)dFCRock).get(enum_));
                }
                if (dFCRock.category() != RockCategory.IGNEOUS_EXTRUSIVE) continue;
                DFCTabs.accept(out, DFCBlocks.DFC_MAGMA_BLOCKS.get((Object)dFCRock));
            }
        }
        for (DFCRock dFCRock : DFCRock.VALUES) {
            for (Enum enum_ : Rock.BlockType.VALUES) {
                DFCTabs.accept(out, DFCBlocks.CUSTOM_ROCK_TYPES, dFCRock, enum_);
                if (!enum_.hasVariants()) continue;
                DFCTabs.accept(out, DFCBlocks.CUSTOM_DFC_ROCK_DECORATIONS.get((Object)dFCRock).get(enum_));
            }
            DFCTabs.accept(out, DFCItems.DFC_BRICKS, dFCRock);
        }
    }

    private static void fillOre(CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output out) {
        for (DFCOre dFCOre : DFCOre.values()) {
            if (!dFCOre.isGraded()) continue;
            DFCTabs.accept(out, DFCBlocks.DFC_SMALL_ORES, dFCOre);
            DFCTabs.accept(out, DFCItems.GRADED_ORES, dFCOre, Ore.Grade.POOR);
            DFCTabs.accept(out, DFCItems.GRADED_ORES, dFCOre, Ore.Grade.NORMAL);
            DFCTabs.accept(out, DFCItems.GRADED_ORES, dFCOre, Ore.Grade.RICH);
        }
        for (DFCOre dFCOre : DFCOre.values()) {
            if (dFCOre.isGraded()) continue;
            DFCTabs.accept(out, DFCItems.ORES, dFCOre);
        }
        for (DFCOre dFCOre : DFCOre.values()) {
            if (dFCOre.isGraded()) {
                DFCBlocks.DFC_GRADED_ORES.values().forEach(map -> ((Map)map.get((Object)ore)).values().forEach(reg -> DFCTabs.accept(out, reg)));
                continue;
            }
            DFCBlocks.DFC_ORES.values().forEach(map -> DFCTabs.accept(out, map, ore));
        }
        for (DFCOre dFCOre : Ore.values()) {
            if (dFCOre.isGraded()) {
                DFCBlocks.DFC_ROCK_GRADED_ORES.values().forEach(arg_0 -> DFCTabs.lambda$fillOre$9((Ore)dFCOre, out, arg_0));
                continue;
            }
            DFCBlocks.DFC_ROCK_ORES.values().forEach(arg_0 -> DFCTabs.lambda$fillOre$10(out, (Ore)dFCOre, arg_0));
        }
        for (DFCOre dFCOre : DFCOre.values()) {
            if (dFCOre.isGraded()) {
                DFCBlocks.DFC_ROCK_DFC_GRADED_ORES.values().forEach(map -> ((Map)map.get((Object)ore)).values().forEach(reg -> DFCTabs.accept(out, reg)));
                continue;
            }
            DFCBlocks.DFC_ROCK_DFC_ORES.values().forEach(map -> DFCTabs.accept(out, map, ore));
        }
        for (DFCOre dFCOre : OreDeposit.values()) {
            DFCBlocks.DFC_ORE_DEPOSITS.values().forEach(arg_0 -> DFCTabs.lambda$fillOre$14(out, (OreDeposit)dFCOre, arg_0));
        }
    }

    private static void fillMetal(CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output out) {
        for (DFCMetal.DFCDefault dFCDefault : DFCMetal.DFCDefault.values()) {
            for (DFCMetal.DFCDefault.DFCItemType dFCItemType : DFCMetal.DFCDefault.DFCItemType.values()) {
                DFCTabs.accept(out, DFCItems.METAL_ITEMS, dFCDefault, dFCItemType);
            }
        }
        for (DFCMetal.DFCDefault dFCDefault : Metal.Default.values()) {
            if (!dFCDefault.hasParts()) continue;
            DFCTabs.accept(out, DFCItems.METAL_POWDERS.get((Object)dFCDefault));
        }
        for (DFCMetal.DFCDefault dFCDefault : DFCMetal.DFCDefault.values()) {
            DFCTabs.accept(out, DFCItems.DFC_METAL_POWDERS, dFCDefault);
        }
        for (DFCMetal.DFCDefault dFCDefault : Metal.Default.values()) {
            if (!dFCDefault.hasUtilities()) continue;
            DFCTabs.accept(out, DFCBlocks.METAL_GATES.get((Object)dFCDefault));
        }
        for (DFCMetal.DFCDefault dFCDefault : Metal.Default.values()) {
            for (Enum enum_ : DFCMetal.DFCBlockType.values()) {
                DFCTabs.accept(out, DFCBlocks.METALS_DFC_BLOCKS, dFCDefault, enum_);
            }
        }
        for (DFCMetal.DFCDefault dFCDefault : DFCMetal.DFCDefault.values()) {
            for (Enum enum_ : DFCMetal.DFCBlockType.values()) {
                DFCTabs.accept(out, DFCBlocks.DFC_METALS_DFC_BLOCKS, dFCDefault, enum_);
            }
        }
        for (DFCMetal.DFCDefault dFCDefault : DFCMetal.DFCDefault.values()) {
            for (Enum enum_ : Metal.BlockType.values()) {
                DFCTabs.accept(out, DFCBlocks.DFC_METALS, dFCDefault, enum_);
            }
        }
    }

    private static void fillCeramics(CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output out) {
        DFCTabs.accept(out, DFCItems.UNFIRED_SHINGLE);
        DFCTabs.accept(out, DFCItems.SHINGLE);
        DFCTabs.accept(out, DFCItems.UNFIRED_TILE);
        DFCTabs.accept(out, DFCItems.TILE);
        DFCTabs.accept(out, DFCBlocks.PLAIN_TILES);
        DFCTabs.accept(out, DFCBlocks.PLAIN_TILES_SLAB);
        DFCTabs.accept(out, DFCBlocks.PLAIN_TILES_STAIRS);
        for (DyeColor dye : DyeColor.values()) {
            DFCTabs.accept(out, DFCBlocks.PAINTED_TILES, dye);
            DFCTabs.accept(out, DFCBlocks.PAINTED_TILES_SLABS, dye);
            DFCTabs.accept(out, DFCBlocks.PAINTED_TILES_STAIRS, dye);
        }
        for (DyeColor dye : DyeColor.values()) {
            DFCTabs.accept(out, DFCBlocks.TERRACOTTA_PAINTED_TILES, dye);
            DFCTabs.accept(out, DFCBlocks.TERRACOTTA_PAINTED_TILES_SLABS, dye);
            DFCTabs.accept(out, DFCBlocks.TERRACOTTA_PAINTED_TILES_STAIRS, dye);
        }
        for (DyeColor dye : DyeColor.values()) {
            DFCTabs.accept(out, DFCBlocks.GLAZED_TILES, dye);
            DFCTabs.accept(out, DFCBlocks.GLAZED_TILES_SLABS, dye);
            DFCTabs.accept(out, DFCBlocks.GLAZED_TILES_STAIRS, dye);
        }
        DFCTabs.accept(out, DFCBlocks.PLAIN_SMALL_TILES);
        DFCTabs.accept(out, DFCBlocks.PLAIN_SMALL_TILES_SLAB);
        DFCTabs.accept(out, DFCBlocks.PLAIN_SMALL_TILES_STAIRS);
        for (DyeColor dye : DyeColor.values()) {
            DFCTabs.accept(out, DFCBlocks.SMALL_PAINTED_TILES, dye);
            DFCTabs.accept(out, DFCBlocks.SMALL_PAINTED_TILES_SLABS, dye);
            DFCTabs.accept(out, DFCBlocks.SMALL_PAINTED_TILES_STAIRS, dye);
        }
        for (DyeColor dye : DyeColor.values()) {
            DFCTabs.accept(out, DFCBlocks.SMALL_TERRACOTTA_PAINTED_TILES, dye);
            DFCTabs.accept(out, DFCBlocks.SMALL_TERRACOTTA_PAINTED_TILES_SLABS, dye);
            DFCTabs.accept(out, DFCBlocks.SMALL_TERRACOTTA_PAINTED_TILES_STAIRS, dye);
        }
        for (DyeColor dye : DyeColor.values()) {
            DFCTabs.accept(out, DFCBlocks.PAINTED_BRICKS, dye);
            DFCTabs.accept(out, DFCBlocks.PAINTED_BRICKS_DECORATIONS.get(dye));
        }
        for (DyeColor dye : DyeColor.values()) {
            DFCTabs.accept(out, DFCBlocks.TERRACOTTA_PAINTED_BRICKS, dye);
            DFCTabs.accept(out, DFCBlocks.TERRACOTTA_PAINTED_BRICKS_DECORATIONS.get(dye));
        }
        DFCTabs.accept(out, DFCBlocks.PLAIN_SHINGLES);
        for (DyeColor dye : DyeColor.values()) {
            DFCTabs.accept(out, DFCBlocks.PAINTED_SHINGLES, dye);
        }
        for (DyeColor dye : DyeColor.values()) {
            DFCTabs.accept(out, DFCBlocks.TERRACOTTA_PAINTED_SHINGLES, dye);
        }
    }

    private static void fillMisc(CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output out) {
        for (Wood wood : Wood.values()) {
            DFCTabs.accept(out, DFCBlocks.WOOD_PANELS, wood);
        }
        DFCTabs.accept(out, DFCItems.PAINTBRUSH);
        DFCTabs.accept(out, DFCItems.GYPSUM_POWDER);
        DFCTabs.accept(out, DFCItems.PLASTER_FLUID_BUCKET);
        DFCTabs.accept(out, DFCBlocks.PLAIN_PLASTER);
        DFCTabs.accept(out, DFCBlocks.PLAIN_PLASTER_SLAB);
        DFCTabs.accept(out, DFCBlocks.PLAIN_PLASTER_STAIRS);
        DFCTabs.accept(out, DFCBlocks.PLAIN_PLASTER_PILLAR);
        for (Wood wood : DyeColor.values()) {
            DFCTabs.accept(out, DFCBlocks.PAINTED_PLASTER, wood);
            DFCTabs.accept(out, DFCBlocks.PAINTED_PLASTER_SLABS, wood);
            DFCTabs.accept(out, DFCBlocks.PAINTED_PLASTER_STAIRS, wood);
            DFCTabs.accept(out, DFCBlocks.PAINTED_PLASTER_PILLARS, wood);
        }
        for (Wood wood : DyeColor.values()) {
            DFCTabs.accept(out, DFCBlocks.TERRACOTTA_PAINTED_PLASTER, wood);
            DFCTabs.accept(out, DFCBlocks.TERRACOTTA_PAINTED_PLASTER_SLABS, wood);
            DFCTabs.accept(out, DFCBlocks.TERRACOTTA_PAINTED_PLASTER_STAIRS, wood);
            DFCTabs.accept(out, DFCBlocks.TERRACOTTA_PAINTED_PLASTER_PILLARS, wood);
        }
        DFCTabs.accept(out, DFCItems.CONCRETE_FLUID_BUCKET);
        DFCTabs.accept(out, DFCItems.CINDER_BLOCK_MOLD);
        DFCTabs.accept(out, DFCItems.SLAB_MOLD);
        DFCTabs.accept(out, DFCItems.FILLED_CINDER_BLOCK_MOLD);
        DFCTabs.accept(out, DFCItems.FILLED_SLAB_MOLD);
        DFCTabs.accept(out, DFCItems.CINDER_BLOCK);
        DFCTabs.accept(out, DFCItems.CONCRETE_SLAB);
        DFCTabs.accept(out, DFCBlocks.PLAIN_SMOOTH_CONCRETE);
        for (Wood wood : DyeColor.values()) {
            DFCTabs.accept(out, DFCBlocks.PAINTED_SMOOTH_CONCRETE, wood);
        }
        DFCTabs.accept(out, DFCBlocks.PLAIN_SLAB_CONCRETE);
        for (Wood wood : DyeColor.values()) {
            DFCTabs.accept(out, DFCBlocks.PAINTED_SLAB_CONCRETE, wood);
        }
        DFCTabs.accept(out, DFCBlocks.PLAIN_CONCRETE_BRICKS);
        for (Wood wood : DyeColor.values()) {
            DFCTabs.accept(out, DFCBlocks.PAINTED_CONCRETE_BRICKS, wood);
        }
        DFCTabs.accept(out, DFCItems.LEADED_SILICA_GLASS_BATCH);
        DFCTabs.accept(out, DFCItems.LEADED_HEMATITIC_GLASS_BATCH);
        DFCTabs.accept(out, DFCItems.LEADED_OLIVINE_GLASS_BATCH);
        DFCTabs.accept(out, DFCItems.LEADED_VOLCANIC_GLASS_BATCH);
        DFCTabs.accept(out, DFCBlocks.FOGGY_GLASS);
        DFCTabs.accept(out, DFCBlocks.FOGGY_GLASS_PANE);
        DFCTabs.accept(out, DFCBlocks.LEADED_GLASS);
        DFCTabs.accept(out, DFCBlocks.LEADED_GLASS_PANE);
        for (Wood wood : DyeColor.values()) {
            DFCTabs.accept(out, DFCBlocks.STAINED_LEADED_GLASS, wood);
            DFCTabs.accept(out, DFCBlocks.STAINED_LEADED_GLASS_PANE.get(wood));
        }
        DFCTabs.accept(out, DFCItems.GLASS_BRICK);
        DFCTabs.accept(out, DFCItems.FOGGY_BRICK);
        for (Wood wood : DyeColor.values()) {
            DFCTabs.accept(out, DFCItems.STAINED_GLASS_BRICK, wood);
        }
        DFCTabs.accept(out, DFCBlocks.GLASS_BRICKS);
        DFCTabs.accept(out, DFCBlocks.GLASS_BRICKS_PANE);
        DFCTabs.accept(out, DFCBlocks.FOGGY_GLASS_BRICKS);
        DFCTabs.accept(out, DFCBlocks.FOGGY_GLASS_BRICKS_PANE);
        for (Wood wood : DyeColor.values()) {
            DFCTabs.accept(out, DFCBlocks.STAINED_GLASS_BRICKS, wood);
            DFCTabs.accept(out, DFCBlocks.STAINED_GLASS_BRICKS_PANE.get(wood));
        }
        DFCTabs.accept(out, DFCBlocks.GLASS_TILES);
        DFCTabs.accept(out, DFCBlocks.GLASS_TILES_PANE);
        DFCTabs.accept(out, DFCBlocks.FOGGY_GLASS_TILES);
        DFCTabs.accept(out, DFCBlocks.FOGGY_GLASS_TILES_PANE);
        for (Wood wood : DyeColor.values()) {
            DFCTabs.accept(out, DFCBlocks.STAINED_GLASS_TILES, wood);
            DFCTabs.accept(out, DFCBlocks.STAINED_GLASS_TILES_PANE.get(wood));
        }
    }

    private static <T extends ItemLike, R extends Supplier<T>> void accept(CreativeModeTab.Output out, R reg) {
        if (((ItemLike)reg.get()).m_5456_() == Items.f_41852_) {
            TerraFirmaCraft.LOGGER.error("BlockItem with no Item added to creative tab: " + reg);
            SelfTests.reportExternalError();
            return;
        }
        out.m_246326_((ItemLike)reg.get());
    }

    private static <T extends ItemLike, R extends Supplier<T>, K> void accept(CreativeModeTab.Output out, Map<K, R> map, K key) {
        if (map.containsKey(key)) {
            out.m_246326_((ItemLike)((Supplier)map.get(key)).get());
        }
    }

    private static <T extends ItemLike, R extends Supplier<T>, K1, K2> void accept(CreativeModeTab.Output out, Map<K1, Map<K2, R>> map, K1 key1, K2 key2) {
        if (map.containsKey(key1) && map.get(key1).containsKey(key2)) {
            out.m_246326_((ItemLike)((Supplier)map.get(key1).get(key2)).get());
        }
    }

    private static void accept(CreativeModeTab.Output out, DecorationBlockRegistryObject decoration) {
        out.m_246326_((ItemLike)decoration.stair().get());
        out.m_246326_((ItemLike)decoration.slab().get());
        out.m_246326_((ItemLike)decoration.wall().get());
    }

    private static CreativeTabHolder register(String name, Supplier<ItemStack> icon, CreativeModeTab.DisplayItemsGenerator displayItems) {
        RegistryObject reg = CREATIVE_TABS.register(name, () -> CreativeModeTab.builder().m_257737_(icon).m_257941_((Component)Component.m_237115_((String)("dfc.creative_tab." + name))).m_257501_(displayItems).m_257652_());
        return new CreativeTabHolder((RegistryObject<CreativeModeTab>)reg, displayItems);
    }

    private static /* synthetic */ void lambda$fillOre$14(CreativeModeTab.Output out, OreDeposit deposit, Map map) {
        DFCTabs.accept(out, map, deposit);
    }

    private static /* synthetic */ void lambda$fillOre$10(CreativeModeTab.Output out, Ore ore, Map map) {
        DFCTabs.accept(out, map, ore);
    }

    private static /* synthetic */ void lambda$fillOre$9(Ore ore, CreativeModeTab.Output out, Map map) {
        ((Map)map.get(ore)).values().forEach(reg -> DFCTabs.accept(out, reg));
    }

    public record CreativeTabHolder(RegistryObject<CreativeModeTab> tab, CreativeModeTab.DisplayItemsGenerator generator) {
    }
}

