/*
 * Decompiled with CFR 0.152.
 */
package com.ankmaniac.decofirmacraft.common.blocks.rock;

import com.ankmaniac.decofirmacraft.common.blocks.rock.ColumnProperties;
import com.ankmaniac.decofirmacraft.util.DFCTags;
import java.util.Random;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ColumnBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty UP = BlockStateProperties.f_61366_;
    public static final BooleanProperty DOWN = BlockStateProperties.f_61367_;
    public static final EnumProperty<ColumnProperties> STYLE = EnumProperty.m_61587_((String)"style", ColumnProperties.class);
    private static final Random RANDOM = new Random();

    public ColumnBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)UP, (Comparable)Boolean.valueOf(true))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(true))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(STYLE, (Comparable)((Object)ColumnProperties.DORIC)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{FACING, UP, DOWN, STYLE}));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState state = super.m_5573_(ctx);
        if (state != null) {
            Direction facing = ctx.m_8125_().m_122424_();
            Level level = ctx.m_43725_();
            BlockPos pos = ctx.m_8083_();
            BlockState aboveState = level.m_8055_(pos.m_7494_());
            BlockState belowState = level.m_8055_(pos.m_7495_());
            ColumnProperties style = ColumnProperties.DORIC;
            if (aboveState.m_60734_() instanceof ColumnBlock) {
                style = (ColumnProperties)((Object)aboveState.m_61143_(STYLE));
            } else if (belowState.m_60734_() instanceof ColumnBlock) {
                style = (ColumnProperties)((Object)belowState.m_61143_(STYLE));
            }
            return (BlockState)((BlockState)this.m_49966_().m_61124_(STYLE, (Comparable)((Object)style))).m_61124_((Property)FACING, (Comparable)facing);
        }
        return null;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        boolean up = (Boolean)state.m_61143_((Property)UP);
        boolean down = (Boolean)state.m_61143_((Property)DOWN);
        VoxelShape topShape1 = Shapes.m_83048_((double)0.0625, (double)0.875, (double)0.0625, (double)0.9375, (double)1.0, (double)0.9375);
        VoxelShape topShape2 = Shapes.m_83048_((double)0.125, (double)0.8125, (double)0.125, (double)0.875, (double)0.875, (double)0.875);
        VoxelShape bottomShape1 = Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.125, (double)0.9375);
        VoxelShape bottomShape2 = Shapes.m_83048_((double)0.125, (double)0.125, (double)0.125, (double)0.875, (double)0.1875, (double)0.875);
        VoxelShape middleShape = Shapes.m_83048_((double)0.1875, (double)0.0, (double)0.1875, (double)0.8125, (double)1.0, (double)0.8125);
        if (up && down) {
            return Shapes.m_83124_((VoxelShape)topShape1, (VoxelShape[])new VoxelShape[]{topShape2, bottomShape1, bottomShape2, middleShape});
        }
        if (up) {
            return Shapes.m_83124_((VoxelShape)topShape1, (VoxelShape[])new VoxelShape[]{topShape2, middleShape});
        }
        if (down) {
            return Shapes.m_83124_((VoxelShape)bottomShape1, (VoxelShape[])new VoxelShape[]{bottomShape2, middleShape});
        }
        return middleShape;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (Helpers.isItem((ItemStack)player.m_21120_(hand), (TagKey)TFCTags.Items.HAMMERS)) {
            level.m_5594_(null, pos, SoundEvents.f_12442_, SoundSource.BLOCKS, 1.0f, 1.0f);
            int particleCount = 100;
            for (int i = 0; i < particleCount; ++i) {
                double speedX = RANDOM.nextDouble() * 20.0 - 10.0;
                double speedZ = RANDOM.nextDouble() * 20.0 - 10.0;
                double offsetY = RANDOM.nextDouble() * 1.0;
                level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + offsetY, (double)pos.m_123343_() + 0.5, speedX, -0.1, speedZ);
            }
            if (player instanceof ServerPlayer) {
                ((ServerPlayer)player).m_21011_(hand, true);
            }
            ColumnProperties currentStyle = (ColumnProperties)((Object)state.m_61143_(STYLE));
            ColumnProperties newStyle = ColumnProperties.values()[(currentStyle.ordinal() + 1) % ColumnProperties.values().length];
            this.updateColumn(level, pos, newStyle);
        }
        return InteractionResult.PASS;
    }

    private void updateColumn(Level level, BlockPos pos, ColumnProperties newStyle) {
        BlockPos currentPos;
        BlockState currentState;
        int y;
        for (y = pos.m_123342_(); y < level.m_151558_() && (currentState = level.m_8055_(currentPos = new BlockPos(pos.m_123341_(), y, pos.m_123343_()))).m_60734_() instanceof ColumnBlock; ++y) {
            level.m_7731_(currentPos, (BlockState)currentState.m_61124_(STYLE, (Comparable)((Object)newStyle)), 3);
        }
        for (y = pos.m_123342_(); y >= level.m_141937_() && (currentState = level.m_8055_(currentPos = new BlockPos(pos.m_123341_(), y, pos.m_123343_()))).m_60734_() instanceof ColumnBlock; --y) {
            level.m_7731_(currentPos, (BlockState)currentState.m_61124_(STYLE, (Comparable)((Object)newStyle)), 3);
        }
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.UP) {
            state = (BlockState)state.m_61124_((Property)UP, (Comparable)Boolean.valueOf(!this.connects(facingState)));
        } else if (facing == Direction.DOWN) {
            state = (BlockState)state.m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(!this.connects(facingState)));
        }
        return state;
    }

    public boolean connects(BlockState adjacent) {
        return Helpers.isBlock((BlockState)adjacent, DFCTags.Blocks.ROCK_COLUMNS);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }
}

