/*
 * Decompiled with CFR 0.152.
 */
package com.ankmaniac.decofirmacraft.common.blocks;

import com.ankmaniac.decofirmacraft.common.blocks.DFCFluids;
import com.ankmaniac.decofirmacraft.common.blocks.metal.DFCMetal;
import com.ankmaniac.decofirmacraft.common.blocks.metal.GateBlock;
import com.ankmaniac.decofirmacraft.common.blocks.rock.CustomDFCRockBlocks;
import com.ankmaniac.decofirmacraft.common.blocks.rock.CustomRockBlocks;
import com.ankmaniac.decofirmacraft.common.blocks.rock.DFCOre;
import com.ankmaniac.decofirmacraft.common.blocks.rock.DFCRock;
import com.ankmaniac.decofirmacraft.common.items.DFCItems;
import com.ankmaniac.decofirmacraft.util.DFCHelpers;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.DecorationBlockRegistryObject;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.GroundcoverBlock;
import net.dries007.tfc.common.blocks.OreDeposit;
import net.dries007.tfc.common.blocks.PouredGlassBlock;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.TFCMagmaBlock;
import net.dries007.tfc.common.blocks.rock.Ore;
import net.dries007.tfc.common.blocks.rock.Rock;
import net.dries007.tfc.common.blocks.rock.RockAnvilBlock;
import net.dries007.tfc.common.blocks.rock.RockCategory;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Metal;
import net.dries007.tfc.util.registry.RegistrationHelpers;
import net.dries007.tfc.util.registry.RegistryMetal;
import net.dries007.tfc.util.registry.RegistryRock;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GlassBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;

public class DFCBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((ResourceKey)Registries.f_256747_, (String)"dfc");
    public static final Map<DFCRock, Map<Rock.BlockType, RegistryObject<Block>>> CUSTOM_ROCK_TYPES = Helpers.mapOfKeys(DFCRock.class, rock -> Helpers.mapOfKeys(Rock.BlockType.class, type -> DFCBlocks.register("rock/" + type.name() + "/" + rock.name(), () -> type.create((RegistryRock)rock))));
    public static final Map<DFCRock, Map<Rock.BlockType, DecorationBlockRegistryObject>> CUSTOM_DFC_ROCK_DECORATIONS = Helpers.mapOfKeys(DFCRock.class, rock -> Helpers.mapOfKeys(Rock.BlockType.class, Rock.BlockType::hasVariants, type -> new DecorationBlockRegistryObject(DFCBlocks.register("rock/" + type.name() + "/" + rock.name() + "_slab", () -> type.createSlab((RegistryRock)rock)), DFCBlocks.register("rock/" + type.name() + "/" + rock.name() + "_stairs", () -> type.createStairs((RegistryRock)rock)), DFCBlocks.register("rock/" + type.name() + "/" + rock.name() + "_wall", () -> type.createWall((RegistryRock)rock)))));
    public static final Map<DFCRock, RegistryObject<Block>> DFC_ROCK_ANVILS = Helpers.mapOfKeys(DFCRock.class, rock -> rock.category() == RockCategory.IGNEOUS_EXTRUSIVE || rock.category() == RockCategory.IGNEOUS_INTRUSIVE, rock -> DFCBlocks.register("rock/anvil/" + rock.name(), () -> new RockAnvilBlock(ExtendedProperties.of().mapColor(MapColor.f_283947_).sound(SoundType.f_56742_).strength(2.0f, 10.0f).requiresCorrectToolForDrops().blockEntity((Supplier)TFCBlockEntities.ANVIL), (Supplier)CUSTOM_ROCK_TYPES.get(rock).get(Rock.BlockType.RAW))));
    public static final Map<DFCRock, RegistryObject<Block>> DFC_MAGMA_BLOCKS = Helpers.mapOfKeys(DFCRock.class, rock -> rock.category() == RockCategory.IGNEOUS_EXTRUSIVE || rock.category() == RockCategory.IGNEOUS_INTRUSIVE, rock -> DFCBlocks.register("rock/magma/" + rock.name(), () -> new TFCMagmaBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283820_).m_60999_().m_60953_(s -> 6).m_60977_().m_60978_(0.5f).m_60922_((state, level, pos, type) -> type.m_20672_()).m_60982_(TFCBlocks::always))));
    public static final Map<Rock, Map<CustomRockBlocks, RegistryObject<Block>>> CUSTOM_ROCK_BLOCKS = Helpers.mapOfKeys(Rock.class, rock -> Helpers.mapOfKeys(CustomRockBlocks.class, type -> DFCBlocks.register("rock/" + type.name() + "/" + rock.name(), () -> type.create((RegistryRock)rock))));
    public static final Map<Rock, Map<CustomRockBlocks, DecorationBlockRegistryObject>> ROCK_DECORATIONS = Helpers.mapOfKeys(Rock.class, rock -> Helpers.mapOfKeys(CustomRockBlocks.class, CustomRockBlocks::hasVariants, type -> new DecorationBlockRegistryObject(DFCBlocks.register("rock/" + type.name() + "/" + rock.name() + "_slab", () -> type.createSlab((RegistryRock)rock)), DFCBlocks.register("rock/" + type.name() + "/" + rock.name() + "_stairs", () -> type.createStairs((RegistryRock)rock)), DFCBlocks.register("rock/" + type.name() + "/" + rock.name() + "_wall", () -> type.createWall((RegistryRock)rock)))));
    public static final Map<DFCRock, Map<CustomDFCRockBlocks, RegistryObject<Block>>> CUSTOM_DFC_ROCK_BLOCKS = Helpers.mapOfKeys(DFCRock.class, rock -> Helpers.mapOfKeys(CustomDFCRockBlocks.class, type -> DFCBlocks.register("rock/" + type.name() + "/" + rock.name(), () -> type.create((DFCRock)((Object)rock)))));
    public static final Map<DFCRock, Map<CustomDFCRockBlocks, DecorationBlockRegistryObject>> DFC_ROCK_DECORATIONS = Helpers.mapOfKeys(DFCRock.class, rock -> Helpers.mapOfKeys(CustomDFCRockBlocks.class, CustomDFCRockBlocks::hasVariants, type -> new DecorationBlockRegistryObject(DFCBlocks.register("rock/" + type.name() + "/" + rock.name() + "_slab", () -> type.createSlab((DFCRock)((Object)rock))), DFCBlocks.register("rock/" + type.name() + "/" + rock.name() + "_stairs", () -> type.createStairs((DFCRock)((Object)rock))), DFCBlocks.register("rock/" + type.name() + "/" + rock.name() + "_wall", () -> type.createWall((DFCRock)((Object)rock))))));
    public static final Map<DFCRock, Map<Ore, RegistryObject<Block>>> DFC_ROCK_ORES = Helpers.mapOfKeys(DFCRock.class, rock -> Helpers.mapOfKeys(Ore.class, ore -> !ore.isGraded(), ore -> DFCBlocks.register("ore/" + ore.name() + "/" + rock.name(), () -> ore.create((RegistryRock)rock))));
    public static final Map<DFCRock, Map<Ore, Map<Ore.Grade, RegistryObject<Block>>>> DFC_ROCK_GRADED_ORES = Helpers.mapOfKeys(DFCRock.class, rock -> Helpers.mapOfKeys(Ore.class, Ore::isGraded, ore -> Helpers.mapOfKeys(Ore.Grade.class, grade -> DFCBlocks.register("ore/" + grade.name() + "_" + ore.name() + "/" + rock.name(), () -> ore.create((RegistryRock)rock)))));
    public static final Map<Rock, Map<DFCOre, RegistryObject<Block>>> DFC_ORES = Helpers.mapOfKeys(Rock.class, rock -> Helpers.mapOfKeys(DFCOre.class, ore -> !ore.isGraded(), ore -> DFCBlocks.register("ore/" + ore.name() + "/" + rock.name(), () -> ore.create((RegistryRock)rock))));
    public static final Map<Rock, Map<DFCOre, Map<Ore.Grade, RegistryObject<Block>>>> DFC_GRADED_ORES = Helpers.mapOfKeys(Rock.class, rock -> Helpers.mapOfKeys(DFCOre.class, DFCOre::isGraded, ore -> Helpers.mapOfKeys(Ore.Grade.class, grade -> DFCBlocks.register("ore/" + grade.name() + "_" + ore.name() + "/" + rock.name(), () -> ore.create((RegistryRock)rock)))));
    public static final Map<DFCOre, RegistryObject<Block>> DFC_SMALL_ORES = Helpers.mapOfKeys(DFCOre.class, DFCOre::isGraded, type -> DFCBlocks.register("ore/small_" + type.name(), () -> GroundcoverBlock.looseOre((BlockBehaviour.Properties)BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283824_).m_60913_(0.05f, 0.0f).m_60918_(SoundType.f_56723_).m_60910_().m_278166_(PushReaction.DESTROY))));
    public static final Map<DFCRock, Map<DFCOre, RegistryObject<Block>>> DFC_ROCK_DFC_ORES = Helpers.mapOfKeys(DFCRock.class, rock -> Helpers.mapOfKeys(DFCOre.class, ore -> !ore.isGraded(), ore -> DFCBlocks.register("ore/" + ore.name() + "/" + rock.name(), () -> ore.create((RegistryRock)rock))));
    public static final Map<DFCRock, Map<DFCOre, Map<Ore.Grade, RegistryObject<Block>>>> DFC_ROCK_DFC_GRADED_ORES = Helpers.mapOfKeys(DFCRock.class, rock -> Helpers.mapOfKeys(DFCOre.class, DFCOre::isGraded, ore -> Helpers.mapOfKeys(Ore.Grade.class, grade -> DFCBlocks.register("ore/" + grade.name() + "_" + ore.name() + "/" + rock.name(), () -> ore.create((RegistryRock)rock)))));
    public static final Map<DFCRock, Map<OreDeposit, RegistryObject<Block>>> DFC_ORE_DEPOSITS = Helpers.mapOfKeys(DFCRock.class, rock -> Helpers.mapOfKeys(OreDeposit.class, ore -> DFCBlocks.register("deposit/" + ore.name() + "/" + rock.name(), () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60918_(SoundType.f_56739_).m_60978_(rock.category().hardness(2.0f))))));
    public static final Map<DFCMetal.DFCDefault, Map<Metal.BlockType, RegistryObject<Block>>> DFC_METALS = Helpers.mapOfKeys(DFCMetal.DFCDefault.class, metal -> Helpers.mapOfKeys(Metal.BlockType.class, type -> type.has(Metal.Default.BISMUTH), type -> DFCBlocks.register(type.createName((RegistryMetal)metal), type.create((RegistryMetal)metal), type.createBlockItem(new Item.Properties()))));
    public static final Map<Metal.Default, Map<DFCMetal.DFCBlockType, RegistryObject<Block>>> METALS_DFC_BLOCKS = Helpers.mapOfKeys(Metal.Default.class, Metal.Default::hasParts, metal -> Helpers.mapOfKeys(DFCMetal.DFCBlockType.class, type -> DFCBlocks.register(type.createName((RegistryMetal)metal), type.create((RegistryMetal)metal), type.createBlockItem(new Item.Properties()))));
    public static final Map<DFCMetal.DFCDefault, Map<DFCMetal.DFCBlockType, RegistryObject<Block>>> DFC_METALS_DFC_BLOCKS = Helpers.mapOfKeys(DFCMetal.DFCDefault.class, metal -> Helpers.mapOfKeys(DFCMetal.DFCBlockType.class, type -> DFCBlocks.register(type.createName((RegistryMetal)metal), type.create((RegistryMetal)metal), type.createBlockItem(new Item.Properties()))));
    public static final Map<Metal.Default, RegistryObject<Block>> METAL_GATES = Helpers.mapOfKeys(Metal.Default.class, Metal.Default::hasTools, metals -> DFCBlocks.register("metal/gate/" + metals.name(), () -> new GateBlock(BlockBehaviour.Properties.m_284310_().m_284180_(metals.mapColor()).m_60999_().m_60913_(6.0f, 7.0f).m_60918_(SoundType.f_56743_).m_60955_(), new BlockSetType(metals.m_7912_()))));
    public static final RegistryObject<Block> PLAIN_TILES = DFCBlocks.register("ceramic/tiles/normal/plain", () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60999_().m_60913_(1.5f, 6.0f)));
    public static final RegistryObject<Block> PLAIN_TILES_SLAB = DFCBlocks.register("ceramic/tiles/normal/plain_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60999_().m_60913_(1.5f, 6.0f)));
    public static final RegistryObject<Block> PLAIN_TILES_STAIRS = DFCBlocks.register("ceramic/tiles/normal/plain_stairs", () -> new StairBlock(() -> ((Block)PLAIN_TILES.get()).m_49966_(), BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60999_().m_60913_(1.5f, 6.0f)));
    public static final RegistryObject<Block> PLAIN_SMALL_TILES = DFCBlocks.register("ceramic/tiles/small/plain", () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60999_().m_60913_(1.5f, 6.0f)));
    public static final RegistryObject<Block> PLAIN_SMALL_TILES_SLAB = DFCBlocks.register("ceramic/tiles/small/plain_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60999_().m_60913_(1.5f, 6.0f)));
    public static final RegistryObject<Block> PLAIN_SMALL_TILES_STAIRS = DFCBlocks.register("ceramic/tiles/small/plain_stairs", () -> new StairBlock(() -> ((Block)PLAIN_SMALL_TILES.get()).m_49966_(), BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60999_().m_60913_(1.5f, 6.0f)));
    public static final RegistryObject<Block> PLAIN_SHINGLES = DFCBlocks.register("ceramic/shingles/plain", () -> new StairBlock(() -> ((Block)PLAIN_TILES.get()).m_49966_(), BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283748_).m_60999_().m_60913_(1.5f, 6.0f)));
    public static final Map<DyeColor, RegistryObject<Block>> PAINTED_TILES = Helpers.mapOfKeys(DyeColor.class, color -> DFCBlocks.register("ceramic/tiles/normal/" + color.m_41065_(), () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(color.m_284406_()).m_60999_().m_60913_(1.5f, 6.0f))));
    public static final Map<DyeColor, RegistryObject<Block>> PAINTED_TILES_SLABS = Helpers.mapOfKeys(DyeColor.class, color -> DFCBlocks.register("ceramic/tiles/normal/" + color.m_41065_() + "_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_284310_().m_284180_(color.m_284406_()).m_60999_().m_60913_(1.5f, 6.0f))));
    public static final Map<DyeColor, RegistryObject<Block>> PAINTED_TILES_STAIRS = Helpers.mapOfKeys(DyeColor.class, color -> DFCBlocks.register("ceramic/tiles/normal/" + color.m_41065_() + "_stairs", () -> new StairBlock(() -> ((Block)PAINTED_TILES.get(color).get()).m_49966_(), BlockBehaviour.Properties.m_284310_().m_284180_(color.m_284406_()).m_60999_().m_60913_(1.5f, 6.0f))));
    public static final Map<DyeColor, RegistryObject<Block>> TERRACOTTA_PAINTED_TILES = Helpers.mapOfKeys(DyeColor.class, color -> DFCBlocks.register("ceramic/tiles/normal/terracotta_" + color.m_41065_(), () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(color.m_284406_()).m_60999_().m_60913_(1.5f, 6.0f))));
    public static final Map<DyeColor, RegistryObject<Block>> TERRACOTTA_PAINTED_TILES_SLABS = Helpers.mapOfKeys(DyeColor.class, color -> DFCBlocks.register("ceramic/tiles/normal/terracotta_" + color.m_41065_() + "_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_284310_().m_284180_(color.m_284406_()).m_60999_().m_60913_(1.5f, 6.0f))));
    public static final Map<DyeColor, RegistryObject<Block>> TERRACOTTA_PAINTED_TILES_STAIRS = Helpers.mapOfKeys(DyeColor.class, color -> DFCBlocks.register("ceramic/tiles/normal/terracotta_" + color.m_41065_() + "_stairs", () -> new StairBlock(() -> ((Block)TERRACOTTA_PAINTED_TILES.get(color).get()).m_49966_(), BlockBehaviour.Properties.m_284310_().m_284180_(color.m_284406_()).m_60999_().m_60913_(1.5f, 6.0f))));
    public static final Map<DyeColor, RegistryObject<Block>> GLAZED_TILES = Helpers.mapOfKeys(DyeColor.class, color -> DFCBlocks.register("ceramic/tiles/glazed/" + color.m_41065_(), () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(color.m_284406_()).m_60999_().m_60913_(1.5f, 6.0f))));
    public static final Map<DyeColor, RegistryObject<Block>> GLAZED_TILES_SLABS = Helpers.mapOfKeys(DyeColor.class, color -> DFCBlocks.register("ceramic/tiles/glazed/" + color.m_41065_() + "_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_284310_().m_284180_(color.m_284406_()).m_60999_().m_60913_(1.5f, 6.0f))));
    public static final Map<DyeColor, RegistryObject<Block>> GLAZED_TILES_STAIRS = Helpers.mapOfKeys(DyeColor.class, color -> DFCBlocks.register("ceramic/tiles/glazed/" + color.m_41065_() + "_stairs", () -> new StairBlock(() -> ((Block)GLAZED_TILES.get(color).get()).m_49966_(), BlockBehaviour.Properties.m_284310_().m_284180_(color.m_284406_()).m_60999_().m_60913_(1.5f, 6.0f))));
    public static final Map<DyeColor, RegistryObject<Block>> SMALL_PAINTED_TILES = Helpers.mapOfKeys(DyeColor.class, color -> DFCBlocks.register("ceramic/tiles/small/" + color.m_41065_(), () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(color.m_284406_()).m_60999_().m_60913_(1.5f, 6.0f))));
    public static final Map<DyeColor, RegistryObject<Block>> SMALL_PAINTED_TILES_SLABS = Helpers.mapOfKeys(DyeColor.class, color -> DFCBlocks.register("ceramic/tiles/small/" + color.m_41065_() + "_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_284310_().m_284180_(color.m_284406_()).m_60999_().m_60913_(1.5f, 6.0f))));
    public static final Map<DyeColor, RegistryObject<Block>> SMALL_PAINTED_TILES_STAIRS = Helpers.mapOfKeys(DyeColor.class, color -> DFCBlocks.register("ceramic/tiles/small/" + color.m_41065_() + "_stairs", () -> new StairBlock(() -> ((Block)SMALL_PAINTED_TILES.get(color).get()).m_49966_(), BlockBehaviour.Properties.m_284310_().m_284180_(color.m_284406_()).m_60999_().m_60913_(1.5f, 6.0f))));
    public static final Map<DyeColor, RegistryObject<Block>> SMALL_TERRACOTTA_PAINTED_TILES = Helpers.mapOfKeys(DyeColor.class, color -> DFCBlocks.register("ceramic/tiles/small/terracotta_" + color.m_41065_(), () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(color.m_284406_()).m_60999_().m_60913_(1.5f, 6.0f))));
    public static final Map<DyeColor, RegistryObject<Block>> SMALL_TERRACOTTA_PAINTED_TILES_SLABS = Helpers.mapOfKeys(DyeColor.class, color -> DFCBlocks.register("ceramic/tiles/small/terracotta_" + color.m_41065_() + "_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_284310_().m_284180_(color.m_284406_()).m_60999_().m_60913_(1.5f, 6.0f))));
    public static final Map<DyeColor, RegistryObject<Block>> SMALL_TERRACOTTA_PAINTED_TILES_STAIRS = Helpers.mapOfKeys(DyeColor.class, color -> DFCBlocks.register("ceramic/tiles/small/terracotta_" + color.m_41065_() + "_stairs", () -> new StairBlock(() -> ((Block)SMALL_TERRACOTTA_PAINTED_TILES.get(color).get()).m_49966_(), BlockBehaviour.Properties.m_284310_().m_284180_(color.m_284406_()).m_60999_().m_60913_(1.5f, 6.0f))));
    public static final Map<DyeColor, RegistryObject<Block>> PAINTED_BRICKS = Helpers.mapOfKeys(DyeColor.class, color -> DFCBlocks.register("ceramic/bricks/" + color.m_41065_(), () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50076_).m_284180_(color.m_284406_()).m_60999_().m_60913_(1.5f, 6.0f))));
    public static final Map<DyeColor, RegistryObject<Block>> TERRACOTTA_PAINTED_BRICKS = Helpers.mapOfKeys(DyeColor.class, color -> DFCBlocks.register("ceramic/bricks/terracotta_" + color.m_41065_(), () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50076_).m_284180_(color.m_284406_()).m_60999_().m_60913_(1.5f, 6.0f))));
    public static final Map<DyeColor, RegistryObject<Block>> PAINTED_SHINGLES = Helpers.mapOfKeys(DyeColor.class, color -> DFCBlocks.register("ceramic/shingles/" + color.m_41065_(), () -> new StairBlock(() -> ((Block)PAINTED_TILES.get(color).get()).m_49966_(), BlockBehaviour.Properties.m_284310_().m_284180_(color.m_284406_()).m_60999_().m_60913_(1.5f, 6.0f))));
    public static final Map<DyeColor, RegistryObject<Block>> TERRACOTTA_PAINTED_SHINGLES = Helpers.mapOfKeys(DyeColor.class, color -> DFCBlocks.register("ceramic/shingles/terracotta_" + color.m_41065_(), () -> new StairBlock(() -> ((Block)PAINTED_TILES.get(color).get()).m_49966_(), BlockBehaviour.Properties.m_284310_().m_284180_(color.m_284406_()).m_60999_().m_60913_(1.5f, 6.0f))));
    public static final Map<DyeColor, DecorationBlockRegistryObject> PAINTED_BRICKS_DECORATIONS = Helpers.mapOfKeys(DyeColor.class, color -> new DecorationBlockRegistryObject(DFCBlocks.register("ceramic/bricks/" + color.m_41065_() + "_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_284310_().m_284180_(color.m_284406_()).m_60999_().m_60913_(1.5f, 6.0f))), DFCBlocks.register("ceramic/bricks/" + color.m_41065_() + "_stairs", () -> new StairBlock(() -> ((Block)PAINTED_BRICKS.get(color).get()).m_49966_(), BlockBehaviour.Properties.m_284310_().m_284180_(color.m_284406_()).m_60999_().m_60913_(1.5f, 6.0f))), DFCBlocks.register("ceramic/bricks/" + color.m_41065_() + "_wall", () -> new WallBlock(BlockBehaviour.Properties.m_284310_().m_284180_(color.m_284406_()).m_60999_().m_60913_(1.5f, 6.0f)))));
    public static final Map<DyeColor, DecorationBlockRegistryObject> TERRACOTTA_PAINTED_BRICKS_DECORATIONS = Helpers.mapOfKeys(DyeColor.class, color -> new DecorationBlockRegistryObject(DFCBlocks.register("ceramic/bricks/terracotta_" + color.m_41065_() + "_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_284310_().m_284180_(color.m_284406_()).m_60999_().m_60913_(1.5f, 6.0f))), DFCBlocks.register("ceramic/bricks/terracotta_" + color.m_41065_() + "_stairs", () -> new StairBlock(() -> ((Block)TERRACOTTA_PAINTED_BRICKS.get(color).get()).m_49966_(), BlockBehaviour.Properties.m_284310_().m_284180_(color.m_284406_()).m_60999_().m_60913_(1.5f, 6.0f))), DFCBlocks.register("ceramic/bricks/terracotta_" + color.m_41065_() + "_wall", () -> new WallBlock(BlockBehaviour.Properties.m_284310_().m_284180_(color.m_284406_()).m_60999_().m_60913_(1.5f, 6.0f)))));
    public static final RegistryObject<Block> PLAIN_SMOOTH_CONCRETE = DFCBlocks.register("concrete/smooth/plain", () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60999_().m_60978_(1.8f)));
    public static final Map<DyeColor, RegistryObject<Block>> PAINTED_SMOOTH_CONCRETE = Helpers.mapOfKeys(DyeColor.class, color -> DFCBlocks.register("concrete/smooth/" + color.m_41065_(), () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(color.m_284406_()).m_60999_().m_60978_(1.8f))));
    public static final RegistryObject<Block> PLAIN_SLAB_CONCRETE = DFCBlocks.register("concrete/slab/plain", () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60999_().m_60978_(1.8f)));
    public static final Map<DyeColor, RegistryObject<Block>> PAINTED_SLAB_CONCRETE = Helpers.mapOfKeys(DyeColor.class, color -> DFCBlocks.register("concrete/slab/" + color.m_41065_(), () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(color.m_284406_()).m_60999_().m_60978_(1.8f))));
    public static final RegistryObject<Block> PLAIN_CONCRETE_BRICKS = DFCBlocks.register("concrete/bricks/plain", () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60999_().m_60978_(1.8f)));
    public static final Map<DyeColor, RegistryObject<Block>> PAINTED_CONCRETE_BRICKS = Helpers.mapOfKeys(DyeColor.class, color -> DFCBlocks.register("concrete/bricks/" + color.m_41065_(), () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(color.m_284406_()).m_60999_().m_60978_(1.8f))));
    public static final RegistryObject<Block> PLAIN_PLASTER = DFCBlocks.register("plaster/smooth/plain", () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60999_().m_60913_(1.5f, 6.0f)));
    public static final RegistryObject<Block> PLAIN_PLASTER_SLAB = DFCBlocks.register("plaster/smooth/plain_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60999_().m_60913_(1.5f, 6.0f)));
    public static final RegistryObject<Block> PLAIN_PLASTER_STAIRS = DFCBlocks.register("plaster/smooth/plain_stairs", () -> new StairBlock(() -> ((Block)PLAIN_PLASTER.get()).m_49966_(), BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60999_().m_60913_(1.5f, 6.0f)));
    public static final RegistryObject<Block> PLAIN_PLASTER_PILLAR = DFCBlocks.register("plaster/pillar/plain", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60999_().m_60913_(1.5f, 6.0f)));
    public static final Map<DyeColor, RegistryObject<Block>> PAINTED_PLASTER = Helpers.mapOfKeys(DyeColor.class, color -> DFCBlocks.register("plaster/smooth/" + color.m_41065_(), () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(color.m_284406_()).m_60999_().m_60913_(1.5f, 6.0f))));
    public static final Map<DyeColor, RegistryObject<Block>> PAINTED_PLASTER_SLABS = Helpers.mapOfKeys(DyeColor.class, color -> DFCBlocks.register("plaster/smooth/" + color.m_41065_() + "_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_284310_().m_284180_(color.m_284406_()).m_60999_().m_60913_(1.5f, 6.0f))));
    public static final Map<DyeColor, RegistryObject<Block>> PAINTED_PLASTER_STAIRS = Helpers.mapOfKeys(DyeColor.class, color -> DFCBlocks.register("plaster/smooth/" + color.m_41065_() + "_stairs", () -> new StairBlock(() -> ((Block)PAINTED_PLASTER.get(color).get()).m_49966_(), BlockBehaviour.Properties.m_284310_().m_284180_(color.m_284406_()).m_60999_().m_60913_(1.5f, 6.0f))));
    public static final Map<DyeColor, RegistryObject<Block>> PAINTED_PLASTER_PILLARS = Helpers.mapOfKeys(DyeColor.class, color -> DFCBlocks.register("plaster/pillar/" + color.m_41065_(), () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_284310_().m_284180_(color.m_284406_()).m_60999_().m_60913_(1.5f, 6.0f))));
    public static final Map<DyeColor, RegistryObject<Block>> TERRACOTTA_PAINTED_PLASTER = Helpers.mapOfKeys(DyeColor.class, color -> DFCBlocks.register("plaster/smooth/terracotta_" + color.m_41065_(), () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(color.m_284406_()).m_60999_().m_60913_(1.5f, 6.0f))));
    public static final Map<DyeColor, RegistryObject<Block>> TERRACOTTA_PAINTED_PLASTER_SLABS = Helpers.mapOfKeys(DyeColor.class, color -> DFCBlocks.register("plaster/smooth/terracotta_" + color.m_41065_() + "_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_284310_().m_284180_(color.m_284406_()).m_60999_().m_60913_(1.5f, 6.0f))));
    public static final Map<DyeColor, RegistryObject<Block>> TERRACOTTA_PAINTED_PLASTER_STAIRS = Helpers.mapOfKeys(DyeColor.class, color -> DFCBlocks.register("plaster/smooth/terracotta_" + color.m_41065_() + "_stairs", () -> new StairBlock(() -> ((Block)TERRACOTTA_PAINTED_PLASTER.get(color).get()).m_49966_(), BlockBehaviour.Properties.m_284310_().m_284180_(color.m_284406_()).m_60999_().m_60913_(1.5f, 6.0f))));
    public static final Map<DyeColor, RegistryObject<Block>> TERRACOTTA_PAINTED_PLASTER_PILLARS = Helpers.mapOfKeys(DyeColor.class, color -> DFCBlocks.register("plaster/pillar/terracotta_" + color.m_41065_(), () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_284310_().m_284180_(color.m_284406_()).m_60999_().m_60913_(1.5f, 6.0f))));
    public static final RegistryObject<Block> LEADED_GLASS = DFCBlocks.register("glass/block/leaded/plain", () -> new GlassBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_).m_60999_()));
    public static final RegistryObject<Block> LEADED_GLASS_PANE = DFCBlocks.register("glass/pane/leaded/plain", () -> new IronBarsBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50185_).m_60999_()));
    public static final Map<DyeColor, RegistryObject<Block>> STAINED_LEADED_GLASS = Helpers.mapOfKeys(DyeColor.class, color -> DFCBlocks.register("glass/block/leaded/" + color.m_41065_(), () -> new GlassBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_).m_60999_())));
    public static final Map<DyeColor, RegistryObject<Block>> STAINED_LEADED_GLASS_PANE = Helpers.mapOfKeys(DyeColor.class, color -> DFCBlocks.register("glass/pane/leaded/" + color.m_41065_(), () -> new IronBarsBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_).m_60999_())));
    public static final RegistryObject<Block> POURED_LEADED_GLASS = DFCBlocks.register("plain_poured_leaded_glass", () -> new PouredGlassBlock(ExtendedProperties.of().strength(0.3f).sound(SoundType.f_56744_).pushReaction(PushReaction.DESTROY).noOcclusion().requiresCorrectToolForDrops(), () -> ((Block)LEADED_GLASS_PANE.get()).m_5456_()));
    public static final Map<DyeColor, RegistryObject<Block>> COLORED_POURED_LEADED_GLASS = Helpers.mapOfKeys(DyeColor.class, color -> DFCBlocks.register(color.m_7912_() + "_poured_leaded_glass", () -> new PouredGlassBlock(ExtendedProperties.of().pushReaction(PushReaction.DESTROY).strength(0.3f).sound(SoundType.f_56744_).noOcclusion().requiresCorrectToolForDrops(), () -> DFCHelpers.getLeadedStainedGlass(color))));
    public static final RegistryObject<Block> FOGGY_GLASS = DFCBlocks.register("glass/block/foggy", () -> new GlassBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_).m_60999_()));
    public static final RegistryObject<Block> FOGGY_GLASS_PANE = DFCBlocks.register("glass/pane/foggy", () -> new IronBarsBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50185_).m_60999_()));
    public static final RegistryObject<Block> POURED_FOGGY_GLASS = DFCBlocks.register("poured_foggy_glass", () -> new PouredGlassBlock(ExtendedProperties.of().strength(0.3f).sound(SoundType.f_56744_).pushReaction(PushReaction.DESTROY).noOcclusion().requiresCorrectToolForDrops(), () -> ((Block)FOGGY_GLASS_PANE.get()).m_5456_()));
    public static final RegistryObject<Block> GLASS_BRICKS = DFCBlocks.register("glass/block/bricks/plain", () -> new GlassBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_).m_60999_()));
    public static final RegistryObject<Block> GLASS_BRICKS_PANE = DFCBlocks.register("glass/pane/bricks/plain", () -> new IronBarsBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50185_).m_60999_()));
    public static final RegistryObject<Block> FOGGY_GLASS_BRICKS = DFCBlocks.register("glass/block/bricks/foggy", () -> new GlassBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_).m_60999_()));
    public static final RegistryObject<Block> FOGGY_GLASS_BRICKS_PANE = DFCBlocks.register("glass/pane/bricks/foggy", () -> new IronBarsBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50185_).m_60999_()));
    public static final Map<DyeColor, RegistryObject<Block>> STAINED_GLASS_BRICKS = Helpers.mapOfKeys(DyeColor.class, color -> DFCBlocks.register("glass/block/bricks/" + color.m_41065_(), () -> new GlassBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_).m_60999_())));
    public static final Map<DyeColor, RegistryObject<Block>> STAINED_GLASS_BRICKS_PANE = Helpers.mapOfKeys(DyeColor.class, color -> DFCBlocks.register("glass/pane/bricks/" + color.m_41065_(), () -> new IronBarsBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_).m_60999_())));
    public static final RegistryObject<Block> GLASS_TILES = DFCBlocks.register("glass/block/tiles/plain", () -> new GlassBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_).m_60999_()));
    public static final RegistryObject<Block> GLASS_TILES_PANE = DFCBlocks.register("glass/pane/tiles/plain", () -> new IronBarsBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50185_).m_60999_()));
    public static final RegistryObject<Block> FOGGY_GLASS_TILES = DFCBlocks.register("glass/block/tiles/foggy", () -> new GlassBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_).m_60999_()));
    public static final RegistryObject<Block> FOGGY_GLASS_TILES_PANE = DFCBlocks.register("glass/pane/tiles/foggy", () -> new IronBarsBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50185_).m_60999_()));
    public static final Map<DyeColor, RegistryObject<Block>> STAINED_GLASS_TILES = Helpers.mapOfKeys(DyeColor.class, color -> DFCBlocks.register("glass/block/tiles/" + color.m_41065_(), () -> new GlassBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_).m_60999_())));
    public static final Map<DyeColor, RegistryObject<Block>> STAINED_GLASS_TILES_PANE = Helpers.mapOfKeys(DyeColor.class, color -> DFCBlocks.register("glass/pane/tiles/" + color.m_41065_(), () -> new IronBarsBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_).m_60999_())));
    public static final Map<Wood, RegistryObject<Block>> WOOD_PANELS = Helpers.mapOfKeys(Wood.class, wood -> DFCBlocks.register("wood/panel/" + wood.m_7912_(), () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_))));
    public static final Map<DFCMetal.DFCDefault, RegistryObject<LiquidBlock>> DFC_METAL_FLUIDS = Helpers.mapOfKeys(DFCMetal.DFCDefault.class, metal -> DFCBlocks.registerNoItem("metal/fluid/" + metal.name(), () -> new LiquidBlock((Supplier)DFCFluids.METALS.get(metal).source(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49991_).m_222994_())));
    public static final RegistryObject<LiquidBlock> PLASTER_FLUID = DFCBlocks.registerNoItem("fluid/plaster", () -> new LiquidBlock((Supplier)DFCFluids.PLASTER.flowing(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49990_).m_222994_()));
    public static final RegistryObject<LiquidBlock> CONCRETE_FLUID = DFCBlocks.registerNoItem("fluid/concrete", () -> new LiquidBlock((Supplier)DFCFluids.CONCRETE.flowing(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49990_).m_222994_()));

    private static <T extends Block> RegistryObject<T> registerNoItem(String name, Supplier<T> blockSupplier) {
        return DFCBlocks.register(name, blockSupplier, (Function)null);
    }

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<T> blockSupplier) {
        return DFCBlocks.register(name, blockSupplier, (T block) -> new BlockItem(block, new Item.Properties()));
    }

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<T> blockSupplier, Item.Properties blockItemProperties) {
        return DFCBlocks.register(name, blockSupplier, (T block) -> new BlockItem(block, blockItemProperties));
    }

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<T> blockSupplier, @Nullable Function<T, ? extends BlockItem> blockItemFactory) {
        return RegistrationHelpers.registerBlock(BLOCKS, DFCItems.ITEMS, (String)name, blockSupplier, blockItemFactory);
    }
}

