/*
 * Decompiled with CFR 0.152.
 */
package com.thomas7520.bubbleschat.packet;

import com.thomas7520.bubbleschat.BubblesConfig;
import com.thomas7520.bubbleschat.client.ClientBubblesUtil;
import com.thomas7520.bubbleschat.util.Bubble;
import com.thomas7520.bubbleschat.util.Message;
import com.thomas7520.bubbleschat.util.SpecColor;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class SCSyncBubbleMessage {
    private long startTime;
    private String text;
    private UUID uuid;

    public SCSyncBubbleMessage(long startTime, String text, UUID uuid) {
        this.startTime = startTime;
        this.text = text;
        this.uuid = uuid;
    }

    public SCSyncBubbleMessage() {
    }

    public static void encode(SCSyncBubbleMessage message, FriendlyByteBuf buf) {
        buf.writeLong(message.startTime);
        buf.m_130070_(message.text);
        buf.m_130077_(message.uuid);
    }

    public static SCSyncBubbleMessage decode(FriendlyByteBuf buf) {
        SCSyncBubbleMessage message = new SCSyncBubbleMessage();
        message.startTime = buf.readLong();
        message.text = buf.m_130136_(Short.MAX_VALUE);
        message.uuid = buf.m_130259_();
        return message;
    }

    public static void handle(SCSyncBubbleMessage packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> SCSyncBubbleMessage.handleClient(packet));
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleClient(SCSyncBubbleMessage packet) {
        Bubble bubble = ClientBubblesUtil.BUBBLES_SYNC.get(packet.uuid);
        if (bubble == null) {
            bubble = new Bubble(packet.startTime, packet.text);
            ClientBubblesUtil.BUBBLES_SYNC.put(packet.uuid, bubble);
        } else {
            if (bubble.getMessages().size() == ((Integer)BubblesConfig.CLIENT.maxBubblesStack.get()).intValue()) {
                bubble.getMessages().removeLast();
            }
            bubble.getMessages().addFirst(new Message(packet.startTime, packet.text, new SpecColor((List)BubblesConfig.CLIENT.colorOutline.get()), new SpecColor((List)BubblesConfig.CLIENT.colorInside.get()), new SpecColor((List)BubblesConfig.CLIENT.colorText.get())));
        }
    }
}

