/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.inventory.bit;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.inventory.bit.IBitInventory;
import mod.chiselsandbits.api.inventory.bit.IBitInventoryItem;
import mod.chiselsandbits.api.inventory.bit.IBitInventoryItemStack;
import mod.chiselsandbits.api.item.bit.IBitItem;
import mod.chiselsandbits.api.item.bit.IBitItemManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public abstract class AbstractBitInventory
implements IBitInventory {
    protected AbstractBitInventory() {
    }

    @Override
    public boolean canExtract(IBlockInformation blockState, int count) {
        int contained = this.getMaxExtractAmount(blockState);
        return count <= contained;
    }

    @Override
    public int getMaxExtractAmount(IBlockInformation blockState) {
        return IntStream.range(0, this.getInventorySize()).mapToObj(this::getItem).filter(stack -> stack.m_41720_() instanceof IBitItem || stack.m_41720_() instanceof IBitInventoryItem).mapToInt(stack -> {
            Item patt2055$temp = stack.m_41720_();
            if (patt2055$temp instanceof IBitItem) {
                IBitItem bitItem = (IBitItem)patt2055$temp;
                if (bitItem.getBlockInformation((ItemStack)stack).equals(blockState)) {
                    return stack.m_41613_();
                }
                return 0;
            }
            Item patt2338$temp = stack.m_41720_();
            if (patt2338$temp instanceof IBitInventoryItem) {
                IBitInventoryItem bitInventoryItem = (IBitInventoryItem)patt2338$temp;
                IBitInventoryItemStack bitInventory = bitInventoryItem.create((ItemStack)stack);
                return bitInventory.getMaxExtractAmount(blockState);
            }
            return 0;
        }).sum();
    }

    protected abstract ItemStack getItem(int var1);

    protected abstract int getInventorySize();

    @Override
    public void extract(IBlockInformation blockInformation, int count) throws IllegalArgumentException {
        ItemStack stack;
        int i;
        if (!this.canExtract(blockInformation, count)) {
            throw new IllegalArgumentException("Can not extract: " + blockInformation);
        }
        int toExtract = count;
        for (i = this.getInventorySize() - 1; i >= 0; --i) {
            stack = this.getItem(i);
            Item item = stack.m_41720_();
            if (!(item instanceof IBitInventoryItem)) continue;
            IBitInventoryItem bitInventoryItem = (IBitInventoryItem)item;
            IBitInventoryItemStack bitInventory = bitInventoryItem.create(stack);
            int inventoryExtractCount = Math.min(toExtract, bitInventory.getMaxExtractAmount(blockInformation));
            toExtract -= inventoryExtractCount;
            bitInventory.extract(blockInformation, inventoryExtractCount);
            ItemStack newStack = bitInventory.toItemStack();
            this.setSlotContents(i, newStack);
        }
        if (toExtract <= 0) {
            return;
        }
        for (i = this.getInventorySize() - 1; i >= 0; --i) {
            IBitItem bitItem;
            stack = this.getItem(i);
            Item bitInventory = stack.m_41720_();
            if (!(bitInventory instanceof IBitItem) || !(bitItem = (IBitItem)bitInventory).getBlockInformation(stack).equals(blockInformation)) continue;
            int stackExtractCount = Math.min(toExtract, stack.m_41613_());
            toExtract -= stackExtractCount;
            stack.m_41764_(stack.m_41613_() - stackExtractCount);
            this.setSlotContents(i, stack);
        }
    }

    protected abstract void setSlotContents(int var1, ItemStack var2);

    @Override
    public boolean canInsert(IBlockInformation blockState, int count) {
        int insertionCount = this.getMaxInsertAmount(blockState);
        return count <= insertionCount;
    }

    protected int getMaxBitsForSlot() {
        return IBitItemManager.getInstance().getMaxStackSize();
    }

    @Override
    public int getMaxInsertAmount(IBlockInformation blockInformation) {
        return IntStream.range(0, this.getInventorySize()).mapToObj(this::getItem).filter(stack -> stack.m_41720_() instanceof IBitItem || stack.m_41720_() instanceof IBitInventoryItem || stack.m_41619_()).mapToInt(stack -> {
            if (stack.m_41619_()) {
                return this.getMaxBitsForSlot();
            }
            Item patt6780$temp = stack.m_41720_();
            if (patt6780$temp instanceof IBitItem) {
                IBitItem bitItem = (IBitItem)patt6780$temp;
                if (bitItem.getBlockInformation((ItemStack)stack).equals(blockInformation)) {
                    return this.getMaxBitsForSlot() - stack.m_41613_();
                }
                return 0;
            }
            Item patt7091$temp = stack.m_41720_();
            if (patt7091$temp instanceof IBitInventoryItem) {
                IBitInventoryItem bitInventoryItem = (IBitInventoryItem)patt7091$temp;
                IBitInventoryItemStack bitInventory = bitInventoryItem.create((ItemStack)stack);
                return bitInventory.getMaxInsertAmount(blockInformation);
            }
            return 0;
        }).sum();
    }

    @Override
    public void insert(IBlockInformation blockInformation, int count) throws IllegalArgumentException {
        Object bitInventory;
        int i;
        Item newStack;
        ItemStack stack;
        if (!this.canInsert(blockInformation, count)) {
            throw new IllegalArgumentException("Can not insert: " + blockInformation);
        }
        int currentRawCount = 0;
        for (int i2 = 0; i2 < this.getInventorySize(); ++i2) {
            IBitItem bitItem;
            ItemStack stack2 = this.getItem(i2);
            Item item = stack2.m_41720_();
            if (!(item instanceof IBitItem) || !(bitItem = (IBitItem)item).getBlockInformation(stack2).equals(blockInformation)) continue;
            currentRawCount += stack2.m_41613_();
        }
        int toInsert = count;
        if (currentRawCount == 0) {
            for (int i3 = 0; i3 < this.getInventorySize(); ++i3) {
                int stackInsertCount;
                stack = this.getItem(i3);
                if (stack.m_41619_() && (stackInsertCount = Math.min(toInsert, this.getMaxBitsForSlot())) > 0) {
                    toInsert -= stackInsertCount;
                    newStack = IBitItemManager.getInstance().create(blockInformation, stackInsertCount);
                    this.setSlotContents(i3, (ItemStack)newStack);
                    break;
                }
                if (toInsert > 0) continue;
                return;
            }
        }
        if (currentRawCount < this.getMaxBitsForSlot()) {
            for (int i4 = 0; i4 < this.getInventorySize(); ++i4) {
                int stackInsertCount;
                IBitItem bitItem;
                stack = this.getItem(i4);
                newStack = stack.m_41720_();
                if (newStack instanceof IBitItem && (bitItem = (IBitItem)newStack).getBlockInformation(stack).equals(blockInformation) && (stackInsertCount = Math.min(toInsert, this.getMaxBitsForSlot() - stack.m_41613_())) > 0) {
                    toInsert -= stackInsertCount;
                    stack.m_41764_(stack.m_41613_() + stackInsertCount);
                    this.setSlotContents(i4, stack);
                }
                if (toInsert > 0) continue;
                return;
            }
        }
        for (i = this.getInventorySize() - 1; i >= 0; --i) {
            IBitInventoryItem bitInventoryItem;
            int inventoryInsertCount;
            stack = this.getItem(i);
            Item stackInsertCount = stack.m_41720_();
            if (stackInsertCount instanceof IBitInventoryItem && (inventoryInsertCount = Math.min(toInsert, (bitInventory = (bitInventoryItem = (IBitInventoryItem)stackInsertCount).create(stack)).getMaxInsertAmount(blockInformation))) > 0) {
                toInsert -= inventoryInsertCount;
                bitInventory.insert(blockInformation, inventoryInsertCount);
                ItemStack newStack2 = bitInventory.toItemStack();
                this.setSlotContents(i, newStack2);
            }
            if (toInsert > 0) continue;
            return;
        }
        for (i = 0; i < this.getInventorySize(); ++i) {
            int stackInsertCount;
            IBitItem bitItem;
            stack = this.getItem(i);
            bitInventory = stack.m_41720_();
            if (bitInventory instanceof IBitItem && (bitItem = (IBitItem)bitInventory).getBlockInformation(stack).equals(blockInformation) && (stackInsertCount = Math.min(toInsert, this.getMaxBitsForSlot() - stack.m_41613_())) > 0) {
                toInsert -= stackInsertCount;
                stack.m_41764_(stack.m_41613_() + stackInsertCount);
                this.setSlotContents(i, stack);
            }
            if (toInsert > 0) continue;
            return;
        }
        for (i = 0; i < this.getInventorySize(); ++i) {
            int stackInsertCount;
            stack = this.getItem(i);
            if (stack.m_41619_() && (stackInsertCount = Math.min(toInsert, this.getMaxBitsForSlot())) > 0) {
                toInsert -= stackInsertCount;
                newStack = IBitItemManager.getInstance().create(blockInformation, stackInsertCount);
                this.setSlotContents(i, (ItemStack)newStack);
            }
            if (toInsert > 0) continue;
            return;
        }
    }

    @Override
    public Map<IBlockInformation, Integer> getContainedStates() {
        return IntStream.range(0, this.getInventorySize()).mapToObj(this::getItem).filter(stack -> stack.m_41720_() instanceof IBitItem || stack.m_41720_() instanceof IBitInventoryItem).map(stack -> {
            Item patt12718$temp = stack.m_41720_();
            if (patt12718$temp instanceof IBitItem) {
                IBitItem bitItem = (IBitItem)patt12718$temp;
                return Maps.newHashMap((Map)ImmutableMap.of((Object)bitItem.getBlockInformation((ItemStack)stack), (Object)stack.m_41613_()));
            }
            Item patt12923$temp = stack.m_41720_();
            if (patt12923$temp instanceof IBitInventoryItem) {
                IBitInventoryItem bitInventoryItem = (IBitInventoryItem)patt12923$temp;
                IBitInventoryItemStack bitInventory = bitInventoryItem.create((ItemStack)stack);
                return Maps.newHashMap(bitInventory.getContainedStates());
            }
            return Maps.newHashMap((Map)ImmutableMap.of());
        }).reduce(Maps.newHashMap(), (blockStateIntegerHashMap, blockStateIntegerHashMap2) -> {
            HashMap result = Maps.newHashMap((Map)blockStateIntegerHashMap);
            blockStateIntegerHashMap2.forEach((state, count) -> {
                if (!result.containsKey(state)) {
                    result.put(state, count);
                } else {
                    result.put(state, (Integer)result.get(state) + count);
                }
            });
            return result;
        });
    }
}

