/*
 * Decompiled with CFR 0.152.
 */
package net.bojarsky.bojarskythings.event;

import com.google.common.collect.Multimap;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="bojarskythings", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ModEventBusEvents {
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#.#");
    private static final double BASE_PLAYER_ATTACK_SPEED = 4.0;
    private static final double BASE_HAND_DAMAGE = 1.0;
    private static final TextColor TOOLTIP_BLUE = TextColor.m_131270_((ChatFormatting)ChatFormatting.BLUE);
    private static final TextColor TOOLTIP_RED = TextColor.m_131270_((ChatFormatting)ChatFormatting.RED);
    private static final TextColor TOOLTIP_GRAY = TextColor.m_131270_((ChatFormatting)ChatFormatting.GRAY);

    @SubscribeEvent
    public static void addCustomTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        Item item = stack.m_41720_();
        if (!ModEventBusEvents.isWeapon(item)) {
            return;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_("BojarskySharpenLevel")) {
            return;
        }
        int sharpenLevel = tag.m_128451_("BojarskySharpenLevel");
        if (sharpenLevel <= 0) {
            return;
        }
        double weaponBaseDamage = ModEventBusEvents.getBaseWeaponDamage(item);
        double bonusCalculationBase = weaponBaseDamage + 1.0;
        double bonusDamage = bonusCalculationBase * (double)sharpenLevel * 0.1;
        double totalDamage = weaponBaseDamage + 1.0 + bonusDamage;
        double attackSpeedModifierValue = 0.0;
        Multimap defaultModifiers = item.m_7167_(EquipmentSlot.MAINHAND);
        Collection speedModifiers = defaultModifiers.get((Object)Attributes.f_22283_);
        for (AttributeModifier modifier : speedModifiers) {
            if (modifier.m_22217_() != AttributeModifier.Operation.ADDITION) continue;
            attackSpeedModifierValue += modifier.m_22218_();
        }
        double actualAttackSpeed = 4.0 + attackSpeedModifierValue;
        String formattedTotalDamage = DECIMAL_FORMAT.format(totalDamage);
        String formattedAttackSpeed = DECIMAL_FORMAT.format(actualAttackSpeed);
        List tooltip = event.getToolTip();
        ListIterator<MutableComponent> iterator = tooltip.listIterator();
        boolean headerFound = false;
        boolean nameModified = false;
        while (iterator.hasNext()) {
            Component component = (Component)iterator.next();
            if (iterator.previousIndex() == 0 && !nameModified) {
                MutableComponent mutable;
                MutableComponent currentName = component instanceof MutableComponent ? (mutable = (MutableComponent)component) : component.m_6881_();
                MutableComponent suffixComponent = Component.m_237113_((String)(" +" + sharpenLevel)).m_130940_(ChatFormatting.GOLD);
                currentName.m_7220_((Component)suffixComponent);
                iterator.set(currentName);
                nameModified = true;
            }
            String line = component.getString().toLowerCase();
            TextColor textColor = component.m_7383_().m_131135_();
            if (textColor != null && textColor.equals((Object)TOOLTIP_GRAY) && (line.contains("when in main hand") || line.contains("\u0432 \u0433\u043b\u0430\u0432\u043d\u043e\u0439 \u0440\u0443\u043a\u0435"))) {
                headerFound = true;
                iterator.remove();
                continue;
            }
            if (!line.contains(Attributes.f_22281_.m_22087_().substring(15)) && !line.contains(Attributes.f_22283_.m_22087_().substring(15)) || textColor == null || !textColor.equals((Object)TOOLTIP_BLUE) && !textColor.equals((Object)TOOLTIP_RED)) continue;
            iterator.remove();
        }
        int insertIndex = 1;
        if (tooltip.isEmpty()) {
            insertIndex = 0;
        }
        if (nameModified && insertIndex <= tooltip.size()) {
            tooltip.add(insertIndex++, Component.m_237119_());
        }
        tooltip.add(insertIndex++, Component.m_237115_((String)"item.modifiers.mainhand").m_130940_(ChatFormatting.GRAY));
        tooltip.add(insertIndex++, Component.m_237113_((String)" ").m_7220_((Component)Component.m_237110_((String)"attribute.modifier.equals.0", (Object[])new Object[]{formattedTotalDamage, Component.m_237115_((String)Attributes.f_22281_.m_22087_())})).m_130940_(ChatFormatting.DARK_GREEN));
        tooltip.add(insertIndex++, Component.m_237113_((String)" ").m_7220_((Component)Component.m_237110_((String)"attribute.modifier.equals.0", (Object[])new Object[]{formattedAttackSpeed, Component.m_237115_((String)Attributes.f_22283_.m_22087_())})).m_130940_(ChatFormatting.DARK_GREEN));
    }

    private static boolean isWeapon(Item item) {
        return item instanceof SwordItem || item instanceof AxeItem || item instanceof TridentItem;
    }

    private static double getBaseWeaponDamage(Item item) {
        if (item instanceof SwordItem) {
            SwordItem sword = (SwordItem)item;
            return sword.m_43299_();
        }
        if (item instanceof AxeItem) {
            AxeItem axe = (AxeItem)item;
            return axe.m_41008_();
        }
        if (item instanceof TridentItem) {
            return 8.0;
        }
        return 0.0;
    }
}

