/*
 * Decompiled with CFR 0.152.
 */
package net.bojarsky.bojarskythings.event;

import com.mojang.serialization.Codec;
import net.bojarsky.bojarskythings.BojarskyThings;
import net.bojarsky.bojarskythings.config.MobConfig;
import net.bojarsky.bojarskythings.entity.ModEntities;
import net.bojarsky.bojarskythings.event.ModBusEvents;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;

public class GlobalBanditSpawnModifier
implements BiomeModifier {
    public void modify(Holder<Biome> biomeHolder, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        int archerSpawnWeight;
        if (phase != BiomeModifier.Phase.ADD) {
            return;
        }
        ResourceLocation biomeName = biomeHolder.m_203543_().map(ResourceKey::m_135782_).orElse(null);
        if (biomeName == null || !"tfc".equals(biomeName.m_135827_())) {
            return;
        }
        if (biomeHolder.m_203656_(BiomeTags.f_207603_) || biomeHolder.m_203656_(BiomeTags.f_207602_) || biomeHolder.m_203656_(BiomeTags.f_207605_) || biomeHolder.m_203656_(BiomeTags.f_207604_) || biomeHolder.m_203656_(BiomeTags.f_207612_) || biomeHolder.m_203656_(BiomeTags.f_215818_) || biomeHolder.m_203656_(Tags.Biomes.IS_VOID)) {
            return;
        }
        int banditSpawnWeight = (Integer)MobConfig.SERVER.bandit.SPAWN_WEIGHT.get();
        if (banditSpawnWeight > 0) {
            MobSpawnSettings.SpawnerData banditSpawnerData = new MobSpawnSettings.SpawnerData((EntityType)ModEntities.BANDIT.get(), banditSpawnWeight, ((Integer)MobConfig.SERVER.bandit.SPAWN_MIN_GROUP_SIZE.get()).intValue(), ((Integer)MobConfig.SERVER.bandit.SPAWN_MAX_GROUP_SIZE.get()).intValue());
            builder.getMobSpawnSettings().m_48376_(MobCategory.MONSTER, banditSpawnerData);
            BojarskyThings.getLogger().debug("GlobalBanditSpawnModifier added Bandit spawn to TFC biome: " + biomeName);
        }
        if ((archerSpawnWeight = ((Integer)MobConfig.SERVER.banditArcher.SPAWN_WEIGHT.get()).intValue()) > 0) {
            MobSpawnSettings.SpawnerData archerSpawnerData = new MobSpawnSettings.SpawnerData((EntityType)ModEntities.BANDIT_ARCHER.get(), archerSpawnWeight, ((Integer)MobConfig.SERVER.banditArcher.SPAWN_MIN_GROUP_SIZE.get()).intValue(), ((Integer)MobConfig.SERVER.banditArcher.SPAWN_MAX_GROUP_SIZE.get()).intValue());
            builder.getMobSpawnSettings().m_48376_(MobCategory.MONSTER, archerSpawnerData);
            BojarskyThings.getLogger().debug("GlobalBanditSpawnModifier added Bandit Archer spawn to TFC biome: " + biomeName);
        }
    }

    public Codec<? extends BiomeModifier> codec() {
        return (Codec)ModBusEvents.GLOBAL_BANDIT_SPAWN_MODIFIER_CODEC.get();
    }

    public static Codec<GlobalBanditSpawnModifier> makeCodec() {
        return Codec.unit(GlobalBanditSpawnModifier::new);
    }
}

