/*
 * Decompiled with CFR 0.152.
 */
package net.bojarsky.bojarskythings.blockentity;

import net.bojarsky.bojarskythings.blockentity.ModBlockEntities;
import net.bojarsky.bojarskythings.items.ModItems;
import net.bojarsky.bojarskythings.screen.ModGrindstoneMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModGrindstoneBlockEntity
extends BlockEntity
implements MenuProvider {
    public static final int INVENTORY_SIZE = 1;
    public static final int STONE_SLOT_INDEX = 0;
    private final ItemStackHandler itemHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            ModGrindstoneBlockEntity.this.m_6596_();
            if (ModGrindstoneBlockEntity.this.f_58857_ != null && !ModGrindstoneBlockEntity.this.f_58857_.m_5776_()) {
                ModGrindstoneBlockEntity.this.f_58857_.m_46717_(ModGrindstoneBlockEntity.this.m_58899_(), ModGrindstoneBlockEntity.this.m_58900_().m_60734_());
            }
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            Item item = stack.m_41720_();
            return item == ModItems.SHARPENING_STONE_1.get() || item == ModItems.SHARPENING_STONE_2.get() || item == ModItems.SHARPENING_STONE_3.get();
        }

        public int getSlotLimit(int slot) {
            return 16;
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();

    public ModGrindstoneBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.MOD_GRINDSTONE_BE.get(), pos, state);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.bojarskythings.mod_grindstone");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        return new ModGrindstoneMenu(windowId, playerInventory, this);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    protected void m_183515_(CompoundTag nbt) {
        nbt.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        super.m_183515_(nbt);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128441_("inventory")) {
            this.itemHandler.deserializeNBT(nbt.m_128469_("inventory"));
        }
    }

    public ItemStack getStoneInSlot() {
        return this.itemHandler.getStackInSlot(0);
    }

    public boolean hasStoneInSlot() {
        ItemStack stackInSlot = this.getStoneInSlot();
        if (stackInSlot.m_41619_()) {
            return false;
        }
        Item item = stackInSlot.m_41720_();
        boolean isValidStone = item == ModItems.SHARPENING_STONE_1.get() || item == ModItems.SHARPENING_STONE_2.get() || item == ModItems.SHARPENING_STONE_3.get();
        return isValidStone;
    }

    public void consumeStoneFromSlot() {
        this.itemHandler.extractItem(0, 1, false);
    }

    public void dropContents(Level level, BlockPos pos) {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)level, (BlockPos)pos, (Container)inventory);
    }
}

