/*
 * Decompiled with CFR 0.152.
 */
package net.bojarsky.bojarskyauthclient.libs.oshi.hardware.platform.unix.aix;

import java.util.List;
import java.util.function.Supplier;
import net.bojarsky.bojarskyauthclient.libs.oshi.annotation.concurrent.Immutable;
import net.bojarsky.bojarskyauthclient.libs.oshi.driver.unix.aix.Lscfg;
import net.bojarsky.bojarskyauthclient.libs.oshi.hardware.common.AbstractBaseboard;
import net.bojarsky.bojarskyauthclient.libs.oshi.util.Util;
import net.bojarsky.bojarskyauthclient.libs.oshi.util.tuples.Triplet;

@Immutable
final class AixBaseboard
extends AbstractBaseboard {
    private static final String IBM = "IBM";
    private final String model;
    private final String serialNumber;
    private final String version;

    AixBaseboard(Supplier<List<String>> lscfg) {
        Triplet<String, String, String> msv = Lscfg.queryBackplaneModelSerialVersion(lscfg.get());
        this.model = Util.isBlank(msv.getA()) ? "unknown" : msv.getA();
        this.serialNumber = Util.isBlank(msv.getB()) ? "unknown" : msv.getB();
        this.version = Util.isBlank(msv.getC()) ? "unknown" : msv.getC();
    }

    @Override
    public String getManufacturer() {
        return IBM;
    }

    @Override
    public String getModel() {
        return this.model;
    }

    @Override
    public String getSerialNumber() {
        return this.serialNumber;
    }

    @Override
    public String getVersion() {
        return this.version;
    }
}

