/*
 * Decompiled with CFR 0.152.
 */
package net.bojarsky.bojarskyauthclient.client;

import com.mojang.logging.LogUtils;
import java.util.concurrent.atomic.AtomicBoolean;
import net.bojarsky.bojarskyauthapi.network.C2SRequestVerificationPacket;
import net.bojarsky.bojarskyauthapi.network.PacketHandler;
import net.bojarsky.bojarskyauthapi.network.S2CVerificationResponsePacket;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="bojarskyauthclient", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientAuthHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final AtomicBoolean verificationReceived = new AtomicBoolean(false);
    private static final long VERIFICATION_TIMEOUT_MS = 30000L;
    private static final AtomicBoolean verificationAttempted = new AtomicBoolean(false);
    private static final AtomicBoolean needsCrash = new AtomicBoolean(false);
    private static long verificationRequestStartTime = 0L;

    @SubscribeEvent
    public static void onClientLoggedIn(ClientPlayerNetworkEvent.LoggingIn event) {
        LOGGER.info("CLIENTAUTH HANDLER: ClientPlayerNetworkEvent.LoggingIn event triggered!");
        verificationReceived.set(false);
        verificationAttempted.set(false);
        needsCrash.set(false);
        verificationRequestStartTime = 0L;
        LOGGER.debug("CLIENTAUTH HANDLER: Flags reset for new login.");
        LOGGER.info("CLIENTAUTH HANDLER: Attempting to send C2SRequestVerificationPacket...");
        PacketHandler.sendToServer((Object)new C2SRequestVerificationPacket());
        verificationAttempted.set(true);
        verificationRequestStartTime = System.currentTimeMillis();
        LOGGER.info("CLIENTAUTH HANDLER: C2SRequestVerificationPacket sent. Verification process initiated. Timeout: {}ms", (Object)30000L);
    }

    @SubscribeEvent
    public static void onClientLoggedOut(ClientPlayerNetworkEvent.LoggingOut event) {
        LOGGER.info("CLIENTAUTH HANDLER: ClientPlayerNetworkEvent.LoggingOut event triggered. Resetting flags.");
        verificationReceived.set(false);
        verificationAttempted.set(false);
        needsCrash.set(false);
        verificationRequestStartTime = 0L;
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            if (needsCrash.get()) {
                needsCrash.set(false);
                LOGGER.error("CLIENTAUTH HANDLER (ClientTick): needsCrash=true. Throwing exception for failed verification!");
                throw new RuntimeException("Bojarsky Auth: Server verification failed or timed out! (Triggered from Client Tick)");
            }
            if (verificationAttempted.get() && !verificationReceived.get() && verificationRequestStartTime > 0L && System.currentTimeMillis() - verificationRequestStartTime > 30000L) {
                LOGGER.error("CLIENTAUTH HANDLER (ClientTick): Verification TIMED OUT after {}ms!", (Object)30000L);
                LOGGER.error("!!! ========================================================= !!!");
                LOGGER.error("!!! Bojarsky Auth: Server verification timed out!             !!!");
                LOGGER.error("!!! Ensure server has BojarskyAuth and is responding.       !!!");
                LOGGER.error("!!! Client will now close.                                    !!!");
                LOGGER.error("!!! ========================================================= !!!");
                verificationAttempted.set(false);
                verificationRequestStartTime = 0L;
                needsCrash.set(true);
            }
        }
    }

    public static void handleVerificationResponse(S2CVerificationResponsePacket msg) {
        LOGGER.info("CLIENTAUTH HANDLER: handleVerificationResponse invoked for S2CVerificationResponsePacket.");
        LOGGER.info("CLIENTAUTH HANDLER: Received S2C success = {}", (Object)msg.isSuccess());
        if (!verificationAttempted.get()) {
            LOGGER.warn("CLIENTAUTH HANDLER: Received S2CVerificationResponsePacket, but no verification was marked as 'attempted'. Potentially late/duplicate or uninitiated. Current verificationReceived: {}", (Object)verificationReceived.get());
            if (verificationReceived.get() && !msg.isSuccess()) {
                LOGGER.error("CLIENTAUTH HANDLER: CRITICAL! Already successfully verified, but received a FAILURE packet! Setting needsCrash=true.");
                needsCrash.set(true);
            }
            return;
        }
        if (msg.isSuccess()) {
            LOGGER.info("CLIENTAUTH HANDLER: Verification SUCCESSFUL. Setting verificationReceived=true.");
            verificationReceived.set(true);
            needsCrash.set(false);
        } else {
            LOGGER.error("CLIENTAUTH HANDLER: Verification EXPLICITLY FAILED by server (success=false). Setting needsCrash=true.");
            needsCrash.set(true);
        }
        verificationAttempted.set(false);
        verificationRequestStartTime = 0L;
    }
}

