/*
 * Decompiled with CFR 0.152.
 */
package net.bojarsky.bojarskyauthapi.network;

import com.mojang.logging.LogUtils;
import net.bojarsky.bojarskyauthapi.network.C2SRequestVerificationPacket;
import net.bojarsky.bojarskyauthapi.network.ClientMetricsPacket;
import net.bojarsky.bojarskyauthapi.network.S2CVerificationResponsePacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import org.slf4j.Logger;

public class PacketHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String PROTOCOL_VERSION = "1";
    public static final String CHANNEL_NAME = "bojarsky_auth_channel";
    public static final ResourceLocation CHANNEL_ID = new ResourceLocation("bojarskyauthapi", "bojarsky_auth_channel");
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)CHANNEL_ID, () -> "1", "1"::equals, "1"::equals);
    private static int packetId = 0;

    private static int nextId() {
        return packetId++;
    }

    public static void register() {
        LOGGER.info("API PacketHandler: Registering messages...");
        INSTANCE.messageBuilder(C2SRequestVerificationPacket.class, PacketHandler.nextId(), NetworkDirection.PLAY_TO_SERVER).encoder(C2SRequestVerificationPacket::encode).decoder(C2SRequestVerificationPacket::decode).consumerMainThread(C2SRequestVerificationPacket::handlePacket).add();
        LOGGER.info("API PacketHandler: Registered C2SRequestVerificationPacket with ID {}", (Object)(packetId - 1));
        INSTANCE.messageBuilder(S2CVerificationResponsePacket.class, PacketHandler.nextId(), NetworkDirection.PLAY_TO_CLIENT).encoder(S2CVerificationResponsePacket::encode).decoder(S2CVerificationResponsePacket::decode).consumerMainThread(S2CVerificationResponsePacket::handlePacket).add();
        LOGGER.info("API PacketHandler: Registered S2CVerificationResponsePacket with ID {}", (Object)(packetId - 1));
        INSTANCE.messageBuilder(ClientMetricsPacket.class, PacketHandler.nextId(), NetworkDirection.PLAY_TO_SERVER).encoder(ClientMetricsPacket::encode).decoder(ClientMetricsPacket::decode).consumerMainThread(ClientMetricsPacket::handlePacket).add();
        LOGGER.info("API PacketHandler: Registered ClientMetricsPacket with ID {}", (Object)(packetId - 1));
        LOGGER.info("API PacketHandler: Message registration complete.");
    }

    public static <MSG> void sendToServer(MSG message) {
        INSTANCE.sendToServer(message);
        LOGGER.debug("API PacketHandler: Sent message to server: {}", (Object)message.getClass().getSimpleName());
    }

    public static <MSG> void sendToPlayer(MSG message, ServerPlayer player) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), message);
        LOGGER.debug("API PacketHandler: Sent message to player {}: {}", (Object)player.m_36316_().getName(), (Object)message.getClass().getSimpleName());
    }
}

