/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.barrels_2012.common;

import com.eerussianguy.barrels_2012.BarrelConfig;
import com.eerussianguy.barrels_2012.Barrels2012;
import com.eerussianguy.barrels_2012.common.PlayerGlowCapability;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.entities.IGlow;
import net.dries007.tfc.common.items.LampBlockItem;
import net.dries007.tfc.util.LampFuel;
import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.SlotResult;

public class PlayerGlow
implements ICapabilitySerializable<CompoundTag>,
IGlow {
    private final Player player;
    private final LazyOptional<PlayerGlow> capability;
    private long lastFuelTick;
    private BlockPos lightPos;
    private boolean lit;

    public static void reset(Player player) {
        player.getCapability(PlayerGlowCapability.CAPABILITY).ifPresent(cap -> {
            cap.resetCounter();
            if (player.m_9236_().isAreaLoaded(cap.lightPos, 2)) {
                cap.tryRemoveLight();
            }
        });
    }

    public PlayerGlow(Player player) {
        this.player = player;
        this.lastFuelTick = -1L;
        this.capability = LazyOptional.of(() -> this);
        this.lightPos = BlockPos.f_121853_;
        this.lit = false;
    }

    public void tickGlow() {
        if (this.player.f_19797_ % this.getLightUpdateInterval() == 0) {
            boolean placeLight = false;
            SlotResult curio = Barrels2012.getCurio((LivingEntity)this.player, st -> st.m_41720_() instanceof LampBlockItem);
            if (curio != null) {
                placeLight = this.tickInternal(curio);
            }
            if (placeLight) {
                this.lit = true;
                super.tickGlow();
            } else {
                this.lit = false;
                this.resetCounter();
                if (this.initialized()) {
                    this.tryRemoveLight();
                }
            }
        }
    }

    private boolean tickInternal(SlotResult curio) {
        ItemStack stack = curio.stack();
        return stack.getCapability(Capabilities.FLUID_ITEM).map(cap -> {
            FluidStack fluid = cap.getFluidInTank(0);
            LampFuel fuel = LampFuel.get((Fluid)fluid.getFluid(), (BlockState)((LampBlockItem)stack.m_41720_()).m_40614_().m_49966_());
            if (!fluid.isEmpty() && fuel != null) {
                if (this.lastFuelTick == -1L || !((Boolean)BarrelConfig.SERVER.enableLampBurningFuel.get()).booleanValue()) {
                    this.resetCounter();
                    return true;
                }
                int usage = Mth.m_14107_((double)((double)this.getTicksSinceFuelUpdate() / (double)fuel.getBurnRate()));
                if (usage >= 1) {
                    FluidStack used = cap.drain(usage, IFluidHandler.FluidAction.EXECUTE);
                    if (used.isEmpty() || used.getAmount() < usage) {
                        return false;
                    }
                    this.resetCounter();
                }
                return true;
            }
            return false;
        }).orElse(false);
    }

    private void resetCounter() {
        this.lastFuelTick = Calendars.get((LevelReader)this.player.m_9236_()).getTicks();
    }

    private long getTicksSinceFuelUpdate() {
        return Calendars.get((LevelReader)this.player.m_9236_()).getTicks() - this.lastFuelTick;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return cap == PlayerGlowCapability.CAPABILITY ? this.capability.cast() : LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        this.saveLight(nbt);
        nbt.m_128356_("fuelTick", this.lastFuelTick);
        nbt.m_128379_("lit", this.lit);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.readLight(nbt);
        this.lastFuelTick = nbt.m_128454_("fuelTick");
        this.lit = nbt.m_128471_("lit");
    }

    public void setLightPos(BlockPos blockPos) {
        this.lightPos = blockPos;
    }

    public BlockPos getLightPos() {
        return this.lightPos;
    }

    public int getLightLevel() {
        return (Integer)BarrelConfig.SERVER.lampBrightness.get();
    }

    public int getLightUpdateInterval() {
        return (Integer)BarrelConfig.SERVER.lampUpdateInterval.get();
    }

    public int getLightUpdateDistanceSqr() {
        return 4;
    }

    private boolean initialized() {
        return !this.getLightPos().equals((Object)BlockPos.f_121853_);
    }

    public Player getEntity() {
        return this.player;
    }
}

