/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.barrels_2012.common;

import com.eerussianguy.barrels_2012.BarrelConfig;
import com.eerussianguy.barrels_2012.Barrels2012;
import com.eerussianguy.barrels_2012.common.PlayerGlow;
import com.eerussianguy.barrels_2012.common.PlayerGlowCapability;
import net.dries007.tfc.common.blocks.devices.PowderkegBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import top.theillusivec4.curios.api.SlotResult;

public class ForgeEvents {
    public static void init() {
        IEventBus bus = MinecraftForge.EVENT_BUS;
        bus.addGenericListener(Entity.class, ForgeEvents::onEntityCaps);
        bus.addListener(ForgeEvents::onPlayerLoggedIn);
        bus.addListener(ForgeEvents::onPlayerLoggedOut);
        bus.addListener(ForgeEvents::onPlayerTick);
        bus.addListener(ForgeEvents::onPlayerChangeDimension);
    }

    public static void onEntityCaps(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof Player) {
            Player player = (Player)object;
            event.addCapability(PlayerGlowCapability.KEY, (ICapabilityProvider)new PlayerGlow(player));
        }
    }

    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        ItemStack stack;
        SlotResult curio;
        Player player = event.player;
        Level level = player.m_9236_();
        if (event.phase == TickEvent.Phase.START && !level.f_46443_) {
            player.getCapability(PlayerGlowCapability.CAPABILITY).ifPresent(PlayerGlow::tickGlow);
        }
        if (!level.f_46443_ && ((Boolean)BarrelConfig.SERVER.enablePowderkegExplosions.get()).booleanValue() && level.m_46467_() % 40L == 0L && player.m_6060_() && (curio = Barrels2012.getCurio((LivingEntity)player, is -> {
            BlockItem bi;
            Item patt2241$temp = is.m_41720_();
            return patt2241$temp instanceof BlockItem && (bi = (BlockItem)patt2241$temp).m_40614_() instanceof PowderkegBlock;
        })) != null && Barrels2012.isSealed(stack = curio.stack())) {
            float size = ForgeEvents.getExplosionSize(stack);
            curio.stack().m_41774_(1);
            level.m_254849_(null, player.m_20185_(), player.m_20227_(0.0625), player.m_20189_(), size, Level.ExplosionInteraction.BLOCK);
        }
    }

    private static float getExplosionSize(ItemStack stack) {
        float str = 0.0f;
        CompoundTag tag = stack.m_41737_("BlockEntityTag");
        if (tag != null) {
            CompoundTag inventoryTag = tag.m_128469_("inventory");
            ItemStackHandler inventory = new ItemStackHandler();
            inventory.deserializeNBT(inventoryTag.m_128469_("inventory"));
            if (!Helpers.isEmpty((IItemHandler)inventory)) {
                for (int i = 0; i < inventory.getSlots(); ++i) {
                    str += (float)inventory.getStackInSlot(i).m_41613_();
                }
                str /= 12.0f;
            }
        }
        return str;
    }

    public static void onPlayerLoggedOut(EntityLeaveLevelEvent event) {
        Entity entity = event.getEntity();
        if (!entity.m_9236_().f_46443_ && entity instanceof Player) {
            Player player = (Player)entity;
            PlayerGlow.reset(player);
        }
    }

    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!player.m_9236_().f_46443_) {
            PlayerGlow.reset(player);
        }
    }

    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        player.getCapability(PlayerGlowCapability.CAPABILITY).ifPresent(cap -> {
            if (player.m_9236_().isAreaLoaded(cap.getLightPos(), 2)) {
                cap.tryRemoveLight();
            }
        });
    }
}

