/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.barrels_2012.client;

import com.eerussianguy.barrels_2012.Barrels2012;
import com.eerussianguy.barrels_2012.client.AnvilCurioRenderer;
import com.eerussianguy.barrels_2012.client.BarrelCurioRenderer;
import com.eerussianguy.barrels_2012.client.BodyCurioModel;
import com.eerussianguy.barrels_2012.client.CrucibleCurioRenderer;
import com.eerussianguy.barrels_2012.client.LampCurioRenderer;
import com.eerussianguy.barrels_2012.client.LargeVesselCurioRenderer;
import com.eerussianguy.barrels_2012.client.PowderkegCurioRenderer;
import java.util.function.Supplier;
import net.dries007.tfc.common.blocks.LargeVesselBlock;
import net.dries007.tfc.common.blocks.devices.AnvilBlock;
import net.dries007.tfc.common.blocks.devices.BarrelBlock;
import net.dries007.tfc.common.blocks.devices.CrucibleBlock;
import net.dries007.tfc.common.blocks.devices.LampBlock;
import net.dries007.tfc.common.blocks.devices.PowderkegBlock;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public class ClientEvents {
    public static void init(IEventBus bus) {
        bus.addListener(ClientEvents::setup);
        bus.addListener(ClientEvents::registerLayers);
    }

    private static void setup(FMLClientSetupEvent event) {
        for (Block block : ForgeRegistries.BLOCKS.getValues()) {
            if (block instanceof BarrelBlock) {
                ClientEvents.regCurio(block, BarrelCurioRenderer::new);
                continue;
            }
            if (block instanceof LargeVesselBlock) {
                ClientEvents.regCurio(block, LargeVesselCurioRenderer::new);
                continue;
            }
            if (block instanceof LampBlock) {
                ClientEvents.regCurio(block, LampCurioRenderer::new);
                continue;
            }
            if (block instanceof AnvilBlock) {
                ClientEvents.regCurio(block, AnvilCurioRenderer::new);
                continue;
            }
            if (block instanceof PowderkegBlock) {
                ClientEvents.regCurio(block, PowderkegCurioRenderer::new);
                continue;
            }
            if (!(block instanceof CrucibleBlock)) continue;
            ClientEvents.regCurio(block, CrucibleCurioRenderer::new);
        }
    }

    private static void regCurio(Block block, Supplier<ICurioRenderer> rendererSupplier) {
        ClientEvents.regCurio(block.m_5456_(), rendererSupplier);
    }

    private static void regCurio(Item item, Supplier<ICurioRenderer> rendererSupplier) {
        CuriosRendererRegistry.register((Item)item, rendererSupplier);
    }

    private static void regCurio(Supplier<Block> supplier, Supplier<ICurioRenderer> rendererSupplier) {
        CuriosRendererRegistry.register((Item)supplier.get().m_5456_(), rendererSupplier);
    }

    private static void registerLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        ClientEvents.bodyLayer(event, "barrel", "body", PartPose.m_171419_((float)-8.0f, (float)0.0f, (float)0.0f));
        ClientEvents.bodyLayer(event, "powderkeg", "body", PartPose.m_171419_((float)-8.0f, (float)0.0f, (float)2.0f));
        ClientEvents.bodyLayer(event, "vessel", "body", PartPose.m_171419_((float)-8.0f, (float)-5.0f, (float)0.0f));
        ClientEvents.bodyLayer(event, "anvil", "body", PartPose.m_171419_((float)-8.0f, (float)-4.0f, (float)2.0f));
        ClientEvents.bodyLayer(event, "lamp", "body", PartPose.m_171419_((float)-8.0f, (float)-8.0f, (float)-3.0f));
        ClientEvents.bodyLayer(event, "crucible", "body", PartPose.m_171419_((float)-8.0f, (float)0.0f, (float)2.0f));
    }

    private static void bodyLayer(EntityRenderersEvent.RegisterLayerDefinitions event, String name, String parent, PartPose pose) {
        event.registerLayerDefinition(Barrels2012.modelLayer(name), () -> BodyCurioModel.create(parent, pose));
    }
}

