/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.barrels_2012.client;

import com.eerussianguy.barrels_2012.Barrels2012;
import com.eerussianguy.barrels_2012.client.BodyCurioModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public abstract class BlockItemCurioRenderer
implements ICurioRenderer {
    private final BodyCurioModel<LivingEntity> model;

    public static ModelPart bake(String name) {
        return Minecraft.m_91087_().m_167973_().m_171103_(Barrels2012.modelLayer(name));
    }

    public static Optional<SlotResult> getCurio(LivingEntity entity, Class<?> blockClass) {
        return Optional.ofNullable(Barrels2012.getCurio(entity, (ItemStack st) -> {
            BlockItem bi;
            Item patt1583$temp = st.m_41720_();
            return patt1583$temp instanceof BlockItem && blockClass.isInstance((bi = (BlockItem)patt1583$temp).m_40614_());
        }));
    }

    public static BlockState defaultState(ItemStack item) {
        return ((BlockItem)item.m_41720_()).m_40614_().m_49966_();
    }

    public BlockItemCurioRenderer(BodyCurioModel<LivingEntity> model) {
        this.model = model;
    }

    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack poseStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource buffers, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        LivingEntity entity = slotContext.entity();
        BlockState state = this.getBlock(entity, stack);
        if (state != null) {
            poseStack.m_85836_();
            this.model.m_6839_(entity, limbSwing, limbSwingAmount, partialTicks);
            this.model.m_6973_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            ICurioRenderer.followBodyRotations((LivingEntity)entity, (HumanoidModel[])new HumanoidModel[]{this.model});
            this.model.translateToPosition(poseStack);
            ICurioRenderer.translateIfSneaking((PoseStack)poseStack, (LivingEntity)entity);
            ICurioRenderer.rotateIfSneaking((PoseStack)poseStack, (LivingEntity)entity);
            poseStack.m_85836_();
            poseStack.m_252880_(0.5f, 0.5f, 0.5f);
            poseStack.m_252781_(this.rotation());
            poseStack.m_252880_(-0.5f, -0.5f, -0.5f);
            Minecraft.m_91087_().m_91289_().renderSingleBlock(state, poseStack, buffers, this.isFullbright(state) ? 0xF000F0 : light, OverlayTexture.f_118083_, ModelData.EMPTY, RenderType.m_110463_());
            poseStack.m_85849_();
            poseStack.m_85849_();
        }
    }

    public boolean isFullbright(BlockState state) {
        return false;
    }

    @Nullable
    public abstract BlockState getBlock(LivingEntity var1, ItemStack var2);

    public Quaternionf rotation() {
        return Axis.f_252403_.m_252977_(180.0f);
    }
}

