/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.core.scanning;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Ordering;
import hunternif.mc.impl.atlas.core.TileIdMap;
import hunternif.mc.impl.atlas.core.scanning.ITileDetector;
import hunternif.mc.impl.atlas.core.scanning.TileDetectorBase;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;

public class TileDetectorNether
extends TileDetectorBase
implements ITileDetector {
    private static final int airProbeLevel = 50;
    private static final int lavaSeaLevel = 31;
    private static final int priorityLava = 1;

    @Override
    public ResourceLocation getBiomeID(Level world, ChunkAccess chunk) {
        HashMultiset biomeOccurrences = HashMultiset.create((int)world.m_9598_().m_175515_(Registries.f_256952_).m_13562_());
        Registry biomeRegistry = world.m_9598_().m_175515_(Registries.f_256952_);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                Biome biome = (Biome)chunk.m_203495_(x, 31, z).m_203334_();
                Holder.Reference biomeTag = biomeRegistry.m_246971_((ResourceKey)biomeRegistry.m_7854_((Object)biome).orElse(null));
                if (biomeTag.m_203656_(BiomeTags.f_207612_)) {
                    Block seaLevelBlock = chunk.m_8055_(new BlockPos(x, 31, z)).m_60734_();
                    if (seaLevelBlock == Blocks.f_49991_) {
                        TileDetectorNether.updateOccurrencesMap((Multiset<ResourceLocation>)biomeOccurrences, TileIdMap.TILE_LAVA, 1);
                        continue;
                    }
                    BlockState airProbeBlock = chunk.m_8055_(new BlockPos(x, 50, z));
                    if (airProbeBlock.m_60795_()) {
                        TileDetectorNether.updateOccurrencesMap((Multiset<ResourceLocation>)biomeOccurrences, TileIdMap.TILE_LAVA_SHORE, 1);
                        continue;
                    }
                    TileDetectorNether.updateOccurrencesMap((Multiset<ResourceLocation>)biomeOccurrences, TileDetectorNether.getBiomeIdentifier(world, biome), 2);
                    continue;
                }
                TileDetectorNether.updateOccurrencesMap((Multiset<ResourceLocation>)biomeOccurrences, TileDetectorNether.getBiomeIdentifier(world, biome), TileDetectorNether.priorityForBiome((Holder<Biome>)biomeTag));
            }
        }
        if (biomeOccurrences.isEmpty()) {
            return null;
        }
        return (ResourceLocation)((Multiset.Entry)biomeOccurrences.entrySet().stream().max(Ordering.natural().onResultOf(Multiset.Entry::getCount)).orElseThrow()).getElement();
    }

    @Override
    public int getScanRadius() {
        return Math.min(super.getScanRadius(), 6);
    }
}

