/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.client;

import dev.architectury.injectables.annotations.ExpectPlatform;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.client.SubTile;
import hunternif.mc.impl.atlas.client.TextureSet;
import hunternif.mc.impl.atlas.client.TextureSetMap;
import hunternif.mc.impl.atlas.client.forge.TileTextureMapImpl;
import hunternif.mc.impl.atlas.client.texture.ITexture;
import hunternif.mc.impl.atlas.core.scanning.TileHeightType;
import hunternif.mc.impl.atlas.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TileTextureMap {
    private static final TileTextureMap INSTANCE = new TileTextureMap();
    public static final ResourceLocation DEFAULT_TEXTURE = AntiqueAtlasMod.id("plains");
    private final Map<ResourceLocation, TextureSet> textureMap = new HashMap<ResourceLocation, TextureSet>();

    public static TileTextureMap instance() {
        return INSTANCE;
    }

    public void setTexture(ResourceLocation tileId, TextureSet textureSet) {
        if (tileId == null) {
            return;
        }
        if (textureSet == null) {
            if (this.textureMap.remove(tileId) != null) {
                Log.warn("Removing old texture for %d", tileId);
            }
            return;
        }
        this.textureMap.put(tileId, textureSet);
    }

    public void setAllTextures(ResourceLocation tileId, TextureSet textureSet) {
        this.setTexture(tileId, textureSet);
        for (TileHeightType layer : TileHeightType.values()) {
            this.setTexture(ResourceLocation.m_135820_((String)(String.valueOf(tileId) + "_" + String.valueOf((Object)layer))), textureSet);
        }
    }

    public TextureSet getDefaultTexture() {
        return TextureSetMap.instance().getByName(DEFAULT_TEXTURE);
    }

    public void autoRegister(ResourceLocation id, ResourceKey<Biome> biome) {
        if (biome == null || id == null) {
            Log.error("Given biome is null. Cannot autodetect a suitable texture set for that.", new Object[0]);
            return;
        }
        Optional<ResourceLocation> texture_set = TileTextureMap.guessFittingTextureSet(biome);
        if (texture_set.isPresent()) {
            this.setAllTextures(id, TextureSetMap.instance().getByName(texture_set.get()));
            Log.info("Auto-registered standard texture set for biome %s: %s", id, texture_set.get());
        } else {
            Log.error("Failed to auto-register a standard texture set for the biome '%s'. Applying default texture. This is most likely caused by errors in the TextureSet configurations, check your resource packs first before reporting it as an issue!", biome.m_135782_().toString());
            this.setAllTextures(id, this.getDefaultTexture());
        }
    }

    private static Optional<ResourceLocation> guessFittingTextureSet(ResourceKey<Biome> biome) {
        if (Minecraft.m_91087_().f_91073_ == null) {
            return Optional.empty();
        }
        String biomeTag = Minecraft.m_91087_().f_91073_.m_9598_().m_175515_(Registries.f_256952_).m_246971_(biome).toString();
        String biomePath = biome.m_135782_().m_135815_();
        if (biomePath.equals("ocean")) {
            return Optional.of(AntiqueAtlasMod.id("water"));
        }
        if (biomePath.equals("ocean_reef")) {
            return Optional.of(AntiqueAtlasMod.id("rock_shore"));
        }
        if (biomePath.equals("deep_ocean")) {
            return Optional.of(AntiqueAtlasMod.id("water"));
        }
        if (biomePath.equals("deep_ocean_trench")) {
            return Optional.of(AntiqueAtlasMod.id("water"));
        }
        if (biomePath.equals("plains")) {
            return Optional.of(AntiqueAtlasMod.id("plains"));
        }
        if (biomePath.equals("hills")) {
            return Optional.of(AntiqueAtlasMod.id("birch"));
        }
        if (biomePath.equals("lowlands")) {
            return Optional.of(AntiqueAtlasMod.id("swamp"));
        }
        if (biomePath.equals("salt_marsh")) {
            return Optional.of(AntiqueAtlasMod.id("swamp_hills"));
        }
        if (biomePath.equals("low_canyons")) {
            return Optional.of(AntiqueAtlasMod.id("plains"));
        }
        if (biomePath.equals("rolling_hills")) {
            return Optional.of(AntiqueAtlasMod.id("birch_hills"));
        }
        if (biomePath.equals("highlands")) {
            return Optional.of(AntiqueAtlasMod.id("hills"));
        }
        if (biomePath.equals("badlands")) {
            return Optional.of(AntiqueAtlasMod.id("plains"));
        }
        if (biomePath.equals("inverted_badlands")) {
            return Optional.of(AntiqueAtlasMod.id("plains"));
        }
        if (biomePath.equals("plateau")) {
            return Optional.of(AntiqueAtlasMod.id("birch_hills"));
        }
        if (biomePath.equals("canyons")) {
            return Optional.of(AntiqueAtlasMod.id("hills"));
        }
        if (biomePath.equals("mountains")) {
            return Optional.of(AntiqueAtlasMod.id("mountains_all"));
        }
        if (biomePath.equals("old_mountains")) {
            return Optional.of(AntiqueAtlasMod.id("mountains_naked"));
        }
        if (biomePath.equals("oceanic_mountains")) {
            return Optional.of(AntiqueAtlasMod.id("mountains_all"));
        }
        if (biomePath.equals("volcanic_mountains")) {
            return Optional.of(AntiqueAtlasMod.id("mountains"));
        }
        if (biomePath.equals("volcanic_oceanic_mountains")) {
            return Optional.of(AntiqueAtlasMod.id("mountains"));
        }
        if (biomePath.equals("shore")) {
            return Optional.of(AntiqueAtlasMod.id("shore"));
        }
        if (biomePath.equals("tidal_flats")) {
            return Optional.of(AntiqueAtlasMod.id("shore"));
        }
        return Optional.of(AntiqueAtlasMod.id("water"));
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean biomeIsVoid(Holder<Biome> biomeTag) {
        return TileTextureMapImpl.biomeIsVoid(biomeTag);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean biomeIsEnd(Holder<Biome> biomeTag) {
        return TileTextureMapImpl.biomeIsEnd(biomeTag);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean biomeHasVegetation(Holder<Biome> biomeTag) {
        return TileTextureMapImpl.biomeHasVegetation(biomeTag);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean biomeIsNether(Holder<Biome> biomeTag) {
        return TileTextureMapImpl.biomeIsNether(biomeTag);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean biomeIsSwamp(Holder<Biome> biomeTag) {
        return TileTextureMapImpl.biomeIsSwamp(biomeTag);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean biomeIsWater(Holder<Biome> biomeTag) {
        return TileTextureMapImpl.biomeIsWater(biomeTag);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean biomeIsIcy(Holder<Biome> biomeTag) {
        return TileTextureMapImpl.biomeIsIcy(biomeTag);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean biomeIsShore(Holder<Biome> biomeTag) {
        return TileTextureMapImpl.biomeIsShore(biomeTag);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean biomeIsJungle(Holder<Biome> biomeTag) {
        return TileTextureMapImpl.biomeIsJungle(biomeTag);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean biomeIsSavanna(Holder<Biome> biomeTag) {
        return TileTextureMapImpl.biomeIsSavanna(biomeTag);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean biomeIsPlateau(Holder<Biome> biomeTag) {
        return TileTextureMapImpl.biomeIsPlateau(biomeTag);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean biomeIsBadlands(Holder<Biome> biomeTag) {
        return TileTextureMapImpl.biomeIsBadlands(biomeTag);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean biomeIsForest(Holder<Biome> biomeTag) {
        return TileTextureMapImpl.biomeIsForest(biomeTag);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean biomeIsSnowy(Holder<Biome> biomeTag) {
        return TileTextureMapImpl.biomeIsSnowy(biomeTag);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean biomeIsPlains(Holder<Biome> biomeTag) {
        return TileTextureMapImpl.biomeIsPlains(biomeTag);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean biomeIsDesert(Holder<Biome> biomeTag) {
        return TileTextureMapImpl.biomeIsDesert(biomeTag);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean biomeIsTaiga(Holder<Biome> biomeTag) {
        return TileTextureMapImpl.biomeIsTaiga(biomeTag);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean biomeIsExtremeHills(Holder<Biome> biomeTag) {
        return TileTextureMapImpl.biomeIsExtremeHills(biomeTag);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean biomeIsPeak(Holder<Biome> biomeTag) {
        return TileTextureMapImpl.biomeIsPeak(biomeTag);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean biomeIsMountain(Holder<Biome> biomeTag) {
        return TileTextureMapImpl.biomeIsMountain(biomeTag);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean biomeIsMushroom(Holder<Biome> biomeTag) {
        return TileTextureMapImpl.biomeIsMushroom(biomeTag);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean biomeIsUnderground(Holder<Biome> biomeTag) {
        return TileTextureMapImpl.biomeIsUnderground(biomeTag);
    }

    public boolean isRegistered(ResourceLocation id) {
        return this.textureMap.containsKey(id);
    }

    public TextureSet getTextureSet(ResourceLocation tile) {
        if (tile == null) {
            return this.getDefaultTexture();
        }
        return this.textureMap.getOrDefault(tile, this.getDefaultTexture());
    }

    public ITexture getTexture(SubTile subTile) {
        return this.getTextureSet(subTile.tile).getTexture(subTile.variationNumber);
    }

    public List<ResourceLocation> getAllTextures() {
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        for (Map.Entry<ResourceLocation, TextureSet> entry : this.textureMap.entrySet()) {
            Arrays.stream(entry.getValue().textures).forEach(iTexture -> list.add(iTexture.getTexture()));
        }
        return list;
    }
}

