/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.network;

import com.alekiponi.alekiships.common.entity.vehicle.SloopEntity;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundSloopPacket {
    private final float sheetLength;
    private final float boomRotation;
    private final float rudderAngle;
    private final int entityID;

    public ServerBoundSloopPacket(float sheetLength, float boomRotation, float rudderAngle, int entityID) {
        this.sheetLength = sheetLength;
        this.boomRotation = boomRotation;
        this.rudderAngle = rudderAngle;
        this.entityID = entityID;
    }

    public ServerBoundSloopPacket(FriendlyByteBuf buffer) {
        this.sheetLength = buffer.readFloat();
        this.boomRotation = buffer.readFloat();
        this.rudderAngle = buffer.readFloat();
        this.entityID = buffer.readInt();
    }

    public void encoder(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.sheetLength);
        buffer.writeFloat(this.boomRotation);
        buffer.writeFloat(this.rudderAngle);
        buffer.writeInt(this.entityID);
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            Entity entity = ((NetworkEvent.Context)context.get()).getSender().m_9236_().m_6815_(this.entityID);
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            if (entity instanceof SloopEntity) {
                SloopEntity sloop = (SloopEntity)entity;
                assert (player != null);
                if (player.m_20270_((Entity)sloop) < 5.0f) {
                    sloop.setMainsheetLength(this.sheetLength);
                    sloop.setMainBoomRotation(this.boomRotation);
                    sloop.setRudderRotation(this.rudderAngle);
                }
            }
        });
    }
}

