/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.network;

import com.alekiponi.alekiships.common.entity.vehicle.AbstractVehicle;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundFlagVehicleForUpdatePacket {
    private final boolean flag;
    private final int entityID;

    public ServerBoundFlagVehicleForUpdatePacket(boolean flag, int entityID) {
        this.flag = flag;
        this.entityID = entityID;
    }

    public ServerBoundFlagVehicleForUpdatePacket(FriendlyByteBuf buffer) {
        this.flag = buffer.readBoolean();
        this.entityID = buffer.readInt();
    }

    public void encoder(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.flag);
        buffer.writeInt(this.entityID);
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            Entity entity = ((NetworkEvent.Context)context.get()).getSender().m_9236_().m_6815_(this.entityID);
            if (entity instanceof AbstractVehicle) {
                ((AbstractVehicle)entity).setFlaggedForPassengerUpdate(this.flag);
            }
        });
    }
}

