/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.data.providers.models;

import com.alekiponi.alekiships.common.block.AlekiShipsBlocks;
import com.alekiponi.alekiships.common.block.AngledBoatFrameBlock;
import com.alekiponi.alekiships.common.block.AngledWoodenBoatFrameBlock;
import com.alekiponi.alekiships.common.block.CleatBlock;
import com.alekiponi.alekiships.common.block.FlatWoodenBoatFrameBlock;
import com.alekiponi.alekiships.common.block.OarlockBlock;
import com.alekiponi.alekiships.util.BoatMaterial;
import com.alekiponi.alekiships.util.VanillaWood;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;

public class AlekiShipsBlockStateProvider
extends BlockStateProvider {
    private static final String[] PROGRESS_STRINGS = new String[]{"first", "second", "third", "fourth"};

    public AlekiShipsBlockStateProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "alekiships", existingFileHelper);
    }

    public static Function<BlockState, ConfiguredModel[]> angledBoatFrame(ModelFile straight, ModelFile inner, ModelFile outer) {
        return blockState -> {
            StairsShape shape = (StairsShape)blockState.m_61143_((Property)StairBlock.f_56843_);
            int yRot = AlekiShipsBlockStateProvider.angledBoatFrameYRot(shape, (Direction)blockState.m_61143_((Property)StairBlock.f_56841_));
            return ConfiguredModel.builder().modelFile(shape == StairsShape.STRAIGHT ? straight : (shape == StairsShape.INNER_LEFT || shape == StairsShape.INNER_RIGHT ? inner : outer)).rotationY(yRot).build();
        };
    }

    public static BiConsumer<BoatMaterial, Supplier<? extends Block>> woodenBoatFrameFlat(BlockStateProvider blockStateProvider, ModelFile.ExistingModelFile frameFlat) {
        return (wood, registryObject) -> {
            ResourceLocation plankTexture = blockStateProvider.blockTexture(wood.getDeckBlock().m_60734_());
            MultiPartBlockStateBuilder multipartBuilder = ((MultiPartBlockStateBuilder.PartBuilder)blockStateProvider.getMultipartBuilder((Block)registryObject.get()).part().modelFile((ModelFile)frameFlat).addModel()).end();
            IntStream.range(0, 4).forEach(progress -> {
                BlockModelBuilder plankModel = (BlockModelBuilder)((BlockModelBuilder)blockStateProvider.models().withExistingParent(String.format(Locale.ROOT, "block/wood/watercraft_frame/flat/%s/%s", wood.m_7912_(), PROGRESS_STRINGS[progress]), new ResourceLocation("alekiships", String.format(Locale.ROOT, "block/watercraft_frame/flat/template/%s", PROGRESS_STRINGS[progress])))).texture("plank", plankTexture);
                ((MultiPartBlockStateBuilder.PartBuilder)multipartBuilder.part().modelFile((ModelFile)plankModel).addModel()).condition((Property)FlatWoodenBoatFrameBlock.FRAME_PROCESSED, (Comparable[])((Integer[])IntStream.range(progress, 4).boxed().toArray(Integer[]::new)));
            });
        };
    }

    public static BiConsumer<VanillaWood, Supplier<? extends Block>> woodenBoatFrameAngled(BlockStateProvider blockStateProvider, ModelFile.ExistingModelFile straight, ModelFile.ExistingModelFile inner, ModelFile.ExistingModelFile outer) {
        return (wood, registryObject) -> {
            ResourceLocation plankTexture = blockStateProvider.blockTexture(wood.getDeckBlock().m_60734_());
            AngledWoodenBoatFrameBlock.FACING.m_6908_().forEach(arg_0 -> AlekiShipsBlockStateProvider.lambda$woodenBoatFrameAngled$7(blockStateProvider, (Supplier)registryObject, straight, inner, outer, wood, plankTexture, arg_0));
        };
    }

    public static int angledBoatFrameYRot(StairsShape shape, Direction facing) {
        return (switch (shape) {
            default -> throw new IncompatibleClassChangeError();
            case StairsShape.INNER_RIGHT, StairsShape.STRAIGHT -> (int)facing.m_122435_();
            case StairsShape.OUTER_LEFT -> (int)facing.m_122435_() + 90;
            case StairsShape.OUTER_RIGHT -> (int)facing.m_122435_() + 180;
            case StairsShape.INNER_LEFT -> (int)facing.m_122435_() + 270;
        }) % 360;
    }

    protected void registerStatesAndModels() {
        ModelFile.ExistingModelFile frameFlat = this.models().getExistingFile(this.modLoc("block/watercraft_frame/flat/frame"));
        AlekiShipsBlocks.WOODEN_BOAT_FRAME_FLAT.forEach(AlekiShipsBlockStateProvider.woodenBoatFrameFlat(this, frameFlat));
        ModelFile.ExistingModelFile angledFrameStraight = this.models().getExistingFile(this.modLoc("block/watercraft_frame/angled/straight"));
        ModelFile.ExistingModelFile angledFrameInner = this.models().getExistingFile(this.modLoc("block/watercraft_frame/angled/inner"));
        ModelFile.ExistingModelFile angledFrameOuter = this.models().getExistingFile(this.modLoc("block/watercraft_frame/angled/outer"));
        AlekiShipsBlocks.WOODEN_BOAT_FRAME_ANGLED.forEach(AlekiShipsBlockStateProvider.woodenBoatFrameAngled(this, angledFrameStraight, angledFrameInner, angledFrameOuter));
        this.angledBoatFrame((Block)AlekiShipsBlocks.BOAT_FRAME_ANGLED.get(), angledFrameStraight, angledFrameInner, angledFrameOuter);
        this.simpleBlockItem((Block)AlekiShipsBlocks.BOAT_FRAME_ANGLED.get(), (ModelFile)angledFrameStraight);
        this.simpleBlockWithItem((Block)AlekiShipsBlocks.BOAT_FRAME_FLAT.get(), (ModelFile)frameFlat);
        this.horizontalBlock((Block)AlekiShipsBlocks.OARLOCK.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/oarlock")), 180, new Property[]{OarlockBlock.WATERLOGGED});
        this.itemModels().basicItem(((OarlockBlock)((Object)AlekiShipsBlocks.OARLOCK.get())).m_5456_());
        this.horizontalBlock((Block)AlekiShipsBlocks.CLEAT.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/cleat")), 180, new Property[]{CleatBlock.WATERLOGGED});
        this.itemModels().basicItem(((CleatBlock)((Object)AlekiShipsBlocks.CLEAT.get())).m_5456_());
    }

    public void angledBoatFrame(Block block, ModelFile.ExistingModelFile straight, ModelFile.ExistingModelFile inner, ModelFile.ExistingModelFile outer) {
        this.getVariantBuilder(block).forAllStatesExcept(AlekiShipsBlockStateProvider.angledBoatFrame((ModelFile)straight, (ModelFile)inner, (ModelFile)outer), new Property[]{AngledBoatFrameBlock.WATERLOGGED});
    }

    public void horizontalBlock(Block block, ModelFile model, int angleOffset, Property<?> ... ignoredProperties) {
        this.horizontalBlock(block, (BlockState $) -> model, angleOffset, ignoredProperties);
    }

    public void horizontalBlock(Block block, Function<BlockState, ModelFile> modelFunc, int angleOffset, Property<?> ... ignoredProperties) {
        this.getVariantBuilder(block).forAllStatesExcept(blockState -> {
            int yRot = ((int)((Direction)blockState.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + angleOffset) % 360;
            return ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)blockState)).rotationY(yRot).uvLock(yRot != 0).build();
        }, ignoredProperties);
    }

    private static /* synthetic */ void lambda$woodenBoatFrameAngled$7(BlockStateProvider blockStateProvider, Supplier registryObject, ModelFile.ExistingModelFile straight, ModelFile.ExistingModelFile inner, ModelFile.ExistingModelFile outer, VanillaWood wood, ResourceLocation plankTexture, Direction facing) {
        AngledWoodenBoatFrameBlock.SHAPE.m_6908_().forEach(arg_0 -> AlekiShipsBlockStateProvider.lambda$woodenBoatFrameAngled$6(blockStateProvider, (Supplier)registryObject, facing, straight, inner, outer, wood, plankTexture, arg_0));
    }

    private static /* synthetic */ void lambda$woodenBoatFrameAngled$6(BlockStateProvider blockStateProvider, Supplier registryObject, Direction facing, ModelFile.ExistingModelFile straight, ModelFile.ExistingModelFile inner, ModelFile.ExistingModelFile outer, VanillaWood wood, ResourceLocation plankTexture, StairsShape shape) {
        MultiPartBlockStateBuilder multipartBuilder = blockStateProvider.getMultipartBuilder((Block)registryObject.get());
        int yRot = AlekiShipsBlockStateProvider.angledBoatFrameYRot(shape, facing);
        ((MultiPartBlockStateBuilder.PartBuilder)multipartBuilder.part().modelFile((ModelFile)(shape == StairsShape.STRAIGHT ? straight : (shape == StairsShape.INNER_LEFT || shape == StairsShape.INNER_RIGHT ? inner : outer))).rotationY(yRot).addModel()).condition((Property)AngledWoodenBoatFrameBlock.FACING, (Comparable[])new Direction[]{facing}).condition((Property)AngledWoodenBoatFrameBlock.SHAPE, (Comparable[])new StairsShape[]{shape});
        IntStream.range(0, 4).forEach(progress -> {
            String modelShape = shape == StairsShape.STRAIGHT ? "straight" : (shape == StairsShape.INNER_LEFT || shape == StairsShape.INNER_RIGHT ? "inner" : "outer");
            BlockModelBuilder plankModel = (BlockModelBuilder)((BlockModelBuilder)blockStateProvider.models().withExistingParent(String.format(Locale.ROOT, "block/wood/watercraft_frame/angled/%s/%s/%s", wood.m_7912_(), modelShape, PROGRESS_STRINGS[progress]), new ResourceLocation("alekiships", String.format(Locale.ROOT, "block/watercraft_frame/angled/template/%s/%s", modelShape, PROGRESS_STRINGS[progress])))).texture("plank", plankTexture);
            ((MultiPartBlockStateBuilder.PartBuilder)multipartBuilder.part().modelFile((ModelFile)plankModel).rotationY(yRot).uvLock(yRot != 0).addModel()).condition((Property)AngledWoodenBoatFrameBlock.FACING, (Comparable[])new Direction[]{facing}).condition((Property)AngledWoodenBoatFrameBlock.SHAPE, (Comparable[])new StairsShape[]{shape}).condition((Property)AngledWoodenBoatFrameBlock.FRAME_PROCESSED, (Comparable[])((Integer[])IntStream.range(progress, 4).boxed().toArray(Integer[]::new)));
        });
    }
}

