/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.compat.waila.compartment;

import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.vanilla.AbstractFurnaceCompartmentEntity;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.impl.ui.ProgressArrowElement;

public enum FurnaceCompartmentProvider implements IEntityComponentProvider,
IServerDataProvider<EntityAccessor>
{
    INSTANCE;

    private static final ResourceLocation NAME;

    public void appendTooltip(ITooltip tooltip, EntityAccessor entityAccessor, IPluginConfig iPluginConfig) {
        tooltip.remove(Identifiers.UNIVERSAL_ITEM_STORAGE);
        CompoundTag serverData = entityAccessor.getServerData();
        int progress = serverData.m_128451_("progress");
        if (progress == 0) {
            return;
        }
        ListTag furnaceItems = serverData.m_128437_("furnace", 10);
        NonNullList inventory = NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_);
        for (int slotIndex = 0; slotIndex < furnaceItems.size(); ++slotIndex) {
            inventory.set(slotIndex, (Object)ItemStack.m_41712_((CompoundTag)furnaceItems.m_128728_(slotIndex)));
        }
        IElementHelper helper = tooltip.getElementHelper();
        tooltip.add(helper.item((ItemStack)inventory.get(0)));
        tooltip.append(helper.item((ItemStack)inventory.get(1)));
        tooltip.append((IElement)new ProgressArrowElement((float)progress / (float)serverData.m_128451_("total")));
        tooltip.append(helper.item((ItemStack)inventory.get(2)));
    }

    public void appendServerData(CompoundTag compoundTag, EntityAccessor entityAccessor) {
        AbstractFurnaceCompartmentEntity furnaceCompartment = (AbstractFurnaceCompartmentEntity)entityAccessor.getEntity();
        ListTag items = new ListTag();
        for (int slotIndex = 0; slotIndex < 3; ++slotIndex) {
            items.add((Object)furnaceCompartment.m_8020_(slotIndex).m_41739_(new CompoundTag()));
        }
        compoundTag.m_128365_("furnace", (Tag)items);
        compoundTag.m_128405_("progress", furnaceCompartment.getCookTime());
        compoundTag.m_128405_("total", furnaceCompartment.getTotalCookTime());
    }

    public ResourceLocation getUid() {
        return NAME;
    }

    public int getDefaultPriority() {
        return 1001;
    }

    static {
        NAME = new ResourceLocation("alekiships", "furnace");
    }
}

