/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.common.entity;

import com.alekiponi.alekiships.common.entity.CannonEntity;
import com.alekiponi.alekiships.common.entity.CannonballEntity;
import com.alekiponi.alekiships.common.entity.vehicle.RowboatEntity;
import com.alekiponi.alekiships.common.entity.vehicle.SloopEntity;
import com.alekiponi.alekiships.common.entity.vehicle.SloopUnderConstructionEntity;
import com.alekiponi.alekiships.common.entity.vehiclehelper.AnchorEntity;
import com.alekiponi.alekiships.common.entity.vehiclehelper.CleatEntity;
import com.alekiponi.alekiships.common.entity.vehiclehelper.ColliderEntity;
import com.alekiponi.alekiships.common.entity.vehiclehelper.CompartmentType;
import com.alekiponi.alekiships.common.entity.vehiclehelper.ConstructionEntity;
import com.alekiponi.alekiships.common.entity.vehiclehelper.MastEntity;
import com.alekiponi.alekiships.common.entity.vehiclehelper.SailSwitchEntity;
import com.alekiponi.alekiships.common.entity.vehiclehelper.VehiclePart;
import com.alekiponi.alekiships.common.entity.vehiclehelper.WindlassSwitchEntity;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.AbstractCompartmentEntity;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.BlockCompartmentEntity;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.EmptyCompartmentEntity;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.vanilla.BarrelCompartmentEntity;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.vanilla.BlastFurnaceCompartmentEntity;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.vanilla.BrewingStandCompartmentEntity;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.vanilla.ChestCompartmentEntity;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.vanilla.EnderChestCompartmentEntity;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.vanilla.FurnaceCompartmentEntity;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.vanilla.JukeboxCompartmentEntity;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.vanilla.NoteBlockCompartmentEntity;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.vanilla.ShulkerBoxCompartmentEntity;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.vanilla.SmokerCompartmentEntity;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.vanilla.crafting.CartographyTableCompartmentEntity;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.vanilla.crafting.CraftingTableCompartment;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.vanilla.crafting.GrindstoneCompartmentEntity;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.vanilla.crafting.LoomCompartmentEntity;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.vanilla.crafting.SmithingTableCompartmentEntity;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.vanilla.crafting.StonecutterCompartmentEntity;
import com.alekiponi.alekiships.util.AlekiShipsTags;
import com.alekiponi.alekiships.util.BoatMaterial;
import com.alekiponi.alekiships.util.CommonHelper;
import com.alekiponi.alekiships.util.VanillaWood;
import java.util.EnumMap;
import java.util.Locale;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public final class AlekiShipsEntities {
    public static final int LARGE_VEHICLE_TRACKING = 20;
    public static final int VEHICLE_HELPER_TRACKING = 21;
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"alekiships");
    public static final EnumMap<VanillaWood, RegistryObject<EntityType<RowboatEntity>>> ROWBOATS = CommonHelper.mapOfKeys(VanillaWood.class, vanillaWood -> AlekiShipsEntities.registerRowboat(vanillaWood, EntityType.Builder.m_20704_((entityType, level) -> new RowboatEntity((EntityType<? extends RowboatEntity>)entityType, level, (BoatMaterial)vanillaWood), (MobCategory)MobCategory.MISC)));
    public static final EnumMap<VanillaWood, RegistryObject<EntityType<SloopEntity>>> SLOOPS = CommonHelper.mapOfKeys(VanillaWood.class, vanillaWood -> AlekiShipsEntities.registerSloop(vanillaWood, EntityType.Builder.m_20704_((entityType, level) -> new SloopEntity((EntityType<? extends SloopEntity>)entityType, level, (BoatMaterial)vanillaWood), (MobCategory)MobCategory.MISC)));
    public static final EnumMap<VanillaWood, RegistryObject<EntityType<SloopUnderConstructionEntity>>> SLOOPS_UNDER_CONSTRUCTION = CommonHelper.mapOfKeys(VanillaWood.class, vanillaWood -> AlekiShipsEntities.registerSloopConstruction(vanillaWood, EntityType.Builder.m_20704_((entityType, level) -> new SloopUnderConstructionEntity((EntityType<? extends SloopUnderConstructionEntity>)entityType, level, (BoatMaterial)vanillaWood), (MobCategory)MobCategory.MISC)));
    public static final RegistryObject<CompartmentType<EmptyCompartmentEntity>> EMPTY_COMPARTMENT_ENTITY = AlekiShipsEntities.registerCompartment("compartment_empty", CompartmentType.Builder.createBasic(EmptyCompartmentEntity::new));
    public static final RegistryObject<CompartmentType<BlockCompartmentEntity>> BLOCK_COMPARTMENT_ENTITY = AlekiShipsEntities.registerCompartment("compartment_block", CompartmentType.Builder.of(BlockCompartmentEntity::new, BlockCompartmentEntity::new));
    public static final RegistryObject<CompartmentType<BarrelCompartmentEntity>> BARREL_COMPARTMENT_ENTITY = CompartmentType.register(AlekiShipsEntities.registerCompartment("compartment_barrel", CompartmentType.Builder.of(BarrelCompartmentEntity::new, BarrelCompartmentEntity::new)), (ItemStack itemStack) -> itemStack.m_150930_(Items.f_42768_));
    public static final RegistryObject<CompartmentType<ChestCompartmentEntity>> CHEST_COMPARTMENT_ENTITY = CompartmentType.register(AlekiShipsEntities.registerCompartment("compartment_chest", CompartmentType.Builder.of(ChestCompartmentEntity::new, ChestCompartmentEntity::new)), (ItemStack itemStack) -> itemStack.m_150930_(Items.f_42009_));
    public static final RegistryObject<CompartmentType<EnderChestCompartmentEntity>> ENDER_CHEST_COMPARTMENT_ENTITY = CompartmentType.register(AlekiShipsEntities.registerCompartment("compartment_ender_chest", CompartmentType.Builder.createBasic(EnderChestCompartmentEntity::new)), (ItemStack itemStack) -> itemStack.m_150930_(Items.f_42108_));
    public static final RegistryObject<CompartmentType<ShulkerBoxCompartmentEntity>> SHULKER_BOX_COMPARTMENT_ENTITY = CompartmentType.register(AlekiShipsEntities.registerCompartment("compartment_shulker_box", CompartmentType.Builder.of(ShulkerBoxCompartmentEntity::new, ShulkerBoxCompartmentEntity::new)), (ItemStack itemStack) -> itemStack.m_204117_(AlekiShipsTags.Items.SHULKER_BOXES));
    public static final RegistryObject<CompartmentType<FurnaceCompartmentEntity>> FURNACE_COMPARTMENT_ENTITY = CompartmentType.register(AlekiShipsEntities.registerCompartment("compartment_furnace", CompartmentType.Builder.of(FurnaceCompartmentEntity::new, FurnaceCompartmentEntity::new)), (ItemStack itemStack) -> itemStack.m_150930_(Items.f_41962_));
    public static final RegistryObject<CompartmentType<BlastFurnaceCompartmentEntity>> BLAST_FURNACE_COMPARTMENT_ENTITY = CompartmentType.register(AlekiShipsEntities.registerCompartment("compartment_blast_furnace", CompartmentType.Builder.of(BlastFurnaceCompartmentEntity::new, BlastFurnaceCompartmentEntity::new)), (ItemStack itemStack) -> itemStack.m_150930_(Items.f_42770_));
    public static final RegistryObject<CompartmentType<SmokerCompartmentEntity>> SMOKER_COMPARTMENT_ENTITY = CompartmentType.register(AlekiShipsEntities.registerCompartment("compartment_smoker", CompartmentType.Builder.of(SmokerCompartmentEntity::new, SmokerCompartmentEntity::new)), (ItemStack itemStack) -> itemStack.m_150930_(Items.f_42769_));
    public static final RegistryObject<CompartmentType<BrewingStandCompartmentEntity>> BREWING_STAND_COMPARTMENT_ENTITY = CompartmentType.register(AlekiShipsEntities.registerCompartment("compartment_brewing_stand", CompartmentType.Builder.of(BrewingStandCompartmentEntity::new, BrewingStandCompartmentEntity::new)), (ItemStack itemStack) -> itemStack.m_150930_(Items.f_42543_));
    public static final RegistryObject<CompartmentType<CraftingTableCompartment>> WORKBENCH_COMPARTMENT_ENTITY = CompartmentType.register(AlekiShipsEntities.registerCompartment("compartment_crafting_table", CompartmentType.Builder.of(CraftingTableCompartment::new, CraftingTableCompartment::new)), (ItemStack itemStack) -> itemStack.m_204117_(AlekiShipsTags.Items.CRAFTING_TABLES));
    public static final RegistryObject<CompartmentType<StonecutterCompartmentEntity>> STONECUTTER_COMPARTMENT_ENTITY = CompartmentType.register(AlekiShipsEntities.registerCompartment("compartment_stonecutter", CompartmentType.Builder.of(StonecutterCompartmentEntity::new, StonecutterCompartmentEntity::new)), (ItemStack itemStack) -> itemStack.m_150930_(Items.f_42776_));
    public static final RegistryObject<CompartmentType<CartographyTableCompartmentEntity>> CARTOGRAPHY_TABLE_COMPARTMENT_ENTITY = CompartmentType.register(AlekiShipsEntities.registerCompartment("compartment_cartography_table", CompartmentType.Builder.of(CartographyTableCompartmentEntity::new, CartographyTableCompartmentEntity::new)), (ItemStack itemStack) -> itemStack.m_150930_(Items.f_42771_));
    public static final RegistryObject<CompartmentType<SmithingTableCompartmentEntity>> SMITHING_TABLE_COMPARTMENT_ENTITY = CompartmentType.register(AlekiShipsEntities.registerCompartment("compartment_smithing_table", CompartmentType.Builder.of(SmithingTableCompartmentEntity::new, SmithingTableCompartmentEntity::new)), (ItemStack itemStack) -> itemStack.m_150930_(Items.f_42775_));
    public static final RegistryObject<CompartmentType<GrindstoneCompartmentEntity>> GRINDSTONE_COMPARTMENT_ENTITY = CompartmentType.register(AlekiShipsEntities.registerCompartment("compartment_grindstone", CompartmentType.Builder.of(GrindstoneCompartmentEntity::new, GrindstoneCompartmentEntity::new)), (ItemStack itemStack) -> itemStack.m_150930_(Items.f_42773_));
    public static final RegistryObject<CompartmentType<LoomCompartmentEntity>> LOOM_COMPARTMENT_ENTITY = CompartmentType.register(AlekiShipsEntities.registerCompartment("compartment_loom", CompartmentType.Builder.of(LoomCompartmentEntity::new, LoomCompartmentEntity::new)), (ItemStack itemStack) -> itemStack.m_150930_(Items.f_42719_));
    public static final RegistryObject<CompartmentType<NoteBlockCompartmentEntity>> NOTE_BLOCK_COMPARTMENT_ENTITY = CompartmentType.register(AlekiShipsEntities.registerCompartment("compartment_note_block", CompartmentType.Builder.of(NoteBlockCompartmentEntity::new, NoteBlockCompartmentEntity::new)), (ItemStack itemStack) -> itemStack.m_150930_(Items.f_41859_));
    public static final RegistryObject<CompartmentType<JukeboxCompartmentEntity>> JUKEBOX_COMPARTMENT_ENTITY = CompartmentType.register(AlekiShipsEntities.registerCompartment("compartment_jukebox", CompartmentType.Builder.of(JukeboxCompartmentEntity::new, JukeboxCompartmentEntity::new)), (ItemStack itemStack) -> itemStack.m_150930_(Items.f_41984_));
    public static final RegistryObject<EntityType<VehiclePart>> VEHICLE_PART = AlekiShipsEntities.register("vehicle_part", EntityType.Builder.m_20704_(VehiclePart::new, (MobCategory)MobCategory.MISC).m_20699_(0.0f, 0.0f).setTrackingRange(21).m_20698_().m_20719_());
    public static final RegistryObject<EntityType<CleatEntity>> VEHICLE_CLEAT_ENTITY = AlekiShipsEntities.register("vehicle_cleat", EntityType.Builder.m_20704_(CleatEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.4f, 0.2f).setTrackingRange(21).m_20698_().m_20719_());
    public static final RegistryObject<EntityType<ColliderEntity>> VEHICLE_COLLIDER_ENTITY = AlekiShipsEntities.register("vehicle_collider", EntityType.Builder.m_20704_(ColliderEntity::new, (MobCategory)MobCategory.MISC).m_20699_(1.0f, 1.0f).m_20698_().m_20719_());
    public static final RegistryObject<EntityType<SailSwitchEntity>> SAIL_SWITCH_ENTITY = AlekiShipsEntities.register("vehicle_switch_sail", EntityType.Builder.m_20704_(SailSwitchEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.8f, 0.8f).m_20698_().m_20719_());
    public static final RegistryObject<EntityType<AnchorEntity>> ANCHOR_ENTITY = AlekiShipsEntities.register("vehicle_anchor", EntityType.Builder.m_20704_(AnchorEntity::new, (MobCategory)MobCategory.MISC).m_20699_(1.0f, 1.0f).m_20702_(21).m_20698_().m_20719_());
    public static final RegistryObject<EntityType<ConstructionEntity>> CONSTRUCTION_ENTITY = AlekiShipsEntities.register("vehicle_construction", EntityType.Builder.m_20704_(ConstructionEntity::new, (MobCategory)MobCategory.MISC).m_20699_(1.0f, 1.0f).m_20702_(21).m_20698_().m_20719_());
    public static final RegistryObject<EntityType<WindlassSwitchEntity>> WINDLASS_SWITCH_ENTITY = AlekiShipsEntities.register("vehicle_switch_windlass", EntityType.Builder.m_20704_(WindlassSwitchEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.8f, 0.8f).setTrackingRange(21).m_20698_().m_20719_());
    public static final RegistryObject<EntityType<CannonballEntity>> CANNONBALL_ENTITY = AlekiShipsEntities.register("cannonball", EntityType.Builder.m_20704_(CannonballEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).setTrackingRange(32).m_20702_(32).setShouldReceiveVelocityUpdates(true).m_20719_());
    public static final RegistryObject<EntityType<CannonEntity>> CANNON_ENTITY = AlekiShipsEntities.register("cannon", EntityType.Builder.m_20704_(CannonEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.8f, 0.8f).m_20719_());
    public static final RegistryObject<EntityType<MastEntity>> MAST_ENTITY = AlekiShipsEntities.register("vehicle_mast", EntityType.Builder.m_20704_(MastEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.3f, 8.79375f).setTrackingRange(21).m_20698_().m_20719_());

    private static <E extends RowboatEntity> RegistryObject<EntityType<E>> registerRowboat(VanillaWood vanillaWood, EntityType.Builder<E> builder) {
        return AlekiShipsEntities.register("rowboat/" + vanillaWood.m_7912_(), builder.m_20699_(1.875f, 0.625f));
    }

    private static <E extends SloopEntity> RegistryObject<EntityType<E>> registerSloop(VanillaWood vanillaWood, EntityType.Builder<E> builder) {
        return AlekiShipsEntities.register("sloop/" + vanillaWood.m_7912_(), builder.m_20699_(3.0f, 0.75f).setTrackingRange(20));
    }

    private static <E extends SloopUnderConstructionEntity> RegistryObject<EntityType<E>> registerSloopConstruction(VanillaWood vanillaWood, EntityType.Builder<E> builder) {
        return AlekiShipsEntities.register("sloop_construction/" + vanillaWood.m_7912_(), builder.m_20699_(4.0f, 0.75f).setTrackingRange(20).m_20719_().m_20698_());
    }

    private static <E extends AbstractCompartmentEntity> RegistryObject<CompartmentType<E>> registerCompartment(String name, CompartmentType.Builder<E> builder) {
        return AlekiShipsEntities.register(name, builder.sized(0.6f, 0.7f).fireImmune().noSummon(), true);
    }

    private static <E extends AbstractCompartmentEntity> RegistryObject<CompartmentType<E>> register(String name, CompartmentType.Builder<E> builder, boolean serialize) {
        String id = name.toLowerCase(Locale.ROOT);
        return ENTITY_TYPES.register(id, () -> {
            if (!serialize) {
                builder.noSave();
            }
            return builder.build("alekiships:" + id);
        });
    }

    private static <E extends Entity> RegistryObject<EntityType<E>> register(String name, EntityType.Builder<E> builder) {
        return AlekiShipsEntities.register(name, builder, true);
    }

    private static <E extends Entity> RegistryObject<EntityType<E>> register(String name, EntityType.Builder<E> builder, boolean serialize) {
        String id = name.toLowerCase(Locale.ROOT);
        return ENTITY_TYPES.register(id, () -> {
            if (!serialize) {
                builder.m_20716_();
            }
            return builder.m_20712_("alekiships:" + id);
        });
    }
}

