/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.client.render.util;

import com.alekiponi.alekiships.client.render.util.FrameInfo;
import com.mojang.blaze3d.platform.NativeImage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.util.FastColor;

public final class TextureHelpers {
    private TextureHelpers() {
    }

    public static boolean checkAspectRatio(int bgWidth, int bgHeight, int fgWidth, int fgHeight) {
        int heightFactor;
        int widthFactor = Math.max(bgWidth, fgWidth) / Math.min(bgWidth, fgWidth);
        return widthFactor == (heightFactor = Math.max(bgHeight, fgHeight) / Math.min(bgHeight, fgHeight));
    }

    public static void copyRect(NativeImage sourceImage, NativeImage destinationImage, int sourceX, int sourceY, int destinationX, int destinationY, int width, int height) {
        for (int y = 0; y < width; ++y) {
            for (int x = 0; x < height; ++x) {
                int rgba = sourceImage.m_84985_(sourceX + x, sourceY + y);
                int alpha = FastColor.ARGB32.m_13655_((int)rgba);
                if (alpha == 255) {
                    destinationImage.m_84988_(destinationX + x, destinationY + y, rgba);
                    continue;
                }
                if (alpha <= 0) continue;
                destinationImage.m_166411_(destinationX + x, destinationY + y, rgba);
            }
        }
    }

    public static List<FrameInfo> collectFrames(NativeImage image, FrameSize size) {
        ArrayList<FrameInfo> frames = new ArrayList<FrameInfo>();
        int rowCount = image.m_84982_() / size.f_244129_();
        int frameCount = rowCount * (image.m_85084_() / size.f_244503_());
        for (int idx = 0; idx < frameCount; ++idx) {
            int frameX = idx % rowCount * size.f_244129_();
            int frameY = idx / rowCount * size.f_244503_();
            frames.add(new FrameInfo(idx, frameX, frameY));
        }
        return frames;
    }

    public static NativeImage scaleImage(NativeImage source, int scale) {
        if (scale <= 1) {
            return source;
        }
        NativeImage scaled = new NativeImage(source.m_85102_(), source.m_84982_() * scale, source.m_85084_() * scale, false);
        scaled.m_85034_(0, 0, source.m_84982_(), source.m_85084_(), source);
        source.close();
        return scaled;
    }
}

