/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.client.render.entity.vehicle;

import com.alekiponi.alekiships.client.model.entity.SloopEntityModel;
import com.alekiponi.alekiships.client.render.util.AlekiShipsRenderHelper;
import com.alekiponi.alekiships.common.entity.vehicle.SloopEntity;
import com.alekiponi.alekiships.util.CommonHelper;
import com.alekiponi.alekiships.util.VanillaWood;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.EnumMap;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SloopRenderer
extends EntityRenderer<SloopEntity> {
    public static final ResourceLocation DAMAGE_OVERLAY = new ResourceLocation("alekiships", "textures/entity/watercraft/sloop/damage_overlay.png");
    public static final EnumMap<DyeColor, ResourceLocation> SAIL_TEXTURES = CommonHelper.mapOfKeys(DyeColor.class, dyeColor -> new ResourceLocation("alekiships", "textures/entity/watercraft/sloop/sails/" + dyeColor.m_7912_() + ".png"));
    protected final ResourceLocation sloopTexture;
    protected final EnumMap<DyeColor, ResourceLocation> paintTextures;
    protected final SloopEntityModel sloopModel = new SloopEntityModel();
    private final Font font;

    public SloopRenderer(EntityRendererProvider.Context context, VanillaWood vanillaWood) {
        this(context, new ResourceLocation("alekiships", "textures/entity/watercraft/sloop/" + vanillaWood.m_7912_()), CommonHelper.mapOfKeys(DyeColor.class, dyeColor -> new ResourceLocation("alekiships", "textures/entity/watercraft/sloop/" + vanillaWood.m_7912_() + "/" + dyeColor.m_7912_())));
    }

    public SloopRenderer(EntityRendererProvider.Context context, ResourceLocation sloopTexture, EnumMap<DyeColor, ResourceLocation> paintTextures) {
        super(context);
        this.f_114477_ = 0.8f;
        this.sloopTexture = sloopTexture;
        this.paintTextures = paintTextures;
        this.font = context.m_174028_();
    }

    public void render(SloopEntity sloopEntity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        if (LightTexture.m_109883_((int)packedLight) < sloopEntity.getCompartmentBlockLight()) {
            packedLight = LightTexture.m_109885_((int)sloopEntity.getCompartmentBlockLight(), (int)this.m_114508_(sloopEntity, sloopEntity.m_20183_()));
        }
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.5, 0.0);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - entityYaw));
        poseStack.m_252880_(0.0f, 1.0625f, 0.0f);
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(0.0f));
        if (!sloopEntity.isFunctional()) {
            poseStack.m_252781_(Axis.f_252403_.m_252977_((float)(sloopEntity.m_19879_() % 30)));
        }
        this.sloopModel.setupAnim(sloopEntity, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexconsumer = bufferSource.m_6299_(this.sloopModel.m_103119_(this.getTextureLocation(sloopEntity)));
        if (sloopEntity.f_19797_ < 1) {
            poseStack.m_85849_();
            super.m_7392_((Entity)sloopEntity, entityYaw, partialTicks, poseStack, bufferSource, packedLight);
            return;
        }
        this.sloopModel.m_7695_(poseStack, vertexconsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (sloopEntity.m_8077_()) {
            this.sloopModel.getNameplate().m_104306_(poseStack, vertexconsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (sloopEntity.breaksIce()) {
            this.sloopModel.getIcebreaker().m_104306_(poseStack, vertexconsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (sloopEntity.getMainsailActive()) {
            this.sloopModel.getMainsailDeployedParts().m_104306_(poseStack, vertexconsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            this.sloopModel.getMainsail().m_104306_(poseStack, bufferSource.m_6299_(RenderType.m_110452_((ResourceLocation)this.getMainsailTexture(sloopEntity))), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            this.sloopModel.getMainsailFurledParts().m_104306_(poseStack, vertexconsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            this.sloopModel.getMainsailFurledParts().m_104306_(poseStack, bufferSource.m_6299_(RenderType.m_110452_((ResourceLocation)this.getMainsailTexture(sloopEntity))), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (sloopEntity.getJibsailActive()) {
            this.sloopModel.getJibsail().m_104306_(poseStack, bufferSource.m_6299_(RenderType.m_110452_((ResourceLocation)this.getJibsailTexture(sloopEntity))), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            this.sloopModel.getJibsailFurled().m_104306_(poseStack, bufferSource.m_6299_(RenderType.m_110452_((ResourceLocation)this.getJibsailTexture(sloopEntity))), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (!sloopEntity.m_5842_() && (double)sloopEntity.getDamage() < (double)sloopEntity.getDamageThreshold() * 0.9) {
            VertexConsumer vertexconsumer1 = bufferSource.m_6299_(RenderType.m_110478_());
            this.sloopModel.getWaterocclusion().m_104301_(poseStack, vertexconsumer1, packedLight, OverlayTexture.f_118083_);
        }
        if (sloopEntity.getDamage() > 0.0f) {
            VertexConsumer damageVertexConsumer = bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)DAMAGE_OVERLAY));
            float alpha = Mth.m_14036_((float)(sloopEntity.getDamage() / sloopEntity.getDamageThreshold() * 0.75f), (float)0.0f, (float)0.75f);
            this.sloopModel.m_7695_(poseStack, damageVertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, alpha);
        }
        poseStack.m_85849_();
        if (sloopEntity.m_8077_() && sloopEntity.isFunctional()) {
            String name = sloopEntity.m_7755_().getString();
            int length = 20;
            if (name.length() > length) {
                name = name.substring(0, length);
            }
            float scale = 0.015625f;
            Vec3 pos = new Vec3(-1.327, 0.885, 2.4).m_82524_((float)Math.toRadians(-entityYaw));
            if (name.length() > 12) {
                scale /= (float)name.length() / 13.0f;
            }
            AlekiShipsRenderHelper.renderTextLine(pos, -60.0f - entityYaw, scale, this.font, name, poseStack, bufferSource, packedLight, 10, 40);
            pos = new Vec3(0.9, 1.005, -3.1).m_82524_((float)Math.toRadians(-entityYaw));
            AlekiShipsRenderHelper.renderTextLine(pos, 180.0f - entityYaw, scale, this.font, name, poseStack, bufferSource, packedLight, 10, 40);
        }
        super.m_7392_((Entity)sloopEntity, entityYaw, partialTicks, poseStack, bufferSource, packedLight);
    }

    public ResourceLocation getTextureLocation(SloopEntity sloopEntity) {
        return sloopEntity.getPaintColor().map(this.paintTextures::get).orElse(this.sloopTexture);
    }

    public ResourceLocation getMainsailTexture(SloopEntity sloopEntity) {
        return SAIL_TEXTURES.get(sloopEntity.getMainsailDye());
    }

    public ResourceLocation getJibsailTexture(SloopEntity sloopEntity) {
        return SAIL_TEXTURES.get(sloopEntity.getJibsailDye());
    }
}

