/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.client.render.entity.vehicle;

import com.alekiponi.alekiships.client.model.entity.AnchorEntityModel;
import com.alekiponi.alekiships.client.model.entity.SloopConstructionModel;
import com.alekiponi.alekiships.common.block.AlekiShipsBlocks;
import com.alekiponi.alekiships.common.block.AngledBoatFrameBlock;
import com.alekiponi.alekiships.common.block.FlatBoatFrameBlock;
import com.alekiponi.alekiships.common.entity.vehicle.SloopUnderConstructionEntity;
import com.alekiponi.alekiships.util.VanillaWood;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SloopConstructionRenderer
extends EntityRenderer<SloopUnderConstructionEntity> {
    protected final SloopConstructionModel sloopModel = new SloopConstructionModel();
    protected final AnchorEntityModel anchorModel = new AnchorEntityModel();
    protected final ResourceLocation sloopTexture;
    private static final ResourceLocation ANCHOR = new ResourceLocation("alekiships", "textures/entity/watercraft/anchor.png");
    private final BlockRenderDispatcher blockRenderer;

    public SloopConstructionRenderer(EntityRendererProvider.Context context, VanillaWood vanillaWood) {
        this(context, new ResourceLocation("alekiships", "textures/entity/watercraft/sloop_construction/" + vanillaWood.m_7912_() + ".png"));
    }

    public SloopConstructionRenderer(EntityRendererProvider.Context context, ResourceLocation sloopTexture) {
        super(context);
        this.f_114477_ = 0.8f;
        this.sloopTexture = sloopTexture;
        this.blockRenderer = context.m_234597_();
    }

    public void render(SloopUnderConstructionEntity constructionEntity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.5, 0.0);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - entityYaw));
        poseStack.m_252880_(0.0f, 1.0625f, 0.0f);
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(0.0f));
        if (constructionEntity.f_19797_ < 1) {
            poseStack.m_85849_();
            super.m_7392_((Entity)constructionEntity, entityYaw, partialTicks, poseStack, bufferSource, packedLight);
            return;
        }
        poseStack.m_252880_(0.0f, 1.57f, 0.0f);
        VertexConsumer vertexConsumer = bufferSource.m_6299_(this.sloopModel.m_103119_(this.getTextureLocation(constructionEntity)));
        this.sloopModel.m_7695_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (constructionEntity.getConstructionStage().ordinal() >= SloopUnderConstructionEntity.ConstructionState.DECK.ordinal()) {
            this.sloopModel.getKeel().m_104306_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (constructionEntity.getConstructionStage().ordinal() >= SloopUnderConstructionEntity.ConstructionState.BOWSPRIT.ordinal()) {
            for (ModelPart part : this.sloopModel.getDeck()) {
                part.m_104306_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
        if (constructionEntity.getConstructionStage().ordinal() >= SloopUnderConstructionEntity.ConstructionState.MAST.ordinal()) {
            this.sloopModel.getBowsprit().m_104306_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (constructionEntity.getConstructionStage().ordinal() >= SloopUnderConstructionEntity.ConstructionState.BOOM.ordinal()) {
            this.sloopModel.getMast().m_104306_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (constructionEntity.getConstructionStage().ordinal() >= SloopUnderConstructionEntity.ConstructionState.MAINSAIL.ordinal()) {
            this.sloopModel.getBoomGaff()[0].m_104306_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (constructionEntity.getConstructionStage().ordinal() >= SloopUnderConstructionEntity.ConstructionState.JIBSAIl.ordinal()) {
            this.sloopModel.getMainsail().m_104306_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (constructionEntity.getConstructionStage().ordinal() >= SloopUnderConstructionEntity.ConstructionState.RAILINGS_STERN.ordinal()) {
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, -1.57f, 0.0f);
            this.sloopModel.getJibsailFurled().m_104306_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            poseStack.m_85849_();
        }
        if (constructionEntity.getConstructionStage().ordinal() >= SloopUnderConstructionEntity.ConstructionState.RAILINGS_BOW.ordinal()) {
            for (ModelPart part : this.sloopModel.getSternRailing()) {
                part.m_104306_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
        if (constructionEntity.getConstructionStage().ordinal() >= SloopUnderConstructionEntity.ConstructionState.ANCHOR.ordinal()) {
            for (ModelPart part : this.sloopModel.getBowRailing()) {
                part.m_104306_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
        if (constructionEntity.getConstructionStage().ordinal() >= SloopUnderConstructionEntity.ConstructionState.RIGGING.ordinal()) {
            poseStack.m_85836_();
            poseStack.m_85837_(2.640000033378601, -0.9199999999999999, -3.27);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(60.0f));
            VertexConsumer vertexConsumerAnchor = bufferSource.m_6299_(this.anchorModel.m_103119_(ANCHOR));
            this.anchorModel.m_7695_(poseStack, vertexConsumerAnchor, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            poseStack.m_85849_();
        }
        poseStack.m_252880_(0.0f, -1.58f, 0.0f);
        BlockState blockstate = (BlockState)((BlockState)((AngledBoatFrameBlock)((Object)AlekiShipsBlocks.BOAT_FRAME_ANGLED.get())).m_49966_().m_61124_((Property)AngledBoatFrameBlock.FACING, (Comparable)Direction.WEST)).m_61124_(AngledBoatFrameBlock.SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
        poseStack.m_85836_();
        poseStack.m_85837_(1.0, 0.5625, 2.0);
        this.blockRenderer.m_110912_(blockstate, poseStack, bufferSource, packedLight, OverlayTexture.f_118083_);
        poseStack.m_85849_();
        blockstate = (BlockState)((BlockState)((AngledBoatFrameBlock)((Object)AlekiShipsBlocks.BOAT_FRAME_ANGLED.get())).m_49966_().m_61124_((Property)AngledBoatFrameBlock.FACING, (Comparable)Direction.EAST)).m_61124_(AngledBoatFrameBlock.SHAPE, (Comparable)StairsShape.OUTER_LEFT);
        poseStack.m_85836_();
        poseStack.m_85837_(-2.0, 0.5625, 2.0);
        this.blockRenderer.m_110912_(blockstate, poseStack, bufferSource, packedLight, OverlayTexture.f_118083_);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.5625, 2.0);
        blockstate = ((AngledBoatFrameBlock)((Object)AlekiShipsBlocks.BOAT_FRAME_ANGLED.get())).m_49966_();
        this.blockRenderer.m_110912_(blockstate, poseStack, bufferSource, packedLight, OverlayTexture.f_118083_);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_85837_(-1.0, 0.5625, 2.0);
        blockstate = ((AngledBoatFrameBlock)((Object)AlekiShipsBlocks.BOAT_FRAME_ANGLED.get())).m_49966_();
        this.blockRenderer.m_110912_(blockstate, poseStack, bufferSource, packedLight, OverlayTexture.f_118083_);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_85837_(-2.0, 0.5625, 1.0);
        blockstate = (BlockState)((AngledBoatFrameBlock)((Object)AlekiShipsBlocks.BOAT_FRAME_ANGLED.get())).m_49966_().m_61124_((Property)AngledBoatFrameBlock.FACING, (Comparable)Direction.EAST);
        this.blockRenderer.m_110912_(blockstate, poseStack, bufferSource, packedLight, OverlayTexture.f_118083_);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_85837_(-2.0, 0.5625, 0.0);
        blockstate = (BlockState)((AngledBoatFrameBlock)((Object)AlekiShipsBlocks.BOAT_FRAME_ANGLED.get())).m_49966_().m_61124_((Property)AngledBoatFrameBlock.FACING, (Comparable)Direction.EAST);
        this.blockRenderer.m_110912_(blockstate, poseStack, bufferSource, packedLight, OverlayTexture.f_118083_);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_85837_(-2.0, 0.5625, -1.0);
        blockstate = (BlockState)((AngledBoatFrameBlock)((Object)AlekiShipsBlocks.BOAT_FRAME_ANGLED.get())).m_49966_().m_61124_((Property)AngledBoatFrameBlock.FACING, (Comparable)Direction.EAST);
        this.blockRenderer.m_110912_(blockstate, poseStack, bufferSource, packedLight, OverlayTexture.f_118083_);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_85837_(-2.0, 0.5625, -2.0);
        blockstate = (BlockState)((BlockState)((AngledBoatFrameBlock)((Object)AlekiShipsBlocks.BOAT_FRAME_ANGLED.get())).m_49966_().m_61124_((Property)AngledBoatFrameBlock.FACING, (Comparable)Direction.SOUTH)).m_61124_(AngledBoatFrameBlock.SHAPE, (Comparable)StairsShape.OUTER_LEFT);
        this.blockRenderer.m_110912_(blockstate, poseStack, bufferSource, packedLight, OverlayTexture.f_118083_);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_85837_(1.0, 0.5625, 1.0);
        blockstate = (BlockState)((AngledBoatFrameBlock)((Object)AlekiShipsBlocks.BOAT_FRAME_ANGLED.get())).m_49966_().m_61124_((Property)AngledBoatFrameBlock.FACING, (Comparable)Direction.WEST);
        this.blockRenderer.m_110912_(blockstate, poseStack, bufferSource, packedLight, OverlayTexture.f_118083_);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_85837_(1.0, 0.5625, 0.0);
        blockstate = (BlockState)((AngledBoatFrameBlock)((Object)AlekiShipsBlocks.BOAT_FRAME_ANGLED.get())).m_49966_().m_61124_((Property)AngledBoatFrameBlock.FACING, (Comparable)Direction.WEST);
        this.blockRenderer.m_110912_(blockstate, poseStack, bufferSource, packedLight, OverlayTexture.f_118083_);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_85837_(1.0, 0.5625, -1.0);
        blockstate = (BlockState)((AngledBoatFrameBlock)((Object)AlekiShipsBlocks.BOAT_FRAME_ANGLED.get())).m_49966_().m_61124_((Property)AngledBoatFrameBlock.FACING, (Comparable)Direction.WEST);
        this.blockRenderer.m_110912_(blockstate, poseStack, bufferSource, packedLight, OverlayTexture.f_118083_);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_85837_(1.0, 0.5625, -2.0);
        blockstate = (BlockState)((BlockState)((AngledBoatFrameBlock)((Object)AlekiShipsBlocks.BOAT_FRAME_ANGLED.get())).m_49966_().m_61124_((Property)AngledBoatFrameBlock.FACING, (Comparable)Direction.SOUTH)).m_61124_(AngledBoatFrameBlock.SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
        this.blockRenderer.m_110912_(blockstate, poseStack, bufferSource, packedLight, OverlayTexture.f_118083_);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.5625, -2.0);
        blockstate = (BlockState)((BlockState)((AngledBoatFrameBlock)((Object)AlekiShipsBlocks.BOAT_FRAME_ANGLED.get())).m_49966_().m_61124_((Property)AngledBoatFrameBlock.FACING, (Comparable)Direction.WEST)).m_61124_(AngledBoatFrameBlock.SHAPE, (Comparable)StairsShape.INNER_LEFT);
        this.blockRenderer.m_110912_(blockstate, poseStack, bufferSource, packedLight, OverlayTexture.f_118083_);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_85837_(-1.0, 0.5625, -2.0);
        blockstate = (BlockState)((BlockState)((AngledBoatFrameBlock)((Object)AlekiShipsBlocks.BOAT_FRAME_ANGLED.get())).m_49966_().m_61124_((Property)AngledBoatFrameBlock.FACING, (Comparable)Direction.EAST)).m_61124_(AngledBoatFrameBlock.SHAPE, (Comparable)StairsShape.INNER_RIGHT);
        this.blockRenderer.m_110912_(blockstate, poseStack, bufferSource, packedLight, OverlayTexture.f_118083_);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.5625, -3.0);
        blockstate = (BlockState)((AngledBoatFrameBlock)((Object)AlekiShipsBlocks.BOAT_FRAME_ANGLED.get())).m_49966_().m_61124_((Property)AngledBoatFrameBlock.FACING, (Comparable)Direction.WEST);
        this.blockRenderer.m_110912_(blockstate, poseStack, bufferSource, packedLight, OverlayTexture.f_118083_);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_85837_(-1.0, 0.5625, -3.0);
        blockstate = (BlockState)((AngledBoatFrameBlock)((Object)AlekiShipsBlocks.BOAT_FRAME_ANGLED.get())).m_49966_().m_61124_((Property)AngledBoatFrameBlock.FACING, (Comparable)Direction.EAST);
        this.blockRenderer.m_110912_(blockstate, poseStack, bufferSource, packedLight, OverlayTexture.f_118083_);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.5625, -4.0);
        blockstate = (BlockState)((BlockState)((AngledBoatFrameBlock)((Object)AlekiShipsBlocks.BOAT_FRAME_ANGLED.get())).m_49966_().m_61124_((Property)AngledBoatFrameBlock.FACING, (Comparable)Direction.SOUTH)).m_61124_(AngledBoatFrameBlock.SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
        this.blockRenderer.m_110912_(blockstate, poseStack, bufferSource, packedLight, OverlayTexture.f_118083_);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_85837_(-1.0, 0.5625, -4.0);
        blockstate = (BlockState)((BlockState)((AngledBoatFrameBlock)((Object)AlekiShipsBlocks.BOAT_FRAME_ANGLED.get())).m_49966_().m_61124_((Property)AngledBoatFrameBlock.FACING, (Comparable)Direction.SOUTH)).m_61124_(AngledBoatFrameBlock.SHAPE, (Comparable)StairsShape.OUTER_LEFT);
        this.blockRenderer.m_110912_(blockstate, poseStack, bufferSource, packedLight, OverlayTexture.f_118083_);
        poseStack.m_85849_();
        for (int i = 0; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                poseStack.m_85836_();
                poseStack.m_85837_((double)(-16 * i) / 16.0, 1.0625, 16.0 * (double)j / 16.0);
                blockstate = ((FlatBoatFrameBlock)((Object)AlekiShipsBlocks.BOAT_FRAME_FLAT.get())).m_49966_();
                this.blockRenderer.m_110912_(blockstate, poseStack, bufferSource, packedLight, OverlayTexture.f_118083_);
                poseStack.m_85849_();
            }
        }
        poseStack.m_85849_();
        super.m_7392_((Entity)constructionEntity, entityYaw, partialTicks, poseStack, bufferSource, packedLight);
    }

    public ResourceLocation getTextureLocation(SloopUnderConstructionEntity constructionEntity) {
        return this.sloopTexture;
    }
}

