/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.surface;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Supplier;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.soil.SoilBlockType;
import net.dries007.tfc.world.noise.Noise2D;
import net.dries007.tfc.world.noise.OpenSimplex2D;
import net.dries007.tfc.world.surface.SurfaceBuilderContext;
import net.dries007.tfc.world.surface.SurfaceState;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class SoilSurfaceState
implements SurfaceState {
    public static final Noise2D PATCH_NOISE = new OpenSimplex2D(18273952837592L).octaves(2).spread(0.04f);
    private final List<SurfaceState> regions;

    public static SurfaceState buildType(SoilBlockType type) {
        ImmutableList regions = ImmutableList.of((Object)SoilSurfaceState.sand(), (Object)SoilSurfaceState.transition(SoilSurfaceState.sand(), SoilSurfaceState.soil(type, SoilBlockType.Variant.SANDY_LOAM)), (Object)SoilSurfaceState.soil(type, SoilBlockType.Variant.SANDY_LOAM), (Object)SoilSurfaceState.transition(SoilSurfaceState.soil(type, SoilBlockType.Variant.SANDY_LOAM), SoilSurfaceState.soil(type, SoilBlockType.Variant.LOAM)), (Object)SoilSurfaceState.soil(type, SoilBlockType.Variant.LOAM), (Object)SoilSurfaceState.transition(SoilSurfaceState.soil(type, SoilBlockType.Variant.LOAM), SoilSurfaceState.soil(type, SoilBlockType.Variant.SILTY_LOAM)), (Object)SoilSurfaceState.soil(type, SoilBlockType.Variant.SILTY_LOAM), (Object)SoilSurfaceState.transition(SoilSurfaceState.soil(type, SoilBlockType.Variant.SILTY_LOAM), SoilSurfaceState.soil(type, SoilBlockType.Variant.SILT)), (Object)SoilSurfaceState.soil(type, SoilBlockType.Variant.SILT));
        return type == SoilBlockType.GRASS ? new NeedsPostProcessing((List<SurfaceState>)regions) : new SoilSurfaceState((List<SurfaceState>)regions);
    }

    public static SurfaceState buildSandOrGravel(boolean sandIsSandstone) {
        SurfaceState sand = sandIsSandstone ? SoilSurfaceState.sandstone() : SoilSurfaceState.sand();
        SurfaceState gravel = SoilSurfaceState.gravel();
        return new SoilSurfaceState((List<SurfaceState>)ImmutableList.of((Object)sand, (Object)SoilSurfaceState.transition(sand, gravel), (Object)gravel, (Object)gravel, (Object)gravel, (Object)gravel, (Object)gravel, (Object)gravel, (Object)gravel));
    }

    private static SurfaceState transition(SurfaceState first, SurfaceState second) {
        return context -> {
            BlockPos pos = context.pos();
            double noise = PATCH_NOISE.noise(pos.m_123341_(), pos.m_123343_());
            return noise > 0.0 ? first.getState(context) : second.getState(context);
        };
    }

    private static SurfaceState sand() {
        return context -> context.getRock().sand().m_49966_();
    }

    private static SurfaceState sandstone() {
        return context -> context.getRock().sandstone().m_49966_();
    }

    private static SurfaceState gravel() {
        return context -> context.getRock().gravel().m_49966_();
    }

    private static SurfaceState soil(SoilBlockType type, SoilBlockType.Variant variant) {
        Supplier block = (Supplier)TFCBlocks.SOIL.get((Object)type).get(variant);
        return arg_0 -> SoilSurfaceState.lambda$soil$4((Supplier)block, arg_0);
    }

    private SoilSurfaceState(List<SurfaceState> regions) {
        this.regions = regions;
    }

    @Override
    public BlockState getState(SurfaceBuilderContext context) {
        float rainfall = context.rainfall();
        int index = (int)Mth.m_184631_((float)rainfall, (float)20.0f, (float)500.0f, (float)0.0f, (float)((float)this.regions.size() - 0.01f));
        return this.regions.get(index).getState(context);
    }

    private static /* synthetic */ BlockState lambda$soil$4(Supplier block, SurfaceBuilderContext context) {
        return ((Block)block.get()).m_49966_();
    }

    static class NeedsPostProcessing
    extends SoilSurfaceState {
        private NeedsPostProcessing(List<SurfaceState> regions) {
            super(regions);
        }

        @Override
        public void setState(SurfaceBuilderContext context) {
            context.chunk().m_6978_(context.pos(), this.getState(context), false);
            context.chunk().m_8113_(context.pos());
        }
    }
}

