/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.stateprovider;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.util.collections.IWeighted;
import net.dries007.tfc.world.feature.tree.RootConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public record SpecialRootPlacer(float skewChance) {
    public static final Codec<SpecialRootPlacer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("skew_chance").forGetter(c -> Float.valueOf(c.skewChance))).apply((Applicative)instance, SpecialRootPlacer::new));

    public boolean placeRoots(WorldGenLevel level, RandomSource random, BlockPos pos, BlockPos trunkOrigin, RootConfig config) {
        ArrayList positions = Lists.newArrayList();
        BlockPos.MutableBlockPos cursor = pos.m_122032_();
        while (cursor.m_123342_() < trunkOrigin.m_123342_()) {
            if (!this.canPlaceRoot(level, (BlockPos)cursor, config)) {
                return false;
            }
            cursor.m_122184_(0, 1, 0);
        }
        positions.add(trunkOrigin.m_7495_());
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            ArrayList used;
            BlockPos relativePos = trunkOrigin.m_121945_(direction);
            if (!this.simulateRoots(level, random, relativePos, direction, trunkOrigin, used = Lists.newArrayList(), 0, config)) {
                return false;
            }
            positions.addAll(used);
            positions.add(trunkOrigin.m_121945_(direction));
        }
        for (BlockPos rootPos : positions) {
            this.placeRoot(level, random, rootPos, config);
        }
        return true;
    }

    private boolean simulateRoots(WorldGenLevel level, RandomSource random, BlockPos pos, Direction direction, BlockPos trunkOrigin, List<BlockPos> roots, int length, RootConfig config) {
        int maxLength = config.height();
        if (length != maxLength && roots.size() <= maxLength) {
            for (BlockPos blockpos : this.potentialRootPositions(pos, direction, random, trunkOrigin, config)) {
                if (!this.canPlaceRoot(level, blockpos, config)) continue;
                roots.add(blockpos);
                if (this.simulateRoots(level, random, blockpos, direction, trunkOrigin, roots, length + 1, config)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private List<BlockPos> potentialRootPositions(BlockPos pos, Direction direction, RandomSource random, BlockPos origin, RootConfig config) {
        BlockPos belowPos = pos.m_7495_();
        BlockPos relativePos = pos.m_121945_(direction);
        int dist = pos.m_123333_((Vec3i)origin);
        int width = config.width();
        float f = this.skewChance;
        if (dist > width - 3 && dist <= width) {
            return random.m_188501_() < f ? List.of(belowPos, relativePos.m_7495_()) : List.of(belowPos);
        }
        if (dist > width) {
            return List.of(belowPos);
        }
        if (random.m_188501_() < f) {
            return List.of(belowPos);
        }
        return random.m_188499_() ? List.of(relativePos) : List.of(belowPos);
    }

    private boolean canPlaceRoot(WorldGenLevel level, BlockPos pos, RootConfig config) {
        BlockState state = level.m_8055_(pos);
        return FluidHelpers.isAirOrEmptyFluid(state) || config.blocks().get(state.m_60734_()) != null;
    }

    private void placeRoot(WorldGenLevel level, RandomSource random, BlockPos pos, RootConfig config) {
        if (this.canPlaceRoot(level, pos, config)) {
            BlockState stateAt = level.m_8055_(pos);
            IWeighted<BlockState> weighted = config.blocks().get(stateAt.m_60734_());
            BlockState toPlace = weighted != null ? weighted.get(random) : ((Block)TFCBlocks.TREE_ROOTS.get()).m_49966_();
            BlockState filled = FluidHelpers.fillWithFluid(toPlace, level.m_6425_(pos).m_76152_());
            level.m_7731_(pos, filled == null ? toPlace : filled, 19);
        }
    }
}

