/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.river;

import net.dries007.tfc.world.noise.Noise2D;
import net.dries007.tfc.world.noise.Noise3D;
import net.dries007.tfc.world.noise.OpenSimplex2D;
import net.dries007.tfc.world.noise.OpenSimplex3D;
import net.dries007.tfc.world.river.RiverInfo;
import net.dries007.tfc.world.river.RiverNoiseSampler;
import net.minecraft.util.Mth;

public final class RiverNoise {
    public static RiverNoiseSampler wide(final long seed) {
        return new RiverNoiseSampler(){
            final Noise2D baseNoise;
            final Noise2D distNoise;
            double height;
            {
                this.baseNoise = new OpenSimplex2D(seed).octaves(4).spread(0.05f).scaled(-2.5, 1.5);
                this.distNoise = new OpenSimplex2D(seed + 71892341L).octaves(4).spread(0.05f).scaled(-0.15f, 0.15f);
            }

            @Override
            public double setColumnAndSampleHeight(RiverInfo info, int x, int z, double heightIn, double caveWeight) {
                double distFac = info.normDistSq() * (double)0.8f + this.distNoise.noise(x, z);
                double riverHeight = 58.0 + distFac * 7.0 + this.baseNoise.noise(x, z);
                this.height = Math.min(riverHeight, heightIn);
                return this.height;
            }

            @Override
            public double noise(int y, double noiseIn) {
                return (double)y > this.height ? 0.0 : noiseIn;
            }
        };
    }

    public static RiverNoiseSampler canyon(final long seed) {
        return new RiverNoiseSampler(){
            final Noise2D baseNoise;
            final Noise2D distNoise;
            final Noise2D lowFreqCliffNoise;
            double height;
            {
                this.baseNoise = new OpenSimplex2D(seed).octaves(4).spread(0.05f).scaled(-7.0, 3.0);
                this.distNoise = new OpenSimplex2D(seed + 971823749132L).octaves(4).spread(0.05f).scaled(-0.3f, 0.2f);
                this.lowFreqCliffNoise = new OpenSimplex2D(seed + 7189234132L).spread(7.0E-4f).clamped(0.0, 1.0);
            }

            @Override
            public double setColumnAndSampleHeight(RiverInfo info, int x, int z, double heightIn, double caveWeight) {
                double distFac = info.normDistSq() * 1.3 + this.distNoise.noise(x, z);
                double adjDistFac = distFac > 0.6 ? distFac * 0.4 + 0.8 : distFac;
                double riverHeight = 55.0 + Mth.m_14139_((double)this.lowFreqCliffNoise.noise(x, z), (double)distFac, (double)adjDistFac) * 16.0 + this.baseNoise.noise(x, z);
                this.height = Math.min(riverHeight, heightIn);
                return this.height;
            }

            @Override
            public double noise(int y, double noiseIn) {
                return (double)y > this.height ? 0.0 : noiseIn;
            }
        };
    }

    public static RiverNoiseSampler tallCanyon(final long seed) {
        return new RiverNoiseSampler(){
            final Noise2D baseNoise;
            final Noise2D distNoise;
            final Noise3D cliffNoise;
            private double distFac;
            private int x;
            private int z;
            {
                this.baseNoise = new OpenSimplex2D(seed).octaves(4).spread(0.05f).scaled(-7.0, 3.0);
                this.distNoise = new OpenSimplex2D(seed + 971823749132L).octaves(4).spread(0.05f).scaled(-0.3f, 0.2f);
                this.cliffNoise = new OpenSimplex3D(seed).octaves(2).spread(0.1f).scaled(0.0, 3.0);
            }

            @Override
            public double setColumnAndSampleHeight(RiverInfo info, int x, int z, double heightIn, double caveWeight) {
                double distFac = info.normDistSq() * 1.3 + this.distNoise.noise(x, z);
                double adjDistFac = distFac > 0.32 ? distFac * 0.2 + 1.6 : distFac;
                double riverHeight = 55.0 + adjDistFac * 16.0 + this.baseNoise.noise(x, z);
                this.distFac = Math.max(0.0, distFac * 0.7);
                this.x = x;
                this.z = z;
                return Math.min(riverHeight, heightIn);
            }

            @Override
            public double noise(int y, double noiseIn) {
                return Mth.m_14085_((double)this.rawNoise(y), (double)noiseIn, (double)this.distFac);
            }

            private double rawNoise(int y) {
                if (y > 98) {
                    return 0.0;
                }
                if (y > 83) {
                    double easing = 1.0f - (float)(y - 63 - 20) / 15.0f;
                    return easing * this.cliffNoise.noise(this.x, y, this.z);
                }
                if (y > 63) {
                    return this.cliffNoise.noise(this.x, y, this.z);
                }
                if (y > 55) {
                    double easing = (double)(y - 63 + 8) / 8.0;
                    return easing * this.cliffNoise.noise(this.x, y, this.z);
                }
                return 0.0;
            }
        };
    }

    public static RiverNoiseSampler cave(final long seed) {
        return new RiverNoiseSampler(){
            final Noise2D carvingCenterNoise;
            final Noise2D carvingHeightNoise;
            double weight;
            double height;
            double carvingHeight;
            double carvingCenter;
            {
                this.carvingCenterNoise = new OpenSimplex2D(seed).octaves(2).spread(0.02f).scaled(60.0, 66.0);
                this.carvingHeightNoise = new OpenSimplex2D(seed + 1197823749123L).octaves(4).spread(0.15f).scaled(8.0, 14.0);
            }

            @Override
            public double setColumnAndSampleHeight(RiverInfo info, int x, int z, double heightIn, double caveWeight) {
                this.weight = Mth.m_14008_((double)(info.normDistSq() * 1.3 - 0.1), (double)0.0, (double)1.0);
                this.height = heightIn;
                this.carvingHeight = this.carvingHeightNoise.noise(x, z);
                this.carvingCenter = this.carvingCenterNoise.noise(x, z);
                double minHeight = this.carvingCenter - this.carvingHeight;
                double maxHeight = this.carvingCenter + this.carvingHeight;
                if (caveWeight > 0.75) {
                    return heightIn;
                }
                if (caveWeight > 0.25) {
                    double canyonMaxHeight = Math.min(55.0 + info.normDistSq() * 1.3 * 16.0, heightIn);
                    double interiorHeight = caveWeight > 0.5 ? Mth.m_144914_((double)caveWeight, (double)0.5, (double)0.75, (double)Math.min(maxHeight, heightIn), (double)heightIn) : Math.min(heightIn, Mth.m_144914_((double)caveWeight, (double)0.25, (double)0.5, (double)canyonMaxHeight, (double)minHeight));
                    double exteriorHeight = caveWeight > 0.5 ? Mth.m_144914_((double)caveWeight, (double)0.5, (double)0.75, (double)Math.min(canyonMaxHeight, heightIn), (double)heightIn) : canyonMaxHeight;
                    this.height = Mth.m_14139_((double)this.weight, (double)interiorHeight, (double)exteriorHeight);
                    return this.height;
                }
                return heightIn;
            }

            @Override
            public double noise(int y, double noiseIn) {
                double distance = Math.abs((double)y - this.carvingCenter) / this.carvingHeight;
                double noise = Math.max(1.0 - distance * distance, 0.0);
                return Mth.m_14139_((double)this.weight, (double)noise, (double)noiseIn);
            }
        };
    }
}

