/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.region;

public final class Units {
    public static final int PARTITION_BITS = 5;
    public static final int PARTITION_BIT_MASK = 31;
    public static final int PARTITION_WIDTH_IN_GRID = 3;
    public static final int CELL_WIDTH_IN_PARTITION = 32;
    public static final int CELL_WIDTH_IN_GRID = 96;
    public static final int REGION_RADIUS_IN_GRID = 100;
    public static final int REGION_WIDTH_IN_GRID = 201;
    public static final int QUART_BITS = 2;
    public static final int GRID_BITS = 7;
    public static final int GRID_WIDTH_IN_BLOCK = 128;
    public static final int GRID_WIDTH_IN_QUART = 32;

    public static int cellToPart(int cell) {
        return cell << 5;
    }

    public static int partToCell(int part) {
        return part >> 5;
    }

    public static int gridToCell(int grid) {
        return Math.floorDiv(grid, 96);
    }

    public static int cellToGrid(int cell) {
        return cell * 96;
    }

    public static int gridToPart(int grid) {
        return Math.floorDiv(grid, 3);
    }

    public static int partToGrid(int part) {
        return part * 3;
    }

    public static int quartToGrid(int quart) {
        return quart >> 5;
    }

    public static double quartToGridExact(double quart) {
        return quart / 32.0;
    }

    public static int gridToQuart(int grid) {
        return grid << 5;
    }

    public static double blockToGridExact(double block) {
        return block / 128.0;
    }

    public static int blockToGrid(int block) {
        return block >> 7;
    }

    public static int index(int x, int z) {
        return x & 0xF | (z & 0xF) << 4;
    }
}

