/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.region;

import java.util.ArrayList;
import java.util.List;
import net.dries007.tfc.world.region.RiverEdge;
import net.dries007.tfc.world.region.Units;

public record RegionPartition(int minPartX, int minPartZ, Point[] data) {
    RegionPartition(int cellX, int cellZ) {
        this(Units.cellToPart(cellX), Units.cellToPart(cellZ), new Point[1024]);
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = new Point(new ArrayList<RiverEdge>());
        }
    }

    public Point getFromPart(int partX, int partZ) {
        return this.data[this.index(partX, partZ)];
    }

    public Point get(int gridX, int gridZ) {
        return this.data[this.index(Units.gridToPart(gridX) - this.minPartX, Units.gridToPart(gridZ) - this.minPartZ)];
    }

    public boolean isIn(int partX, int partZ) {
        int localX = partX - this.minPartX;
        int localZ = partZ - this.minPartZ;
        return localX >= 0 && localZ >= 0 && localX < 32 && localZ < 32;
    }

    private int index(int partX, int partZ) {
        return partX & 0x1F | (partZ & 0x1F) << 5;
    }

    public record Point(List<RiverEdge> rivers) {
    }
}

