/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import net.dries007.tfc.world.Codecs;
import net.dries007.tfc.world.placement.TFCPlacements;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class BoundedCarvingMaskPlacement
extends PlacementModifier {
    public static final Codec<BoundedCarvingMaskPlacement> PLACEMENT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codecs.optionalFieldOf(VerticalAnchor.f_158914_, "min_y", VerticalAnchor.m_158921_()).forGetter(c -> c.minY), (App)Codecs.optionalFieldOf(VerticalAnchor.f_158914_, "max_y", VerticalAnchor.m_158929_()).forGetter(c -> c.maxY), (App)GenerationStep.Carving.f_64194_.fieldOf("step").forGetter(c -> c.step)).apply((Applicative)instance, BoundedCarvingMaskPlacement::new));
    private final VerticalAnchor minY;
    private final VerticalAnchor maxY;
    private final GenerationStep.Carving step;

    public BoundedCarvingMaskPlacement(VerticalAnchor minY, VerticalAnchor maxY, GenerationStep.Carving step) {
        this.minY = minY;
        this.maxY = maxY;
        this.step = step;
    }

    public PlacementModifierType<?> m_183327_() {
        return (PlacementModifierType)TFCPlacements.CARVING_MASK.get();
    }

    public Stream<BlockPos> m_213676_(PlacementContext context, RandomSource random, BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        CarvingMask carvingMask = context.m_191821_(chunkPos, this.step);
        int minY = this.minY.m_142322_((WorldGenerationContext)context);
        int maxY = this.maxY.m_142322_((WorldGenerationContext)context);
        return carvingMask.m_187589_(chunkPos).filter(p -> p.m_123342_() >= minY && p.m_123342_() <= maxY);
    }
}

