/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.noise;

import net.dries007.tfc.world.density.TFCDensityFunctions;
import net.minecraft.core.HolderGetter;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public final class NoiseSampler {
    public final DensityFunction noiseCaves;
    public final DensityFunction noodleToggle;
    public final DensityFunction noodleThickness;
    public final DensityFunction noodleRidgeA;
    public final DensityFunction noodleRidgeB;
    public final NormalNoise barrierNoise;
    public final PositionalRandomFactory positionalRandomFactory;

    public NoiseSampler(long seed, HolderGetter<NormalNoise.NoiseParameters> parameters, HolderGetter<DensityFunction> functions) {
        this.positionalRandomFactory = new XoroshiroRandomSource(seed).m_188582_();
        this.noiseCaves = this.create(functions, TFCDensityFunctions.NOISE_CAVES);
        this.noodleToggle = this.create(functions, TFCDensityFunctions.NOODLE_TOGGLE);
        this.noodleThickness = this.create(functions, TFCDensityFunctions.NOODLE_THICKNESS);
        this.noodleRidgeA = this.create(functions, TFCDensityFunctions.NOODLE_RIDGE_A);
        this.noodleRidgeB = this.create(functions, TFCDensityFunctions.NOODLE_RIDGE_B);
        this.barrierNoise = Noises.m_255421_(parameters, (PositionalRandomFactory)this.positionalRandomFactory, (ResourceKey)Noises.f_189287_);
    }

    private DensityFunction create(HolderGetter<DensityFunction> functions, ResourceKey<DensityFunction> key) {
        return ((DensityFunction)functions.m_255043_(key).m_203334_()).m_207456_((DensityFunction.Visitor)new NoiseWiringVisitor());
    }

    class NoiseWiringVisitor
    implements DensityFunction.Visitor {
        NoiseWiringVisitor() {
        }

        public DensityFunction m_214017_(DensityFunction f) {
            return f;
        }

        public DensityFunction.NoiseHolder m_213918_(DensityFunction.NoiseHolder holder) {
            NormalNoise noise = NormalNoise.m_230511_((RandomSource)NoiseSampler.this.positionalRandomFactory.m_224540_(((ResourceKey)holder.f_223997_().m_203543_().orElseThrow()).m_135782_()), (NormalNoise.NoiseParameters)((NormalNoise.NoiseParameters)holder.f_223997_().m_203334_()));
            return new DensityFunction.NoiseHolder(holder.f_223997_(), noise);
        }
    }
}

